/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.math;

import io.github.aratakileo.elegantia.math.Vector2dInterface;
import io.github.aratakileo.elegantia.math.Vector2dc;
import io.github.aratakileo.elegantia.math.Vector2iInterface;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2fc;
import org.joml.Vector2ic;

public class Vector2d
implements Vector2dInterface {
    public double x;
    public double y;

    public Vector2d(double @NotNull [] vector) {
        this.x = vector[0];
        this.y = vector[1];
    }

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    @NotNull
    public Vector2d neg() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    @Override
    @NotNull
    public Vector2d abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        return this;
    }

    @NotNull
    public Vector2d set(int index, double value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    @NotNull
    public Vector2d sub(double value) {
        return this.sub(value, value);
    }

    @Override
    @NotNull
    public Vector2d sub(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    @Override
    @NotNull
    public Vector2d sub(@NotNull Vector2iInterface vector2iInterface) {
        return this.sub(vector2iInterface.x(), vector2iInterface.y());
    }

    @Override
    @NotNull
    public Vector2d sub(@NotNull Vector2dInterface vector2dInterface) {
        return this.sub(vector2dInterface.x(), vector2dInterface.y());
    }

    @Override
    @NotNull
    public Vector2d sub(@NotNull Vector2ic vector2ic) {
        return this.sub(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2d sub(@NotNull org.joml.Vector2dc vector2dc) {
        return this.sub(vector2dc.x(), vector2dc.y());
    }

    @Override
    @NotNull
    public Vector2d sub(@NotNull Vector2fc vector2ic) {
        return this.sub(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2d add(double value) {
        return this.add(value, value);
    }

    @Override
    @NotNull
    public Vector2d add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    @Override
    @NotNull
    public Vector2d add(@NotNull Vector2iInterface vector2iInterface) {
        return this.add(vector2iInterface.x(), vector2iInterface.y());
    }

    @Override
    @NotNull
    public Vector2d add(@NotNull Vector2dInterface vector2dInterface) {
        return this.add(vector2dInterface.x(), vector2dInterface.y());
    }

    @Override
    @NotNull
    public Vector2d add(@NotNull Vector2ic vector2ic) {
        return this.add(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2d add(@NotNull org.joml.Vector2dc vector2dc) {
        return this.add(vector2dc.x(), vector2dc.y());
    }

    @Override
    @NotNull
    public Vector2d add(@NotNull Vector2fc vector2ic) {
        return this.add(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2d mul(double value) {
        return this.mul(value, value);
    }

    @Override
    @NotNull
    public Vector2d mul(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    @Override
    @NotNull
    public Vector2d mul(@NotNull Vector2iInterface vector2iInterface) {
        return this.mul(vector2iInterface.x(), vector2iInterface.y());
    }

    @Override
    @NotNull
    public Vector2d mul(@NotNull Vector2dInterface vector2dInterface) {
        return this.mul(vector2dInterface.x(), vector2dInterface.y());
    }

    @Override
    @NotNull
    public Vector2d mul(@NotNull Vector2ic vector2ic) {
        return this.mul(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2d mul(@NotNull org.joml.Vector2dc vector2dc) {
        return this.mul(vector2dc.x(), vector2dc.y());
    }

    @Override
    @NotNull
    public Vector2d mul(@NotNull Vector2fc vector2fc) {
        return this.mul(vector2fc.x(), vector2fc.y());
    }

    @Override
    @NotNull
    public Vector2d div(double value) {
        return this.div(value, value);
    }

    @Override
    @NotNull
    public Vector2d div(double x, double y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    @Override
    @NotNull
    public Vector2d div(@NotNull Vector2iInterface vector2iInterface) {
        return this.div(vector2iInterface.x(), vector2iInterface.y());
    }

    @Override
    @NotNull
    public Vector2d div(@NotNull Vector2dInterface vector2dInterface) {
        return this.div(vector2dInterface.x(), vector2dInterface.y());
    }

    @Override
    @NotNull
    public Vector2d div(@NotNull Vector2ic vector2ic) {
        return this.div(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2d div(@NotNull org.joml.Vector2dc vector2dc) {
        return this.div(vector2dc.x(), vector2dc.y());
    }

    @Override
    @NotNull
    public Vector2d div(@NotNull Vector2fc vector2fc) {
        return this.div(vector2fc.x(), vector2fc.y());
    }

    @Override
    @NotNull
    public Vector2d floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        return this;
    }

    @Override
    @NotNull
    public Vector2d ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        return this;
    }

    @Override
    @NotNull
    public Vector2d round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        return this;
    }

    @Override
    @NotNull
    public Vector2d copy() {
        return new Vector2d(this.x, this.y);
    }

    @NotNull
    public Vector2dc copyAsImmutable() {
        return new Vector2dc(this.x, this.y);
    }

    public String toString() {
        return "Vector2d{%s, %s}".formatted(this.x, this.y);
    }

    @NotNull
    public static Vector2d of(@NotNull Vector2iInterface vector2iInterface) {
        return new Vector2d(vector2iInterface.x(), vector2iInterface.y());
    }

    @NotNull
    public static Vector2d of(@NotNull Vector2ic vector2ic) {
        return new Vector2d(vector2ic.x(), vector2ic.y());
    }

    @NotNull
    public static Vector2d of(@NotNull org.joml.Vector2dc vector2dc) {
        return new Vector2d(vector2dc.x(), vector2dc.y());
    }

    @NotNull
    public static Vector2d of(@NotNull Vector2fc vector2fc) {
        return new Vector2d(vector2fc.x(), vector2fc.y());
    }
}

