/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.gui.widget;

import io.github.aratakileo.elegantia.graphics.RectDrawer;
import io.github.aratakileo.elegantia.gui.widget.AbstractWidget;
import io.github.aratakileo.elegantia.math.Rect2i;
import io.github.aratakileo.elegantia.util.Mouse;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class VerticalScrollbar
extends AbstractWidget {
    private final Rect2i thumbRect;
    private final int padding;
    private int maxProgress;
    private int segmentSize;
    private int progress = 0;
    private int scrollingThumbTopToTouchOffset = -1;

    public VerticalScrollbar(@NotNull Rect2i bounds, int maxProgress, int segmentSize, int padding) {
        super(bounds);
        this.padding = padding;
        this.thumbRect = new Rect2i(0, 0, bounds.method_3319() - padding * 2, 0);
        this.setMaxProgress(maxProgress, segmentSize);
    }

    public boolean isScrolling() {
        return this.scrollingThumbTopToTouchOffset >= 0;
    }

    public int getProgress() {
        return this.progress;
    }

    @NotNull
    protected Rect2i getRenderableThumbRect() {
        return this.thumbRect.move(this.getX() + this.padding, this.getY() + this.padding);
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.setMaxProgress(maxProgress, this.segmentSize);
    }

    public void increaseMaxProgress(int increaseValue) {
        if (increaseValue == 0) {
            return;
        }
        this.setMaxProgress(this.maxProgress + increaseValue);
    }

    public void setMaxProgress(int maxProgress, int segmentSize) {
        this.maxProgress = maxProgress;
        this.segmentSize = segmentSize;
        this.thumbRect.method_35783(Math.min(this.getHeight() - 10 - this.padding * 2, Math.max(8, this.getHeight() - this.padding * 2 - maxProgress / segmentSize)));
        this.setThumbY(this.padding + this.thumbRect.method_3322());
    }

    public void setProgress(int progress) {
        this.progress = Math.min(this.maxProgress, Math.max(progress, 0));
        this.thumbRect.method_35781((int)((double)(this.getHeight() - this.thumbRect.method_3320() - this.padding * 2) * ((double)this.progress / (double)this.maxProgress)));
    }

    protected void setScrollProgressByThumbY(int localY) {
        int maxThumbTop = this.getHeight() - this.padding * 2 - this.thumbRect.method_3320();
        this.setThumbY(localY, maxThumbTop);
        this.progress = (int)((double)this.maxProgress * (double)this.thumbRect.method_3322() / (double)maxThumbTop);
    }

    protected void setThumbY(int localY) {
        int maxThumbTop = this.getHeight() - this.padding * 2 - this.thumbRect.method_3320();
        this.setThumbY(localY, maxThumbTop);
    }

    protected void setThumbY(int localY, int maxThumbTop) {
        this.thumbRect.method_35781(Math.min(Math.max(localY - this.padding, 0), maxThumbTop));
    }

    @Override
    public void renderWidget(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float dt) {
        RectDrawer.with(guiGraphics, this.bounds).draw(-1440603614).drawStroke(-1442840576, this.padding);
        RectDrawer.with(guiGraphics, this.getRenderableThumbRect()).draw(this.getRenderableThumbRect().method_3318(mouseX, mouseY) ? -1429484597 : -1435732611);
    }

    @Override
    public boolean onMouseClick(double mouseX, double mouseY) {
        if (this.getRenderableThumbRect().contains(mouseX, mouseY)) {
            this.scrollingThumbTopToTouchOffset = (int)(mouseY - (double)this.getRenderableThumbRect().method_3322());
            return true;
        }
        if (!this.isHovered) {
            return false;
        }
        this.setScrollProgressByThumbY((int)(mouseY - (double)this.getY()));
        return true;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.setProgress((int)((double)this.progress - verticalAmount));
        this.scrollingThumbTopToTouchOffset = -1;
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, double deltaX, double deltaY, @NotNull Mouse.Button button) {
        if (!this.isScrolling()) {
            return false;
        }
        this.setScrollProgressByThumbY((int)(mouseY - (double)this.getY() - (double)this.scrollingThumbTopToTouchOffset));
        return true;
    }

    @Override
    public boolean onMouseRelease(double mouseX, double mouseY) {
        this.scrollingThumbTopToTouchOffset = -1;
        return true;
    }
}

