/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.gui.widget;

import io.github.aratakileo.elegantia.Elegantia;
import io.github.aratakileo.elegantia.gui.widget.AbstractWidget;
import io.github.aratakileo.elegantia.math.Rect2i;
import io.github.aratakileo.elegantia.util.Classes;
import io.github.aratakileo.elegantia.util.Mouse;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_8021;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompositeWidget
extends AbstractWidget {
    private final List<Object> compositeParts = new ArrayList<Object>();
    private final HashMap<String, Field> lateInitCompositeParts = new HashMap();

    public CompositeWidget(@NotNull Rect2i bounds, @Nullable class_2561 message) {
        super(bounds, message);
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(CompositePart.class)) continue;
            String lateInitAnchor = field.getAnnotation(CompositePart.class).lateInitAnchor();
            if (!lateInitAnchor.isBlank()) {
                this.lateInitCompositeParts.put(lateInitAnchor, field);
                continue;
            }
            this.addNewCompositePart(field);
        }
    }

    public CompositeWidget(@NotNull Rect2i bounds) {
        this(bounds, null);
    }

    protected void declareAsInited(@NotNull String lateInitAnchor) {
        if (!this.lateInitCompositeParts.containsKey(lateInitAnchor)) {
            throw new IllegalArgumentException("Late init anchor `%s` does not exist".formatted(lateInitAnchor));
        }
        this.addNewCompositePart(this.lateInitCompositeParts.get(lateInitAnchor));
        this.lateInitCompositeParts.remove(lateInitAnchor);
    }

    private void addNewCompositePart(@NotNull Field field) {
        Object fieldValue = null;
        try {
            fieldValue = field.get(this);
        }
        catch (Exception e) {
            Elegantia.LOGGER.error("Failed to add composite part from field `%s`".formatted(Classes.getFieldView(field)));
            return;
        }
        if (Objects.isNull(fieldValue)) {
            throw new NullPointerException("Value of field `%s` of a composite part cannot be null".formatted(Classes.getFieldView(field)));
        }
        boolean isLocalised = field.getAnnotation(CompositePart.class).isLocalised();
        if (fieldValue instanceof class_8021) {
            class_8021 layoutElement = (class_8021)fieldValue;
            if (isLocalised) {
                layoutElement.method_46421(this.getX() + layoutElement.method_46426());
                layoutElement.method_46419(this.getY() + layoutElement.method_46427());
            }
        } else if (fieldValue instanceof AbstractWidget) {
            AbstractWidget abstractWidget = (AbstractWidget)fieldValue;
            if (isLocalised) {
                abstractWidget.setX(this.getX() + abstractWidget.getX());
                abstractWidget.setY(this.getY() + abstractWidget.getY());
            }
        } else if (!(fieldValue instanceof class_4068) || !(fieldValue instanceof class_364)) {
            throw new UnsupportedCompositePartException("in `%s`".formatted(Classes.getFieldView(field)));
        }
        this.compositeParts.add(fieldValue);
    }

    @Override
    public void setX(int x) {
        int valueDiff = x - this.getX();
        super.setX(x);
        for (Object widget : this.compositeParts) {
            if (widget instanceof AbstractWidget) {
                AbstractWidget abstractWidget = (AbstractWidget)widget;
                abstractWidget.setX(abstractWidget.getX() + valueDiff);
                continue;
            }
            class_8021 layoutElement = (class_8021)widget;
            layoutElement.method_46421(layoutElement.method_46426() + valueDiff);
        }
    }

    @Override
    public void setY(int y) {
        int valueDiff = y - this.getY();
        super.setY(y);
        for (Object unknownWidget : this.compositeParts) {
            if (unknownWidget instanceof AbstractWidget) {
                AbstractWidget abstractWidget = (AbstractWidget)unknownWidget;
                abstractWidget.setY(abstractWidget.getY() + valueDiff);
                continue;
            }
            class_8021 layoutElement = (class_8021)unknownWidget;
            layoutElement.method_46419(layoutElement.method_46427() + valueDiff);
        }
    }

    @Override
    public void renderWidget(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float dt) {
        super.renderWidget(guiGraphics, mouseX, mouseY, dt);
        for (Object unknownWidget : this.compositeParts) {
            ((class_4068)unknownWidget).method_25394(guiGraphics, mouseX, mouseY, dt);
        }
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        for (Object unknownWidget : this.compositeParts) {
            ((class_364)unknownWidget).method_16014(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, @NotNull Mouse.Button button) {
        for (Object unknownWidget : this.compositeParts) {
            if (!((class_364)unknownWidget).method_25402(mouseX, mouseY, button.ordinal())) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, @NotNull Mouse.Button button) {
        for (Object unknownWidget : this.compositeParts) {
            if (!((class_364)unknownWidget).method_25406(mouseX, mouseY, button.ordinal())) continue;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, double deltaX, double deltaY, @NotNull Mouse.Button button) {
        for (Object unknownWidget : this.compositeParts) {
            if (!((class_364)unknownWidget).method_25403(mouseX, mouseY, button.ordinal(), deltaX, deltaY)) continue;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, deltaX, deltaY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        for (Object unknownWidget : this.compositeParts) {
            if (!((class_364)unknownWidget).method_25401(mouseX, mouseY, verticalAmount)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (Object unknownWidget : this.compositeParts) {
            if (!((class_364)unknownWidget).method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        for (Object unknownWidget : this.compositeParts) {
            if (!((class_364)unknownWidget).method_16803(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        for (Object unknownWidget : this.compositeParts) {
            if (!((class_364)unknownWidget).method_25400(chr, modifiers)) continue;
            return true;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface CompositePart {
        public boolean isLocalised() default true;

        @NotNull
        public String lateInitAnchor() default "";
    }

    public static class UnsupportedCompositePartException
    extends RuntimeException {
        public UnsupportedCompositePartException(@NotNull String message) {
            super(message);
        }
    }
}

