/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.gui.widget;

import io.github.aratakileo.elegantia.graphics.drawable.Drawable;
import io.github.aratakileo.elegantia.graphics.drawable.InteractableDrawable;
import io.github.aratakileo.elegantia.gui.tooltip.TooltipPositioner;
import io.github.aratakileo.elegantia.math.Rect2i;
import io.github.aratakileo.elegantia.math.Vector2iInterface;
import io.github.aratakileo.elegantia.math.Vector2ic;
import io.github.aratakileo.elegantia.util.Mouse;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWidget
implements class_4068,
class_364,
class_6379 {
    private boolean isFocused = false;
    private boolean wasFocused = false;
    public boolean isEnabled = true;
    public boolean isVisible = true;
    protected boolean isHovered = false;
    protected boolean wasHovered = false;
    protected boolean wasHoveredBeforeRelease = false;
    @NotNull
    protected @NotNull Supplier<@NotNull TooltipPositioner> tooltipPositionerGetter = () -> TooltipPositioner.getSimpleTooltipPositioner(this.getBounds(), !this.isHovered && this.method_25370() && class_310.method_1551().method_48186().method_48183());
    protected float alpha = 1.0f;
    @Nullable
    protected Drawable backgroundDrawable = null;
    protected final Rect2i bounds;
    @NotNull
    private class_2561 message;
    private int tabOrderGroup;
    @Nullable
    private class_7919 tooltip;

    public AbstractWidget(@NotNull Rect2i bounds, @Nullable class_2561 message) {
        this.bounds = bounds.copy();
        this.setMessage(message);
    }

    public AbstractWidget(@NotNull Rect2i bounds) {
        this(bounds, null);
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean wasHovered() {
        return this.wasHovered;
    }

    public boolean wasHoveredBeforeRelease() {
        return this.wasHoveredBeforeRelease;
    }

    public int getWidth() {
        return this.bounds.method_3319();
    }

    public void setWidth(int width) {
        this.bounds.method_35782(width);
    }

    public int getHeight() {
        return this.bounds.method_3320();
    }

    public void setHeight(int height) {
        this.bounds.method_35783(height);
    }

    public int getX() {
        return this.bounds.method_3321();
    }

    public int getY() {
        return this.bounds.method_3322();
    }

    public void setY(int y) {
        this.bounds.method_35781(y);
    }

    public void setX(int x) {
        this.bounds.method_35778(x);
    }

    @NotNull
    public Vector2ic getPosition() {
        return this.bounds.getPosition();
    }

    public void setPosition(@NotNull Vector2iInterface position) {
        this.setX(position.x());
        this.setY(position.y());
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void setLeftTop(int left, int top) {
        this.setPosition(left, top);
    }

    public void setRightBottom(int right, int bottom) {
        this.setRight(right);
        this.setBottom(bottom);
    }

    public int getRight() {
        return this.getX() + this.getWidth();
    }

    public void setRight(int right) {
        this.setX(right - this.getWidth());
    }

    public int getBottom() {
        return this.getY() + this.getHeight();
    }

    public void setBottom(int bottom) {
        this.setY(bottom - this.getHeight());
    }

    public final void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float dt) {
        if (!this.isVisible) {
            return;
        }
        this.wasFocused = this.method_25370() && class_310.method_1551().method_48186().method_48183();
        this.wasHovered = this.isHovered;
        this.isHovered = this.bounds.method_3318(mouseX, mouseY);
        this.renderWidget(guiGraphics, mouseX, mouseY, dt);
        if (Objects.nonNull(this.tooltip) && this.isVisible && this.method_25370() | this.isHovered && Objects.nonNull(class_310.method_1551().field_1755)) {
            class_310.method_1551().field_1755.method_47412(this.tooltip, (class_8000)this.tooltipPositionerGetter.get(), this.method_25370());
        }
    }

    public void renderWidget(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float dt) {
        if (Objects.isNull(this.backgroundDrawable)) {
            return;
        }
        Drawable drawable = this.backgroundDrawable;
        if (drawable instanceof InteractableDrawable) {
            InteractableDrawable interactableDrawable = (InteractableDrawable)drawable;
            interactableDrawable.setState(this.isHovered || this.isFocused, this.wasHoveredBeforeRelease, this.isEnabled);
        }
        this.backgroundDrawable.render(guiGraphics, this.bounds, dt);
    }

    public void method_16014(double mouseX, double mouseY) {
    }

    public final boolean method_25402(double mouseX, double mouseY, int button) {
        return this.mouseClicked(mouseX, mouseY, Mouse.Button.of(button));
    }

    public boolean mouseClicked(double mouseX, double mouseY, @NotNull Mouse.Button button) {
        this.wasHoveredBeforeRelease = false;
        return this.isEnabled && this.isVisible && button.isLeft() && this.bounds.contains(mouseX, mouseY) && this.onMouseClick(mouseX, mouseY);
    }

    public boolean onMouseClick(double mouseX, double mouseY) {
        this.wasHoveredBeforeRelease = true;
        return false;
    }

    public final boolean method_25406(double mouseX, double mouseY, int button) {
        return this.mouseReleased(mouseX, mouseY, Mouse.Button.of(button));
    }

    public boolean mouseReleased(double mouseX, double mouseY, @NotNull Mouse.Button button) {
        return this.isEnabled && this.isVisible && button.isLeft() && this.bounds.contains(mouseX, mouseY) && this.onMouseRelease(mouseX, mouseY);
    }

    public boolean onMouseRelease(double mouseX, double mouseY) {
        if (this.wasHoveredBeforeRelease) {
            this.wasHoveredBeforeRelease = false;
            return this.onClick(true);
        }
        return false;
    }

    public final boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.mouseDragged(mouseX, mouseY, deltaX, deltaY, Mouse.Button.of(button));
    }

    public boolean mouseDragged(double mouseX, double mouseY, double deltaX, double deltaY, @NotNull Mouse.Button button) {
        return this.isEnabled && this.isVisible && button.isLeft() && this.bounds.contains(mouseX, mouseY) && this.onMouseDrag(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean onMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        return false;
    }

    public final boolean method_25401(double mouseX, double mouseY, double verticalAmount) {
        return this.mouseScrolled(mouseX, mouseY, 0.0, verticalAmount);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean onClick(boolean byUser) {
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.isEnabled && this.method_25370() && this.isVisible && (keyCode == 257 || keyCode == 32 || keyCode == 335) && this.onClick(true);
    }

    public boolean method_25400(char chr, int modifiers) {
        return false;
    }

    public class_8016 method_48205(class_8023 focusNavigationEvent) {
        return this.isEnabled && this.isVisible && !this.method_25370() ? class_8016.method_48193((class_364)this) : null;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.isEnabled && this.bounds.contains(mouseX, mouseY);
    }

    public void method_25365(boolean isFocused) {
        this.isFocused = isFocused;
    }

    public boolean method_25370() {
        return this.isFocused;
    }

    public boolean wasFocused() {
        return this.wasFocused;
    }

    @NotNull
    public class_8030 method_48202() {
        return super.method_48202();
    }

    public void setBounds(@NotNull Rect2i bounds) {
        this.setX(bounds.method_3321());
        this.setY(bounds.method_3322());
        this.setWidth(bounds.method_3319());
        this.setHeight(bounds.method_3320());
    }

    @NotNull
    public Rect2i getBounds() {
        return this.bounds.copy();
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return this.method_25370() ? class_6379.class_6380.field_33786 : (this.isHovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784);
    }

    public boolean method_37303() {
        return this.isEnabled;
    }

    public void method_37020(class_6382 narrationElementOutput) {
        if (Objects.nonNull(this.tooltip)) {
            this.tooltip.method_37020(narrationElementOutput);
        }
    }

    public void setTabOrderGroup(int tabOrderGroup) {
        this.tabOrderGroup = tabOrderGroup;
    }

    public int method_48590() {
        return this.tabOrderGroup;
    }

    public void setMessage(@Nullable class_2561 message) {
        this.message = Objects.isNull(message) ? class_2561.method_43473() : message;
    }

    @NotNull
    public class_2561 getMessage() {
        return this.message;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setTooltip(@NotNull String text) {
        this.setTooltip((class_2561)class_2561.method_43470((String)text));
    }

    public void setTooltip(@NotNull class_2561 text) {
        if (text.getString().isBlank()) {
            this.tooltip = null;
            return;
        }
        this.setTooltip(class_7919.method_47407((class_2561)text));
    }

    public void setTooltip(@NotNull class_7919 tooltip) {
        this.tooltip = tooltip;
    }

    @Nullable
    public class_7919 getTooltip() {
        return this.tooltip;
    }

    public void disableTooltip() {
        this.tooltip = null;
    }

    public void setTooltipPositionerGetter(@NotNull @NotNull Supplier<@NotNull TooltipPositioner> tooltipPositionerGetter) {
        this.tooltipPositionerGetter = tooltipPositionerGetter;
    }

    public void setBackgroundDrawable(@Nullable Drawable backgroundDrawable) {
        this.backgroundDrawable = backgroundDrawable;
    }
}

