/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.gui.screen;

import io.github.aratakileo.elegantia.gui.WidgetBoundsBuilder;
import io.github.aratakileo.elegantia.gui.config.Config;
import io.github.aratakileo.elegantia.gui.config.EntryInfo;
import io.github.aratakileo.elegantia.gui.screen.AbstractScreen;
import io.github.aratakileo.elegantia.gui.widget.AbstractButton;
import io.github.aratakileo.elegantia.gui.widget.AbstractWidget;
import io.github.aratakileo.elegantia.gui.widget.Button;
import io.github.aratakileo.elegantia.util.ModInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class ConfigScreen
extends AbstractScreen {
    private final List<Pair<AbstractWidget, String>> entryWidgets = new ArrayList<Pair<AbstractWidget, String>>();
    private final Config configInstance;
    private HashMap<String, List<String>> triggeredFieldEntries;
    private HashMap<String, Button> entryFieldToButton;

    protected ConfigScreen(@NotNull Config configInstance, @Nullable class_437 parent) {
        super((class_2561)class_2561.method_43469((String)"elegantia.gui.config.title", (Object[])new Object[]{ModInfo.getName(configInstance.getModId()).orElse("Unknown")}), parent);
        this.configInstance = configInstance;
    }

    protected void addConfigFieldWidget(@NotNull Button button, @Nullable String triggeredBy) {
        this.entryWidgets.add((Pair<AbstractWidget, String>)new Pair((Object)button, (Object)triggeredBy));
        this.method_37063(button);
    }

    protected void applyWidgetsVisibility(@NotNull Config configInstance) {
        int y = this.getContentY();
        for (Pair<AbstractWidget, String> widgetEntry : this.entryWidgets) {
            String triggeredBy = (String)widgetEntry.getB();
            boolean shouldBeShown = Objects.isNull(triggeredBy) || configInstance.getTriggerValue(triggeredBy);
            AbstractWidget widget = (AbstractWidget)widgetEntry.getA();
            widget.isVisible = shouldBeShown;
            if (!shouldBeShown) continue;
            widget.setY(y);
            y += widget.getHeight() + 2;
        }
    }

    protected void method_25426() {
        this.triggeredFieldEntries = new HashMap();
        this.entryFieldToButton = new HashMap();
        this.configInstance.getEntries().forEach(entryInfo -> {
            class_2561 message = this.getEntryMessage((EntryInfo)entryInfo);
            String triggeredBy = entryInfo.getTriggeredBy();
            Button entryButton = new Button(WidgetBoundsBuilder.ofMessageContent(message).setGravity(4).setPadding(5).build(), message);
            entryButton.setTooltip(entryInfo.getDescriptionComponent(this.configInstance.getModId()));
            this.addConfigFieldWidget(entryButton, triggeredBy);
            if (entryInfo.getType().isAction()) {
                entryButton.setOnClickListener((button, byUser) -> {
                    entryInfo.execute();
                    if (entryInfo.isTrigger()) {
                        for (EntryInfo configEntry : this.configInstance.getEntries()) {
                            if (configEntry.getType() == EntryInfo.Type.ACTION) continue;
                            this.updateBooleanButtonState(this.entryFieldToButton.get(configEntry.getName()), configEntry);
                        }
                    }
                    return true;
                });
                return;
            }
            String entryName = Objects.requireNonNull(entryInfo.getName());
            entryButton.setOnClickListener((button, byUser) -> {
                this.configInstance.invertBooleanFieldValue(entryName);
                this.updateBooleanButtonState(button, (EntryInfo)entryInfo);
                if (!entryInfo.isTrigger()) {
                    return true;
                }
                for (String triggeredFieldName : this.triggeredFieldEntries.get(entryInfo.getTriggerName())) {
                    if (!this.configInstance.getBooleanFieldValue(triggeredFieldName)) continue;
                    this.entryFieldToButton.get(triggeredFieldName).onClick(false);
                }
                this.applyWidgetsVisibility(this.configInstance);
                return true;
            });
            this.entryFieldToButton.put(entryName, entryButton);
            if (Objects.nonNull(triggeredBy)) {
                if (!this.triggeredFieldEntries.containsKey(triggeredBy)) {
                    this.triggeredFieldEntries.put(triggeredBy, new ArrayList());
                }
                this.triggeredFieldEntries.get(triggeredBy).add(entryName);
            }
        });
        this.applyWidgetsVisibility(this.configInstance);
        class_5250 quitButtonMessage = class_2561.method_43471((String)"elegantia.gui.config.button.save_and_quit");
        Button quitButton = new Button(WidgetBoundsBuilder.ofMessageContent((class_2561)quitButtonMessage).setGravity(6).setPadding(5).setMarginBottom(10).build(), (class_2561)quitButtonMessage);
        quitButton.setOnClickListener((btn, byUser) -> {
            this.configInstance.save();
            this.method_25419();
            return true;
        });
        this.method_37063(quitButton);
    }

    @NotNull
    protected class_2561 getEntryMessage(@NotNull EntryInfo entryInfo) {
        if (entryInfo.getType().isBoolean()) {
            return this.getBooleanEntryMessage(entryInfo);
        }
        return class_2561.method_43470((String)entryInfo.getTitle(this.configInstance.getModId()));
    }

    @NotNull
    protected class_2561 getBooleanEntryMessage(@NotNull EntryInfo entryInfo) {
        boolean state = this.configInstance.getBooleanFieldValue(Objects.requireNonNull(entryInfo.getName()));
        return class_2561.method_43470((String)"%s: \u00a7l%s%s".formatted(entryInfo.getTitle(this.configInstance.getModId()), state ? "\u00a72" : "\u00a7c", class_2477.method_10517().method_48307("elegantia.gui.state." + (state ? "enabled" : "disabled"))));
    }

    protected void updateBooleanButtonState(@NotNull AbstractButton button, @NotNull EntryInfo entryInfo) {
        button.setMessage(this.getBooleanEntryMessage(entryInfo));
        button.setBounds(WidgetBoundsBuilder.ofMessageContent(button.getMessage()).setGravity(4).setPadding(5).setInitialBounds(button.getBounds()).build());
    }

    @Nullable
    public static ConfigScreen of(@NotNull Class<? extends Config> configClass) {
        return ConfigScreen.of(configClass, ConfigScreen.getCurrentScreen());
    }

    @Nullable
    public static ConfigScreen of(@NotNull Class<? extends Config> configClass, @Nullable class_437 parent) {
        Config configInstance = Config.getInstance(configClass);
        if (Objects.isNull(configInstance)) {
            return null;
        }
        return new ConfigScreen(configInstance, parent);
    }
}

