/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.gui.config;

import io.github.aratakileo.elegantia.util.Strings;
import java.util.Objects;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryInfo {
    private final Type type;
    @Nullable
    private final String triggerName;
    @Nullable
    private final String triggeredBy;
    @Nullable
    private final String name;
    @Nullable
    private final String translationKey;
    @Nullable
    private final Runnable onClick;

    private EntryInfo(@NotNull Type type, @Nullable String name, @Nullable String triggerName, @Nullable String triggeredBy, @Nullable String translationKey, @Nullable Runnable onClick) {
        this.type = type;
        this.triggerName = triggerName;
        this.triggeredBy = Objects.isNull(triggeredBy) || triggeredBy.isEmpty() ? null : triggeredBy;
        this.translationKey = translationKey;
        this.name = name;
        this.onClick = onClick;
        if ((Objects.isNull(name) || name.isBlank()) && (Objects.isNull(translationKey) || translationKey.isBlank())) {
            throw new InvalidConfigEntryException("translationKey `%s` and name `%s` cannot have bad values at the same time. %s".formatted(translationKey, name, "At least one of these parameters must have a full value!"));
        }
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public boolean isTrigger() {
        return Objects.nonNull(this.triggerName);
    }

    @Nullable
    public String getTriggerName() {
        return this.triggerName;
    }

    @Nullable
    public String getTriggeredBy() {
        return this.triggeredBy;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    private String getTranslationKey(@NotNull String modId, @NotNull String postfix) {
        return "%s.config.entry.%s.%s".formatted(modId, Strings.doesNotMeetCondition(Objects.requireNonNullElse(this.translationKey, ""), String::isBlank, Strings.camelToSnake(Objects.requireNonNullElse(this.name, ""))), postfix);
    }

    @NotNull
    public class_2561 getDescriptionComponent(@NotNull String modId) {
        return class_2561.method_43470((String)Strings.requireReturnNotAsArgument(this.getTranslationKey(modId, "description"), arg_0 -> ((class_2477)class_2477.method_10517()).method_48307(arg_0), ""));
    }

    @NotNull
    public String getTitle(@NotNull String modId) {
        String fullTranslationKey = this.getTranslationKey(modId, "title");
        return Objects.isNull(this.name) ? fullTranslationKey : Strings.requireReturnNotAsArgument(fullTranslationKey, arg_0 -> ((class_2477)class_2477.method_10517()).method_48307(arg_0), "%s@%s".formatted(Strings.capitalize(this.getType().name().toLowerCase()), this.name));
    }

    public void execute() {
        if (Objects.isNull(this.onClick)) {
            return;
        }
        this.onClick.run();
    }

    @NotNull
    public static EntryInfo action(@Nullable String name, @Nullable String triggeredBy, @Nullable String translationKey, @NotNull Runnable onClick, boolean isInfluential) {
        return new EntryInfo(Type.ACTION, name, isInfluential ? "influential" : null, triggeredBy, translationKey, onClick);
    }

    @NotNull
    public static EntryInfo value(@NotNull Type type, @NotNull String name, @Nullable String triggerName, @Nullable String triggeredBy, @Nullable String translationKey) {
        if (type.isAction()) {
            throw new InvalidConfigEntryException("Value entry cannot be an action! (name: %s, translationKey: %s)".formatted(name, translationKey));
        }
        return new EntryInfo(type, name, triggerName, triggeredBy, translationKey, null);
    }

    public static enum Type {
        BOOLEAN,
        ACTION;


        public boolean isBoolean() {
            return this == BOOLEAN;
        }

        public boolean isAction() {
            return this == ACTION;
        }
    }

    public static class InvalidConfigEntryException
    extends RuntimeException {
        public InvalidConfigEntryException(@NotNull String message) {
            super(message);
        }
    }
}

