/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.gui.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.aratakileo.elegantia.gui.config.ConfigEntry;
import io.github.aratakileo.elegantia.gui.config.EntryInfo;
import io.github.aratakileo.elegantia.gui.config.InfluentialAction;
import io.github.aratakileo.elegantia.gui.config.Trigger;
import io.github.aratakileo.elegantia.gui.screen.ConfigScreen;
import io.github.aratakileo.elegantia.util.Classes;
import io.github.aratakileo.elegantia.util.LateInitValue;
import io.github.aratakileo.elegantia.util.ModInfo;
import io.github.aratakileo.elegantia.util.Strings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    private static final Gson GSON = new GsonBuilder().setFieldNamingStrategy(field -> Strings.camelToSnake(field.getName())).setPrettyPrinting().create();
    private static final Pattern TRIGGER_NAME_PATTERN = Pattern.compile("^(?![0-9-]+)[A-Za-z0-9_-]+[^-]$");
    private static final ConcurrentHashMap<Class<? extends Config>, Config> CONFIG_INSTANCES = new ConcurrentHashMap();
    @NotNull
    protected final transient LateInitValue<String> modId = new LateInitValue();
    @NotNull
    protected final transient List<EntryInfo> entries = new ArrayList<EntryInfo>();
    @NotNull
    protected final transient HashMap<String, String> triggerFields = new HashMap();

    public boolean getTriggerValue(@NotNull String trigger) {
        HashMap<String, String> triggerFields = ((Config)Objects.requireNonNull(Config.getInstance(this.getClass()))).triggerFields;
        if (!triggerFields.containsKey(trigger)) {
            throw new InvalidTriggerException("Trigger `%s` does not exist".formatted(trigger));
        }
        return this.getBooleanFieldValue(triggerFields.get(trigger));
    }

    public void setDefaultFieldValue(@NotNull String fieldName) {
        Object newInstance = Config.newInstance(this.getClass());
        if (Objects.nonNull(newInstance)) {
            this.setFieldValue(fieldName, ((Config)newInstance).getFieldValue(fieldName));
            return;
        }
        LOGGER.warn("Failed to set config field `{}` with value by default", (Object)Classes.getFieldOrMethodView(this.getClass(), fieldName));
    }

    public void setFieldValue(@NotNull String fieldName, @Nullable Object value) {
        try {
            this.getClass().getField(fieldName).set(this, value);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to set config field `%s`".formatted(Classes.getFieldOrMethodView(this.getClass(), fieldName)), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Failed to set a non-existent config field `%s`".formatted(Classes.getFieldOrMethodView(this.getClass(), fieldName)), (Throwable)e);
        }
    }

    @Nullable
    public Object getFieldValue(@NotNull String fieldName) {
        try {
            return this.getClass().getField(fieldName).get(this);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to get config field `%s`".formatted(Classes.getFieldOrMethodView(this.getClass(), fieldName)), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Failed to get a non-existent config field `%s`".formatted(Classes.getFieldOrMethodView(this.getClass(), fieldName)), (Throwable)e);
        }
        return null;
    }

    public boolean getBooleanFieldValue(@NotNull String fieldName) {
        return (Boolean)this.getFieldValue(fieldName);
    }

    public void invertBooleanFieldValue(@NotNull String fieldName) {
        this.setFieldValue(fieldName, !this.getBooleanFieldValue(fieldName));
    }

    public int getIntegerFieldValue(@NotNull String fieldName) {
        return (Integer)this.getFieldValue(fieldName);
    }

    public float getFloatFieldValue(@NotNull String fieldName) {
        return ((Float)this.getFieldValue(fieldName)).floatValue();
    }

    public double getDoubleFieldValue(@NotNull String fieldName) {
        return (Double)this.getFieldValue(fieldName);
    }

    public String getStringFieldValue(@NotNull String fieldName) {
        return (String)this.getFieldValue(fieldName);
    }

    public void setValuesByDefault() {
        Config.setValuesByDefault(this.getClass());
    }

    public void setValuesByDefault(boolean onlyConfigEntryFields) {
        Config.setValuesByDefault(this.getClass(), onlyConfigEntryFields);
    }

    public void save() {
        Config.save(this, Objects.requireNonNull(Config.getConfigFile(this.getClass())));
    }

    @Nullable
    public ConfigScreen getScreen() {
        return ConfigScreen.of(this.getClass());
    }

    @Nullable
    public ConfigScreen getScreen(@NotNull class_437 parent) {
        return ConfigScreen.of(this.getClass(), parent);
    }

    @NotNull
    public String getModId() {
        if (this.modId.isInited()) {
            return this.modId.get().orElseThrow();
        }
        throw new IllegalInitException(this.getClass().getName());
    }

    @NotNull
    public List<EntryInfo> getEntries() {
        return this.entries;
    }

    @NotNull
    public HashMap<String, String> getTriggerFields() {
        return this.triggerFields;
    }

    @Nullable
    private static <T extends Config> T newInstance(@NotNull Class<T> configClass) {
        try {
            return (T)((Config)configClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            LOGGER.error("Failed to create a new instance of `" + configClass.getName() + "`: ", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static <T extends Config> T load(@NotNull Class<T> configClass, @NotNull File file) {
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                Config configInstance = (Config)GSON.fromJson((Reader)fileReader, configClass);
                fileReader.close();
                return (T)configInstance;
            }
            catch (Exception e) {
                LOGGER.error("Failed to load config by path `" + file.getPath() + "`: ", (Throwable)e);
            }
        }
        return null;
    }

    private static void save(@NotNull Config configInstance, @NotNull File file) {
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdir()) {
            LOGGER.warn("Failed to make dir `" + parentFile.getPath() + "`. Possible reason: insufficient permissions to perform this action");
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(GSON.toJson((Object)configInstance));
            fileWriter.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config by path `" + file.getPath() + "`: ", (Throwable)e);
        }
    }

    @Nullable
    private static File getConfigFile(@NotNull Class<? extends Config> configClass) {
        if (!CONFIG_INSTANCES.containsKey(configClass)) {
            return null;
        }
        return Config.getConfigFile(CONFIG_INSTANCES.get(configClass).getModId());
    }

    @NotNull
    private static File getConfigFile(@NotNull String modId) {
        return new File("config/" + modId + ".json");
    }

    @Nullable
    public static <T extends Config> T init(@NotNull Class<T> configClass, @NotNull String modId) {
        int configClassModifiers = configClass.getModifiers();
        if (Modifier.isAbstract(configClassModifiers)) {
            throw new InvalidConfigClassException("%s is abstract".formatted(configClass.getName()));
        }
        if (Modifier.isInterface(configClassModifiers)) {
            throw new InvalidConfigClassException("%s is interface".formatted(configClass.getName()));
        }
        if (Modifier.isPrivate(configClassModifiers) || Modifier.isProtected(configClassModifiers)) {
            throw new InvalidConfigClassException("%s must be public".formatted(configClass.getName()));
        }
        if (CONFIG_INSTANCES.containsKey(configClass)) {
            LOGGER.warn("Config `{}` is already inited!", (Object)configClass.getName());
            return null;
        }
        ModInfo.throwIfModIsNotLoaded(modId);
        Config configInstance = (Config)Optional.ofNullable(Config.load(configClass, Config.getConfigFile(modId))).orElse(Config.newInstance(configClass));
        if (Objects.isNull(configInstance)) {
            LOGGER.warn("Failed to init config `{}`", (Object)configClass.getName());
            return null;
        }
        ArrayList<Field> entryFields = new ArrayList<Field>();
        configInstance.modId.set(modId);
        for (Field field : configClass.getDeclaredFields()) {
            boolean isTrigger = field.isAnnotationPresent(Trigger.class);
            if (!field.isAnnotationPresent(ConfigEntry.class)) {
                if (!isTrigger) continue;
                LOGGER.warn("Field `" + Classes.getFieldView(field) + "` is not marked with the @ConfigEntry annotation which means that this field will not be displayed on the mod configuration screen");
                continue;
            }
            if (field.getType() != Boolean.TYPE) {
                LOGGER.warn("Field `{}` has unsupported config field type. {}", (Object)Classes.getFieldView(field), (Object)"This field will not be displayed on the config screen");
                continue;
            }
            int fieldModifiers = field.getModifiers();
            if (Modifier.isPrivate(fieldModifiers)) {
                LOGGER.warn("Field `{}` is private. {}", (Object)Classes.getFieldView(field), (Object)"This field will not be displayed on the config screen");
                continue;
            }
            if (Modifier.isProtected(fieldModifiers)) {
                LOGGER.warn("Field `{}` is protected. {}", (Object)Classes.getFieldView(field), (Object)"This field will not be displayed on the config screen");
                continue;
            }
            entryFields.add(field);
            if (!isTrigger) continue;
            String triggerName = field.getAnnotation(Trigger.class).value();
            if (!TRIGGER_NAME_PATTERN.matcher(triggerName).find()) {
                throw new InvalidTriggerException("Trigger name `%s` does not match the pattern `%s` (trigger field: %s)!".formatted(triggerName, TRIGGER_NAME_PATTERN, Classes.getFieldView(field)));
            }
            if (!field.getAnnotation(ConfigEntry.class).triggeredBy().isEmpty()) {
                throw new InvalidTriggerException("Trigger cannot be triggered (trigger field: %s)!".formatted(Classes.getFieldView(field)));
            }
            configInstance.triggerFields.put(triggerName, field.getName());
        }
        for (Field field : entryFields) {
            ConfigEntry entryAnnotation = field.getAnnotation(ConfigEntry.class);
            String triggeredBy = entryAnnotation.triggeredBy();
            if (!triggeredBy.isEmpty() && !configInstance.triggerFields.containsKey(triggeredBy)) {
                throw new InvalidConfigFieldException("Field `%s` indicates a dependency on trigger `%S`, which does not exist!".formatted(Classes.getFieldView(field), triggeredBy));
            }
            configInstance.entries.add(EntryInfo.value(EntryInfo.Type.BOOLEAN, field.getName(), field.isAnnotationPresent(Trigger.class) ? field.getAnnotation(Trigger.class).value() : null, triggeredBy, entryAnnotation.translationKey()));
        }
        for (Method method : configClass.getMethods()) {
            if (!method.isAnnotationPresent(ConfigEntry.class)) continue;
            if (method.getReturnType() != Void.TYPE) {
                throw new InvalidActionException("Method `%s` cannot be represented as an action because %s".formatted(Classes.getMethodView(method), "it has a return type other than `void`"));
            }
            if (method.getParameterCount() != 0) {
                throw new InvalidActionException("Method `%s` cannot be represented as an action because it has parameters".formatted(Classes.getMethodView(method)));
            }
            ConfigEntry entryAnnotation = method.getAnnotation(ConfigEntry.class);
            String triggeredBy = entryAnnotation.triggeredBy();
            if (!triggeredBy.isEmpty() && !configInstance.triggerFields.containsKey(triggeredBy)) {
                throw new InvalidActionException("Method `%s` indicates a dependency on trigger `%s`, which does not exist!".formatted(Classes.getMethodView(method), triggeredBy));
            }
            configInstance.entries.add(EntryInfo.action(method.getName(), triggeredBy, entryAnnotation.translationKey(), () -> {
                try {
                    method.invoke(Config.getInstance(configClass), new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new FailedActionExecutionException("Method `%s` cannot be accessed".formatted(Classes.getMethodView(method)), e);
                }
                catch (InvocationTargetException e) {
                    throw new FailedActionExecutionException("Method `%s`".formatted(Classes.getMethodView(method)), e);
                }
            }, method.isAnnotationPresent(InfluentialAction.class)));
        }
        CONFIG_INSTANCES.put(configClass, configInstance);
        if (!configInstance.entries.isEmpty()) {
            ModInfo.setConfigScreenGetter(modId, parent -> ConfigScreen.of(configClass, parent));
        }
        return (T)configInstance;
    }

    @Nullable
    public static <T extends Config> T getInstance(@NotNull Class<T> configClass) {
        Config configInstance = CONFIG_INSTANCES.get(configClass);
        return (T)(Objects.nonNull(configInstance) ? configInstance : null);
    }

    public static void setValuesByDefault(@NotNull Class<? extends Config> configClass) {
        Config.setValuesByDefault(configClass, false);
    }

    public static void setValuesByDefault(@NotNull Class<? extends Config> configClass, boolean onlyConfigEntryFields) {
        if (!CONFIG_INSTANCES.containsKey(configClass)) {
            return;
        }
        Config newInstance = Config.newInstance(configClass);
        if (Objects.isNull(newInstance)) {
            LOGGER.warn("Failed to set values by default for `{}`", (Object)configClass.getName());
            return;
        }
        Config currentInstance = CONFIG_INSTANCES.get(configClass);
        try {
            for (Field field : currentInstance.getClass().getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers()) || onlyConfigEntryFields && !field.isAnnotationPresent(ConfigEntry.class)) continue;
                field.setAccessible(true);
                field.set(currentInstance, field.get(newInstance));
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to set values by default for `%s`".formatted(configClass.getName()), (Throwable)e);
        }
    }

    public static class InvalidTriggerException
    extends RuntimeException {
        public InvalidTriggerException(@NotNull String message) {
            super(message);
        }
    }

    public static class IllegalInitException
    extends RuntimeException {
        public IllegalInitException(@NotNull String message) {
            super(message);
        }
    }

    public static class InvalidConfigClassException
    extends RuntimeException {
        public InvalidConfigClassException(@NotNull String message) {
            super(message);
        }
    }

    public static class InvalidConfigFieldException
    extends RuntimeException {
        public InvalidConfigFieldException(@NotNull String message) {
            super(message);
        }
    }

    public static class InvalidActionException
    extends RuntimeException {
        public InvalidActionException(@NotNull String message) {
            super(message);
        }
    }

    public static class FailedActionExecutionException
    extends RuntimeException {
        public FailedActionExecutionException(@NotNull String message) {
            super(message);
        }

        public FailedActionExecutionException(@NotNull String message, @NotNull Throwable cause) {
            super(message, cause);
        }
    }
}

