/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.gui;

import io.github.aratakileo.elegantia.math.Rect2i;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetBoundsBuilder {
    public static final int GRAVITY_LEFT = 0;
    public static final int GRAVITY_TOP = 0;
    public static final int GRAVITY_RIGHT = 1;
    public static final int GRAVITY_BOTTOM = 2;
    public static final int GRAVITY_CENTER_HORIZONTAL = 4;
    public static final int GRAVITY_CENTER_VERTICAL = 8;
    public static final int GRAVITY_CENTER = 12;
    private final int contentWidth;
    private final int contentHeight;
    private int paddingLeft = 0;
    private int paddingTop = 0;
    private int paddingRight = 0;
    private int paddingBottom = 0;
    private int marginLeft = 0;
    private int marginTop = 0;
    private int marginRight = 0;
    private int marginBottom = 0;
    private int gravity = 0;
    @Nullable
    private Rect2i initialBounds;
    @Nullable
    private Rect2i parentBounds;

    public WidgetBoundsBuilder(int contentSize) {
        this.contentWidth = contentSize;
        this.contentHeight = contentSize;
    }

    public WidgetBoundsBuilder(int contentWidth, int contentHeight) {
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
    }

    @NotNull
    public WidgetBoundsBuilder setPadding(int padding) {
        this.paddingLeft = padding;
        this.paddingTop = padding;
        this.paddingRight = padding;
        this.paddingBottom = padding;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        this.paddingBottom = paddingBottom;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setMargin(int margin) {
        this.marginLeft = margin;
        this.marginTop = margin;
        this.marginRight = margin;
        this.marginBottom = margin;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setMargin(int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.marginLeft = marginLeft;
        this.marginTop = marginTop;
        this.marginRight = marginRight;
        this.marginBottom = marginBottom;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setMarginTop(int marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setMarginRight(int marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setInitialBounds(@Nullable Rect2i initialBounds) {
        this.initialBounds = initialBounds;
        return this;
    }

    @NotNull
    public WidgetBoundsBuilder setParentBounds(@Nullable Rect2i parentBounds) {
        this.parentBounds = parentBounds;
        return this;
    }

    @NotNull
    public Rect2i build() {
        class_1041 minecraftWindow = class_310.method_1551().method_22683();
        Rect2i canvasBounds = Objects.nonNull((Object)this.parentBounds) ? this.parentBounds : new Rect2i(0, 0, minecraftWindow.method_4486(), minecraftWindow.method_4502());
        Rect2i newBounds = Objects.isNull((Object)this.initialBounds) ? new Rect2i(0, 0, 0) : this.initialBounds.copy();
        newBounds.method_35782(this.paddingLeft + this.contentWidth + this.paddingRight);
        newBounds.method_35783(this.paddingTop + this.contentHeight + this.paddingBottom);
        if (Objects.isNull((Object)this.initialBounds)) {
            if ((this.gravity & 1) >= 1) {
                newBounds.setRight(canvasBounds.getRight() - this.marginRight);
            } else if ((this.gravity & 4) >= 1) {
                newBounds.setIpLeft((canvasBounds.method_3319() - newBounds.method_3319()) / 2).moveIpX(canvasBounds.method_3321());
            } else {
                newBounds.setLeft(canvasBounds.getLeft() + this.marginLeft);
            }
            if ((this.gravity & 2) >= 1) {
                newBounds.setBottom(canvasBounds.getBottom() - this.marginBottom);
            } else if ((this.gravity & 8) >= 1) {
                newBounds.setIpTop((canvasBounds.method_3320() - newBounds.method_3320()) / 2).moveIpY(canvasBounds.method_3322());
            } else {
                newBounds.setTop(canvasBounds.getTop() + this.marginTop);
            }
            return newBounds;
        }
        if ((this.gravity & 1) >= 1) {
            newBounds.setLeft(Math.min(newBounds.getLeft() - (newBounds.method_3319() - this.initialBounds.method_3319()), canvasBounds.getRight() - this.marginRight));
        } else if ((this.gravity & 4) >= 1) {
            newBounds.moveIpX((this.initialBounds.method_3319() - newBounds.method_3319()) / 2);
        } else {
            newBounds.setLeft(Math.max(newBounds.getLeft(), canvasBounds.getLeft() + this.marginLeft));
        }
        if ((this.gravity & 2) >= 1) {
            newBounds.setTop(Math.min(newBounds.getTop() - (newBounds.method_3320() - this.initialBounds.method_3320()), canvasBounds.getBottom() - this.marginBottom));
        } else if ((this.gravity & 8) >= 1) {
            newBounds.moveIpY((newBounds.method_3320() - this.initialBounds.method_3320()) / 2);
        } else {
            newBounds.setTop(Math.max(newBounds.getTop(), canvasBounds.getTop() + this.marginTop));
        }
        return newBounds;
    }

    @NotNull
    public static WidgetBoundsBuilder of(@NotNull WidgetBoundsBuilder widgetBoundsBuilder) {
        return WidgetBoundsBuilder.of(widgetBoundsBuilder.build(), widgetBoundsBuilder.paddingLeft, widgetBoundsBuilder.paddingTop, widgetBoundsBuilder.paddingRight, widgetBoundsBuilder.paddingBottom).setMargin(widgetBoundsBuilder.marginLeft, widgetBoundsBuilder.marginTop, widgetBoundsBuilder.marginRight, widgetBoundsBuilder.marginBottom).setGravity(widgetBoundsBuilder.gravity).setParentBounds(widgetBoundsBuilder.parentBounds);
    }

    @NotNull
    public static WidgetBoundsBuilder of(@NotNull Rect2i initialBounds, int padding) {
        return WidgetBoundsBuilder.of(initialBounds, padding, padding, padding, padding);
    }

    @NotNull
    public static WidgetBoundsBuilder of(@NotNull Rect2i initialBounds, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        return new WidgetBoundsBuilder(initialBounds.method_3319() - paddingLeft - paddingRight, initialBounds.method_3320() - paddingTop - paddingBottom).setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    @NotNull
    public static WidgetBoundsBuilder ofMessageContent(@NotNull class_2561 message) {
        class_327 font = class_310.method_1551().field_1772;
        int n = font.method_27525((class_5348)message);
        Objects.requireNonNull(font);
        return new WidgetBoundsBuilder(n, 9);
    }
}

