/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.graphics;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.aratakileo.elegantia.graphics.RectVertexConsumer;
import io.github.aratakileo.elegantia.math.Rect2i;
import io.github.aratakileo.elegantia.math.Vector2iInterface;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_1011;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class RectDrawer {
    private final class_332 guiGraphics;
    public final Rect2i bounds;

    private RectDrawer(@NotNull class_332 guiGraphics, @NotNull Rect2i bounds) {
        this.guiGraphics = guiGraphics;
        this.bounds = bounds;
    }

    @NotNull
    public class_332 getGuiGraphics() {
        return this.guiGraphics;
    }

    @NotNull
    public RectDrawer draw(int color) {
        if (color != 0) {
            this.guiGraphics.method_25294(this.bounds.method_3321(), this.bounds.method_3322(), this.bounds.getRight(), this.bounds.getBottom(), color);
            return this;
        }
        return this;
    }

    @NotNull
    public RectDrawer drawGradient(int colorStart, int colorEnd, @NotNull GradientDirection direction) {
        if (colorStart == 0 || colorEnd == 0) {
            return this;
        }
        RectVertexConsumer buffer = new RectVertexConsumer(this.bounds, this.guiGraphics.method_51450().getBuffer(class_1921.method_51784()), this.guiGraphics.method_51448().method_23760().method_23761());
        switch (direction) {
            case HORIZONTAL: {
                buffer.coloredVertex(0, colorStart);
                buffer.coloredVertex(1, colorStart);
                buffer.coloredVertex(2, colorEnd);
                buffer.coloredVertex(3, colorEnd);
                break;
            }
            case VERTICAL: {
                buffer.coloredVertex(0, colorStart);
                buffer.coloredVertex(1, colorEnd);
                buffer.coloredVertex(2, colorEnd);
                buffer.coloredVertex(3, colorStart);
                break;
            }
            case DIAGONAL: {
                buffer.coloredVertex(0, colorEnd);
                buffer.coloredVertex(1, colorStart);
                buffer.coloredVertex(2, colorEnd);
                buffer.coloredVertex(3, colorStart);
                break;
            }
            case CORNER_LEFT_TOP: {
                buffer.coloredVertex(0, colorStart);
                buffer.coloredVertex(1, colorEnd);
                buffer.coloredVertex(2, colorEnd);
                buffer.coloredVertex(3, colorEnd);
                break;
            }
            case CORNER_LEFT_BOTTOM: {
                buffer.coloredVertex(0, colorEnd);
                buffer.coloredVertex(1, colorStart);
                buffer.coloredVertex(2, colorEnd);
                buffer.coloredVertex(3, colorEnd);
                break;
            }
            case CORNER_RIGHT_BOTTOM: {
                buffer.coloredVertex(0, colorEnd);
                buffer.coloredVertex(1, colorEnd);
                buffer.coloredVertex(2, colorStart);
                buffer.coloredVertex(3, colorEnd);
                break;
            }
            case CORNER_RIGHT_TOP: {
                buffer.coloredVertex(0, colorEnd);
                buffer.coloredVertex(1, colorEnd);
                buffer.coloredVertex(2, colorEnd);
                buffer.coloredVertex(3, colorStart);
            }
        }
        return this;
    }

    @NotNull
    public RectDrawer drawStroke(int color, int thickness) {
        if (color == 0 || thickness == 0) {
            return this;
        }
        this.guiGraphics.method_25294(this.bounds.method_3321(), this.bounds.method_3322(), this.bounds.getRight(), this.bounds.method_3322() + thickness, color);
        this.guiGraphics.method_25294(this.bounds.method_3321(), this.bounds.getBottom() - thickness, this.bounds.getRight(), this.bounds.getBottom(), color);
        this.guiGraphics.method_25294(this.bounds.method_3321(), this.bounds.method_3322() + thickness, this.bounds.method_3321() + thickness, this.bounds.getBottom() - thickness, color);
        this.guiGraphics.method_25294(this.bounds.getRight() - thickness, this.bounds.method_3322() + thickness, this.bounds.getRight(), this.bounds.getBottom() - thickness, color);
        return this;
    }

    @NotNull
    public RectDrawer renderTexture(@NotNull class_2960 texture) {
        RenderSystem.enableBlend();
        this.guiGraphics.method_25290(texture, this.bounds.method_3321(), this.bounds.method_3322(), 0.0f, 0.0f, this.bounds.method_3319(), this.bounds.method_3320(), this.bounds.method_3319(), this.bounds.method_3320());
        RenderSystem.disableBlend();
        return this;
    }

    @NotNull
    public RectDrawer renderFittedCenterTexture(@NotNull class_2960 texture) {
        try {
            class_1011 nativeImage = class_1011.method_4309((InputStream)class_310.method_1551().method_1478().open(texture));
            return this.renderFittedCenterTexture(texture, nativeImage.method_4307(), nativeImage.method_4323());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public RectDrawer renderFittedCenterTexture(@NotNull class_2960 texture, int textureWidth, int textureHeight) {
        int renderWidth = this.bounds.method_3319();
        int renderHeight = this.bounds.method_3320();
        int renderX = this.bounds.method_3321();
        int renderY = this.bounds.method_3322();
        if (textureWidth < textureHeight) {
            int oldRenderWidth = renderWidth;
            renderWidth = (int)((float)renderWidth * ((float)textureWidth / (float)textureHeight));
            renderX += (oldRenderWidth - renderWidth) / 2;
        } else if (textureHeight < textureWidth) {
            int oldRenderHeight = renderHeight;
            renderHeight = (int)((float)renderHeight * ((float)textureHeight / (float)textureWidth));
            renderY += (oldRenderHeight - renderHeight) / 2;
        }
        RenderSystem.enableBlend();
        this.guiGraphics.method_25290(texture, renderX, renderY, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight);
        RenderSystem.disableBlend();
        return this;
    }

    public String toString() {
        return "RectDrawer{%s, %s, %s, %s}".formatted(this.bounds.method_3321(), this.bounds.method_3322(), this.bounds.method_3319(), this.bounds.method_3320());
    }

    @NotNull
    public static RectDrawer with(@NotNull class_332 guiGraphics, @NotNull Rect2i rect2i) {
        return new RectDrawer(guiGraphics, rect2i.copy());
    }

    public static RectDrawer with(@NotNull class_332 guiGraphics, @NotNull Vector2iInterface pos, int size) {
        return new RectDrawer(guiGraphics, new Rect2i(pos, size));
    }

    public static RectDrawer with(@NotNull class_332 guiGraphics, @NotNull Vector2iInterface pos, int width, int height) {
        return new RectDrawer(guiGraphics, new Rect2i(pos, width, height));
    }

    public static RectDrawer with(@NotNull class_332 guiGraphics, int x, int y, int size) {
        return new RectDrawer(guiGraphics, new Rect2i(x, y, size));
    }

    public static RectDrawer with(@NotNull class_332 guiGraphics, int x, int y, int width, int height) {
        return new RectDrawer(guiGraphics, new Rect2i(x, y, width, height));
    }

    public static enum GradientDirection {
        HORIZONTAL,
        VERTICAL,
        DIAGONAL,
        CORNER_LEFT_TOP,
        CORNER_LEFT_BOTTOM,
        CORNER_RIGHT_BOTTOM,
        CORNER_RIGHT_TOP;

    }
}

