/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class NativeGifImage
implements AutoCloseable {
    public static final String GIF_EXTENSION = ".gif";
    private final int width;
    private final int height;
    private final int frames;
    private final int[] pixels;
    private final int[] delays;

    public NativeGifImage(int width, int height, int frames, int[] pixels, int[] delays) {
        this.width = width;
        this.height = height;
        this.frames = frames;
        this.pixels = pixels;
        this.delays = delays;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameCount() {
        return this.delays.length;
    }

    @NotNull
    public class_1011 getVerticalScroll() {
        class_1011 nativeImage = new class_1011(class_1011.class_1012.field_4997, this.width, this.height * this.frames, false);
        for (int y = 0; y < this.height * this.frames; ++y) {
            for (int x = 0; x < this.width; ++x) {
                nativeImage.method_4305(x, y, this.pixels[y * this.width + x]);
            }
        }
        return nativeImage;
    }

    public int processFrames(@NotNull FrameProcessor frameProcessor) {
        int totalDelay = 0;
        for (int i = 0; i < this.getFrameCount(); ++i) {
            class_1011 currentNativeImage = new class_1011(class_1011.class_1012.field_4997, this.width, this.height, false);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    currentNativeImage.method_4305(x, y, this.pixels[(i * this.height + y) * this.width + x]);
                }
            }
            frameProcessor.process(i, totalDelay, new Frame(currentNativeImage, this.delays[i]));
            totalDelay += this.delays[i];
        }
        return totalDelay;
    }

    @NotNull
    public static NativeGifImage read(@NotNull InputStream inputStream) throws IOException {
        NativeGifImage nativeGifImage = null;
        try {
            nativeGifImage = NativeGifImage.read(inputStream.readAllBytes());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return nativeGifImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NativeGifImage read(byte[] fileData) throws IOException {
        NativeGifImage nativeGifImage;
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)fileData.length);
        try {
            byteBuffer.put(fileData);
            byteBuffer.position(0);
            try (MemoryStack memoryStack = MemoryStack.stackPush();){
                PointerBuffer delayBuffer = memoryStack.mallocPointer(1);
                IntBuffer widthBuffer = memoryStack.mallocInt(1);
                IntBuffer heightBuffer = memoryStack.mallocInt(1);
                IntBuffer frameBuffer = memoryStack.mallocInt(1);
                IntBuffer channelBuffer = memoryStack.mallocInt(1);
                ByteBuffer gifByteBuffer = STBImage.stbi_load_gif_from_memory((ByteBuffer)byteBuffer, (PointerBuffer)delayBuffer, (IntBuffer)widthBuffer, (IntBuffer)heightBuffer, (IntBuffer)frameBuffer, (IntBuffer)channelBuffer, (int)0);
                try {
                    if (gifByteBuffer == null) {
                        throw new IOException("Could not load gif image: " + STBImage.stbi_failure_reason());
                    }
                    int channels = channelBuffer.get();
                    if (channels != 4) {
                        throw new RuntimeException(String.format("Could not load gif image with less than 4 channels (%s)", channels));
                    }
                    int width = widthBuffer.get();
                    int height = heightBuffer.get();
                    int frames = frameBuffer.get();
                    IntBuffer delaysIntBuffer = delayBuffer.getIntBuffer(frames);
                    IntBuffer pixelData = gifByteBuffer.asIntBuffer();
                    int[] delays = new int[frames];
                    int[] pixels = new int[width * height * frames];
                    delaysIntBuffer.get(delays);
                    pixelData.get(pixels);
                    nativeGifImage = new NativeGifImage(width, height, frames, pixels, delays);
                }
                finally {
                    if (gifByteBuffer != null) {
                        STBImage.stbi_image_free((ByteBuffer)gifByteBuffer);
                    }
                }
            }
        }
        finally {
            MemoryUtil.memFree((Buffer)byteBuffer);
        }
        return nativeGifImage;
    }

    @Override
    public void close() {
    }

    public record Frame(@NotNull class_1011 nativeImage, int delay) {
    }

    public static interface FrameProcessor {
        public void process(int var1, int var2, @NotNull Frame var3);
    }
}

