/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.event;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class Event<T> {
    protected volatile T invoker;
    private final List<T> handlers = new ArrayList<T>();
    private final Function<List<T>, T> invokerFactory;

    private Event(Function<List<T>, T> invokerFactory) {
        this.invokerFactory = invokerFactory;
    }

    public T getInvoker() {
        return this.invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(T listener) {
        List<T> list = this.handlers;
        synchronized (list) {
            this.handlers.add(listener);
            this.update();
        }
    }

    private void update() {
        this.invoker = this.invokerFactory.apply(this.handlers);
    }

    @NotNull
    public static <T> Event<T> newEventFactory(@NotNull Function<List<T>, T> invokerFactory) {
        Event<T> event = new Event<T>(invokerFactory);
        event.update();
        return event;
    }
}

