/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.tile;

import elucent.eidolon.Registry;
import elucent.eidolon.network.CrucibleFailPacket;
import elucent.eidolon.network.CrucibleSuccessPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.particle.Particles;
import elucent.eidolon.recipe.CrucibleRecipe;
import elucent.eidolon.recipe.CrucibleRegistry;
import elucent.eidolon.tile.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class CrucibleTileEntity
extends TileEntityBase
implements ITickableTileEntity {
    boolean boiling = false;
    boolean hasWater = false;
    int stirTicks = 0;
    int stirs = 0;
    int stepCounter = 0;
    List<CrucibleStep> steps = new ArrayList<CrucibleStep>();
    long seed = 0L;
    Random random = new Random();
    public static Predicate<?>[] HOT_BLOCKS = new Predicate[]{b -> b.func_177230_c() == Blocks.field_196814_hQ, b -> b.func_177230_c() == Blocks.field_150480_ab, b -> b.func_177230_c() == Blocks.field_235335_bO_, b -> b.func_177230_c() == Blocks.field_150353_l, b -> b.func_177230_c() == Blocks.field_222433_lV && (Boolean)b.func_177229_b((Property)CampfireBlock.field_220101_b) != false, b -> b.func_177230_c() == Blocks.field_235367_mf_ && (Boolean)b.func_177229_b((Property)CampfireBlock.field_220101_b) != false};

    public float getRed() {
        this.random.setSeed(this.seed);
        return this.random.nextFloat();
    }

    public float getGreen() {
        this.random.setSeed(this.seed * 2L);
        return this.random.nextFloat();
    }

    public float getBlue() {
        this.random.setSeed(this.seed * 3L);
        return this.random.nextFloat();
    }

    public CrucibleTileEntity() {
        this(Registry.CRUCIBLE_TILE_ENTITY);
    }

    public CrucibleTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public ActionResultType onActivated(BlockState state, BlockPos pos, PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            if (player.func_225608_bj_() && player.func_184586_b(hand).func_190926_b() && this.hasWater) {
                this.boiling = false;
                this.hasWater = false;
                this.stirs = 0;
                this.steps.clear();
                if (!this.field_145850_b.field_72995_K) {
                    this.sync();
                    this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_184586_b(hand).func_190926_b() && this.stirTicks == 0 && this.steps.size() > 0) {
                ++this.stirs;
                this.stirTicks = 20;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.sync();
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_184586_b(hand).func_77973_b() == Items.field_151131_as) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
                this.hasWater = true;
                if (!this.field_145850_b.field_72995_K) {
                    this.sync();
                    this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.steps.clear();
        ListNBT steps = tag.func_150295_c("steps", 10);
        for (INBT step2 : steps) {
            this.steps.add(new CrucibleStep((CompoundNBT)step2));
        }
        this.boiling = tag.func_74767_n("boiling");
        this.hasWater = tag.func_74767_n("hasWater");
        this.stirs = tag.func_74762_e("stirs");
        this.stirTicks = tag.func_74762_e("stirTicks");
        this.seed = steps.stream().map(step -> step.hashCode()).reduce(0, (a, b) -> a ^ b).intValue();
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        ListNBT steps = new ListNBT();
        for (CrucibleStep step : this.steps) {
            steps.add((Object)step.write());
        }
        tag.func_218657_a("steps", (INBT)steps);
        tag.func_74757_a("boiling", this.boiling);
        tag.func_74757_a("hasWater", this.hasWater);
        tag.func_74768_a("stirs", this.stirs);
        tag.func_74768_a("stirTicks", this.stirTicks);
        return tag;
    }

    public void func_73660_a() {
        List items;
        float steamB;
        if (this.stirTicks > 0) {
            --this.stirTicks;
        }
        if (this.hasWater && this.field_145850_b.func_82737_E() % 200L == 0L) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
            boolean isHeated = false;
            for (Predicate<?> pred : HOT_BLOCKS) {
                if (!pred.test(state)) continue;
                isHeated = true;
            }
            if (this.boiling && !isHeated) {
                this.boiling = false;
                if (!this.field_145850_b.field_72995_K) {
                    this.sync();
                }
            } else if (!this.boiling && isHeated) {
                this.boiling = true;
                if (!this.field_145850_b.field_72995_K) {
                    this.sync();
                }
            }
        }
        float bubbleR = this.steps.size() > 0 ? Math.min(1.0f, this.getRed() * 1.25f) : 0.25f;
        float bubbleG = this.steps.size() > 0 ? Math.min(1.0f, this.getGreen() * 1.25f) : 0.5f;
        float bubbleB = this.steps.size() > 0 ? Math.min(1.0f, this.getBlue() * 1.25f) : 1.0f;
        float steamR = this.steps.size() > 0 ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getRed(), 2.0)) : 1.0f;
        float steamG = this.steps.size() > 0 ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getGreen(), 2.0)) : 1.0f;
        float f = steamB = this.steps.size() > 0 ? Math.min(1.0f, 1.0f - (float)Math.pow(1.0f - this.getBlue(), 2.0)) : 1.0f;
        if (this.field_145850_b.field_72995_K && this.hasWater && this.boiling) {
            for (int i = 0; i < 2; ++i) {
                Particles.create(Registry.BUBBLE_PARTICLE).setScale(0.05f).setLifetime(10).addVelocity(0.0, 0.015625, 0.0).setColor(bubbleR, bubbleG, bubbleB).setAlpha(1.0f, 0.75f).spawn(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.125 + 0.75 * (double)this.field_145850_b.field_73012_v.nextFloat(), (double)this.field_174879_c.func_177956_o() + 0.6875, (double)this.field_174879_c.func_177952_p() + 0.125 + 0.75 * (double)this.field_145850_b.field_73012_v.nextFloat());
                if (this.field_145850_b.field_73012_v.nextInt(8) != 0) continue;
                Particles.create(Registry.STEAM_PARTICLE).setAlpha(0.0625f, 0.0f).setScale(0.375f, 0.125f).setLifetime(80).randomOffset(0.375, 0.125).randomVelocity(0.0125f, 0.025f).addVelocity(0.0, 0.05f, 0.0).setColor(steamR, steamG, steamB).spawn(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.625, (double)this.field_174879_c.func_177952_p() + 0.5);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.boiling && this.hasWater && this.field_145850_b.func_82737_E() % 8L == 0L) {
            List items2 = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186664_h(0.125));
            for (ItemEntity item : items2) {
                item.func_174867_a(20);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.stepCounter > 0) {
            --this.stepCounter;
            if (this.stepCounter == 0) {
                List items3 = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186664_h(0.125));
                ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
                for (ItemEntity item : items3) {
                    for (int i = 0; i < item.func_92059_d().func_190916_E(); ++i) {
                        ItemStack stack = item.func_92059_d().func_77946_l();
                        stack.func_190920_e(1);
                        contents.add(stack);
                    }
                    item.func_70106_y();
                }
                if (this.stirs == 0 && contents.isEmpty()) {
                    Networking.sendToTracking(this.field_145850_b, this.field_174879_c, new CrucibleFailPacket(this.field_174879_c));
                    contents.clear();
                    this.steps.clear();
                    this.stirs = 0;
                    this.boiling = false;
                    this.hasWater = false;
                    this.sync();
                } else {
                    CrucibleStep step = new CrucibleStep(this.stirs, contents);
                    this.steps.add(step);
                    CrucibleRecipe recipe = CrucibleRegistry.find(this.steps);
                    if (recipe != null) {
                        Networking.sendToTracking(this.field_145850_b, this.field_174879_c, new CrucibleSuccessPacket(this.field_174879_c, steamR, steamG, steamB));
                        double angle = this.field_145850_b.field_73012_v.nextDouble() * Math.PI * 2.0;
                        ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, recipe.getResult().func_77946_l());
                        entity.func_213293_j(Math.sin(angle) * 0.125, 0.25, Math.cos(angle) * 0.125);
                        entity.func_174867_a(10);
                        this.field_145850_b.func_217376_c((Entity)entity);
                        contents.clear();
                        this.steps.clear();
                        this.boiling = false;
                        this.hasWater = false;
                    } else {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.stepCounter = 100;
                    }
                    this.stirs = 0;
                    this.sync();
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.stepCounter == 0 && this.steps.size() == 0 && this.hasWater && this.boiling && this.field_145850_b.func_82737_E() % 100L == 0L && (items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186664_h(0.125))).size() > 0) {
            this.stepCounter = 40;
        }
    }

    public static class CrucibleStep {
        int stirs;
        List<ItemStack> contents = new ArrayList<ItemStack>();

        public CrucibleStep(int stirs, List<ItemStack> contents) {
            this.stirs = stirs;
            this.contents.addAll(contents);
        }

        public int getStirs() {
            return this.stirs;
        }

        public List<ItemStack> getContents() {
            return this.contents;
        }

        public CrucibleStep(CompoundNBT nbt) {
            this.stirs = nbt.func_74762_e("stirs");
            ListNBT list = nbt.func_150295_c("contents", 10);
            for (INBT item : list) {
                this.contents.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)item)));
            }
        }

        public CompoundNBT write() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("stirs", this.stirs);
            ListNBT list = new ListNBT();
            for (ItemStack stack : this.contents) {
                list.add((Object)stack.func_77955_b(new CompoundNBT()));
            }
            nbt.func_218657_a("contents", (INBT)list);
            return nbt;
        }
    }
}

