/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.spell;

import elucent.eidolon.Registry;
import elucent.eidolon.block.HorizontalBlockBase;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.ReputationProvider;
import elucent.eidolon.deity.Deity;
import elucent.eidolon.deity.DeityLocks;
import elucent.eidolon.particle.Particles;
import elucent.eidolon.ritual.Ritual;
import elucent.eidolon.spell.AltarInfo;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.spell.Signs;
import elucent.eidolon.spell.StaticSpell;
import elucent.eidolon.tile.EffigyTileEntity;
import elucent.eidolon.tile.GobletTileEntity;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class VillagerSacrificeSpell
extends StaticSpell {
    Deity deity;

    public VillagerSacrificeSpell(ResourceLocation name, Deity deity, Sign ... signs) {
        super(name, signs);
        this.deity = deity;
    }

    @Override
    public boolean canCast(World world, BlockPos pos, PlayerEntity player) {
        if (!world.getCapability(ReputationProvider.CAPABILITY).isPresent()) {
            return false;
        }
        if (!((IReputation)world.getCapability(ReputationProvider.CAPABILITY).resolve().get()).canPray(player, world.func_82737_E())) {
            return false;
        }
        if (((IReputation)world.getCapability(ReputationProvider.CAPABILITY).resolve().get()).getReputation(player.func_110124_au(), this.deity.getId()) < 15.0) {
            return false;
        }
        List<GobletTileEntity> goblets = Ritual.getTilesWithinAABB(GobletTileEntity.class, world, new AxisAlignedBB(pos.func_177982_a(-4, -4, -4), pos.func_177982_a(5, 5, 5)));
        List<EffigyTileEntity> effigies = Ritual.getTilesWithinAABB(EffigyTileEntity.class, world, new AxisAlignedBB(pos.func_177982_a(-4, -4, -4), pos.func_177982_a(5, 5, 5)));
        if (effigies.size() == 0 || goblets.size() == 0) {
            return false;
        }
        EffigyTileEntity effigy = effigies.stream().min(Comparator.comparingDouble(e -> e.func_174877_v().func_177951_i((Vector3i)pos))).get();
        GobletTileEntity goblet = goblets.stream().min(Comparator.comparingDouble(e -> e.func_174877_v().func_177951_i((Vector3i)pos))).get();
        if (goblet.getEntityType() == null) {
            return false;
        }
        AltarInfo info = AltarInfo.getAltarInfo(world, effigy.func_174877_v());
        if (info.getAltar() != Registry.STONE_ALTAR.get() || info.getIcon() != Registry.UNHOLY_EFFIGY.get()) {
            return false;
        }
        Entity test = goblet.getEntityType().func_200721_a(world);
        return (test instanceof AbstractVillagerEntity || test instanceof PlayerEntity) && effigy.ready();
    }

    @Override
    public void cast(World world, BlockPos pos, PlayerEntity player) {
        List<GobletTileEntity> goblets = Ritual.getTilesWithinAABB(GobletTileEntity.class, world, new AxisAlignedBB(pos.func_177982_a(-4, -4, -4), pos.func_177982_a(5, 5, 5)));
        List<EffigyTileEntity> effigies = Ritual.getTilesWithinAABB(EffigyTileEntity.class, world, new AxisAlignedBB(pos.func_177982_a(-4, -4, -4), pos.func_177982_a(5, 5, 5)));
        if (effigies.size() == 0 || goblets.size() == 0) {
            return;
        }
        EffigyTileEntity effigy = effigies.stream().min(Comparator.comparingDouble(e -> e.func_174877_v().func_177951_i((Vector3i)pos))).get();
        GobletTileEntity goblet = goblets.stream().min(Comparator.comparingDouble(e -> e.func_174877_v().func_177951_i((Vector3i)pos))).get();
        if (!world.field_72995_K) {
            effigy.pray();
            goblet.setEntityType(null);
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.func_174877_v());
            world.getCapability(ReputationProvider.CAPABILITY, null).ifPresent(rep -> {
                rep.pray(player, world.func_82737_E());
                double prev = rep.getReputation(player, this.deity.getId());
                if (rep.unlock(player, this.deity.getId(), DeityLocks.SACRIFICE_VILLAGER)) {
                    this.deity.onReputationUnlock(player, (IReputation)rep, DeityLocks.SACRIFICE_VILLAGER);
                }
                rep.addReputation(player, this.deity.getId(), 6.0 + 1.0 * info.getPower());
                this.deity.onReputationChange(player, (IReputation)rep, prev, rep.getReputation(player, this.deity.getId()));
            });
        } else {
            world.func_184133_a(player, effigy.func_174877_v(), SoundEvents.field_187754_de, SoundCategory.NEUTRAL, 10000.0f, 0.6f + world.field_73012_v.nextFloat() * 0.2f);
            world.func_184133_a(player, effigy.func_174877_v(), SoundEvents.field_187752_dd, SoundCategory.NEUTRAL, 2.0f, 0.5f + world.field_73012_v.nextFloat() * 0.2f);
            BlockState state = world.func_180495_p(effigy.func_174877_v());
            Direction dir = (Direction)state.func_177229_b((Property)HorizontalBlockBase.HORIZONTAL_FACING);
            Direction tangent = dir.func_176746_e();
            float x = (float)effigy.func_174877_v().func_177958_n() + 0.5f + (float)dir.func_82601_c() * 0.21875f;
            float y = (float)effigy.func_174877_v().func_177956_o() + 0.8125f;
            float z = (float)effigy.func_174877_v().func_177952_p() + 0.5f + (float)dir.func_82599_e() * 0.21875f;
            Particles.create(Registry.FLAME_PARTICLE).setColor(Signs.SOUL_SIGN.getRed(), Signs.SOUL_SIGN.getGreen(), Signs.SOUL_SIGN.getBlue()).setAlpha(0.5f, 0.0f).setScale(0.125f, 0.0625f).randomOffset(0.01f).randomVelocity(0.0025f).addVelocity(0.0, 0.005f, 0.0).repeat(world, x + 0.09375f * (float)tangent.func_82601_c(), y, z + 0.09375f * (float)tangent.func_82599_e(), 8);
            Particles.create(Registry.FLAME_PARTICLE).setColor(Signs.SOUL_SIGN.getRed(), Signs.SOUL_SIGN.getGreen(), Signs.SOUL_SIGN.getBlue()).setAlpha(0.5f, 0.0f).setScale(0.1875f, 0.125f).randomOffset(0.01f).randomVelocity(0.0025f).addVelocity(0.0, 0.005f, 0.0).repeat(world, x - 0.09375f * (float)tangent.func_82601_c(), y, z - 0.09375f * (float)tangent.func_82599_e(), 8);
        }
    }
}

