/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.Eidolon;
import elucent.eidolon.spell.Sign;
import elucent.eidolon.spell.Signs;
import elucent.eidolon.spell.Spell;
import elucent.eidolon.spell.Spells;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpellCastPacket {
    List<Sign> signs = new ArrayList<Sign>();
    Spell spell;
    BlockPos pos;
    UUID uuid;

    public SpellCastPacket(PlayerEntity player, BlockPos pos, Spell spell, List<Sign> signs) {
        this.signs.addAll(signs);
        this.pos = pos;
        this.spell = spell;
        this.uuid = player.func_110124_au();
    }

    public SpellCastPacket(UUID uuid, BlockPos pos, ResourceLocation location, List<Sign> signs) {
        this.signs.addAll(signs);
        this.pos = pos;
        this.spell = Spells.find(location);
        this.uuid = uuid;
    }

    public static void encode(SpellCastPacket object, PacketBuffer buffer) {
        buffer.func_180714_a(object.spell.getRegistryName().toString());
        buffer.writeInt(object.signs.size());
        for (int i = 0; i < object.signs.size(); ++i) {
            buffer.func_180714_a(object.signs.get(i).getRegistryName().toString());
        }
        buffer.func_179252_a(object.uuid);
        buffer.func_179255_a(object.pos);
    }

    public static SpellCastPacket decode(PacketBuffer buffer) {
        ResourceLocation spell = new ResourceLocation(buffer.func_218666_n());
        int n = buffer.readInt();
        ArrayList<Sign> signs = new ArrayList<Sign>();
        for (int i = 0; i < n; ++i) {
            signs.add(Signs.find(new ResourceLocation(buffer.func_218666_n())));
        }
        return new SpellCastPacket(buffer.func_179253_g(), buffer.func_179259_c(), spell, signs);
    }

    public static void consume(SpellCastPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player;
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            World world = Eidolon.proxy.getWorld();
            if (world != null && (player = world.func_217371_b(packet.uuid)) != null) {
                List<Sign> signs = packet.signs;
                packet.spell.cast(world, packet.pos, player, signs);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

