/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.item;

import elucent.eidolon.item.Tiers;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReversalPickItem
extends PickaxeItem {
    String loreTag = null;

    public ReversalPickItem(Item.Properties builderIn) {
        super((IItemTier)Tiers.MagicToolTier.INSTANCE, 1, -2.8f, builderIn);
        MinecraftForge.EVENT_BUS.addListener(ReversalPickItem::onStartBreak);
    }

    public Item setLore(String tag) {
        this.loreTag = tag;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.loreTag != null) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new StringTextComponent("" + TextFormatting.DARK_PURPLE + TextFormatting.ITALIC + I18n.func_135052_a((String)this.loreTag, (Object[])new Object[0])));
        }
    }

    @SubscribeEvent
    public static void onStartBreak(PlayerEvent.BreakSpeed event) {
        if (event.getPlayer().func_184614_ca().func_77973_b() instanceof ReversalPickItem) {
            float hardness = event.getState().func_185887_b((IBlockReader)event.getEntity().field_70170_p, event.getPos());
            float adjHardness = 1.0f / (hardness / 1.5f + (float)event.getState().getHarvestLevel());
            float newSpeed = MathHelper.func_76129_c((float)(event.getOriginalSpeed() * 0.25f)) * MathHelper.func_76129_c((float)(hardness / adjHardness));
            event.setNewSpeed(newSpeed * newSpeed);
        }
    }
}

