/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import elucent.eidolon.Registry;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.gui.jei.RecipeWrappers;
import elucent.eidolon.ritual.IRequirement;
import elucent.eidolon.ritual.ItemRequirement;
import elucent.eidolon.ritual.MultiItemSacrifice;
import elucent.eidolon.ritual.RitualRegistry;
import elucent.eidolon.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RitualCategory
implements IRecipeCategory<RecipeWrappers.RitualRecipe> {
    static final ResourceLocation UID = new ResourceLocation("eidolon", "ritual");
    private final IDrawable background;
    private final IDrawable icon;

    public RitualCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("eidolon", "textures/gui/jei_page_bg.png"), 0, 0, 138, 172);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Registry.BRAZIER.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class getRecipeClass() {
        return RecipeWrappers.RitualRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.eidolon.ritual", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RecipeWrappers.RitualRecipe wrapper, IIngredients ingredients) {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        Object sacrifice = wrapper.sacrifice;
        if (wrapper.page == null) {
            wrapper.page = RitualRegistry.getDefaultPage(wrapper.ritual, wrapper.sacrifice);
        }
        int slot = 0;
        for (IRequirement r : wrapper.ritual.getRequirements()) {
            if (r instanceof ItemRequirement) {
                inputs.add(StackUtil.ingredientFromObject(((ItemRequirement)r).getMatch()));
            }
            ++slot;
        }
        inputs.add(StackUtil.ingredientFromObject(sacrifice instanceof MultiItemSacrifice ? ((MultiItemSacrifice)sacrifice).main : sacrifice));
        ingredients.setInputIngredients(inputs);
    }

    public void setRecipe(IRecipeLayout layout, RecipeWrappers.RitualRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List items = ingredients.getInputs(VanillaTypes.ITEM);
        float angleStep = Math.min(30, 180 / (items.size() - 1));
        double rootAngle = 90.0f - (float)(items.size() - 2) * angleStep / 2.0f;
        for (int i = 0; i < items.size() - 1; ++i) {
            double a = Math.toRadians(rootAngle + (double)(angleStep * (float)i));
            int dx = (int)(68.0 + 48.0 * Math.cos(a));
            int dy = (int)(91.0 + 48.0 * Math.sin(a));
            stacks.init(i, true, dx - 8, dy - 8);
        }
        stacks.init(items.size() - 1, true, 60, 83);
        stacks.set(ingredients);
    }

    public void draw(RecipeWrappers.RitualRecipe recipe, MatrixStack mStack, double mouseX, double mouseY) {
        recipe.page.renderBackground(CodexGui.DUMMY, mStack, 5, 4, (int)mouseX, (int)mouseY);
        recipe.page.render(CodexGui.DUMMY, mStack, 5, 4, (int)mouseX, (int)mouseY);
    }
}

