/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.gui;

import com.google.common.collect.Lists;
import elucent.eidolon.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class SoulEnchanterContainer
extends Container {
    private final IInventory tableInventory = new Inventory(2){

        public void func_70296_d() {
            super.func_70296_d();
            SoulEnchanterContainer.this.func_75130_a((IInventory)this);
        }
    };
    private final IWorldPosCallable worldPosCallable;
    private final Random rand = new Random();
    private final IntReferenceHolder xpSeed = IntReferenceHolder.func_221492_a();
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] worldClue = new int[]{-1, -1, -1};

    public SoulEnchanterContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public SoulEnchanterContainer(int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable) {
        super((ContainerType)Registry.SOUL_ENCHANTER_CONTAINER.get(), id);
        this.worldPosCallable = worldPosCallable;
        this.func_75146_a(new Slot(this.tableInventory, 0, 15, 47){

            public boolean func_75214_a(ItemStack stack) {
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.tableInventory, 1, 35, 47){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == Registry.SOUL_SHARD.get();
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
        this.func_216958_a(this.xpSeed).func_221494_a(playerInventory.field_70458_d.func_175138_ci());
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantClue, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantClue, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantClue, (int)2));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.worldClue, (int)0));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.worldClue, (int)1));
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.worldClue, (int)2));
    }

    private float getPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (inventoryIn == this.tableInventory) {
            ItemStack itemstack = inventoryIn.func_70301_a(0);
            if (!itemstack.func_190926_b() && (itemstack.func_77956_u() || itemstack.func_77948_v() || itemstack.func_77973_b() == Items.field_151134_bR)) {
                this.worldPosCallable.func_221486_a((world, pos) -> {
                    int power = 0;
                    for (int k = -1; k <= 1; ++k) {
                        for (int l = -1; l <= 1; ++l) {
                            if (k == 0 && l == 0 || !world.func_175623_d(pos.func_177982_a(l, 0, k)) || !world.func_175623_d(pos.func_177982_a(l, 1, k))) continue;
                            power = (int)((float)power + this.getPower((World)world, pos.func_177982_a(l * 2, 0, k * 2)));
                            power = (int)((float)power + this.getPower((World)world, pos.func_177982_a(l * 2, 1, k * 2)));
                            if (l == 0 || k == 0) continue;
                            power = (int)((float)power + this.getPower((World)world, pos.func_177982_a(l * 2, 0, k)));
                            power = (int)((float)power + this.getPower((World)world, pos.func_177982_a(l * 2, 1, k)));
                            power = (int)((float)power + this.getPower((World)world, pos.func_177982_a(l, 0, k * 2)));
                            power = (int)((float)power + this.getPower((World)world, pos.func_177982_a(l, 1, k * 2)));
                        }
                    }
                    this.rand.setSeed(this.xpSeed.func_221495_b());
                    for (int i1 = 0; i1 < 3; ++i1) {
                        this.enchantClue[i1] = -1;
                        this.worldClue[i1] = -1;
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        List<EnchantmentData> list = this.getEnchantmentList(itemstack, j1);
                        if (list == null || list.isEmpty()) continue;
                        EnchantmentData enchantmentdata = list.get(this.rand.nextInt(list.size()));
                        this.enchantClue[j1] = net.minecraft.util.registry.Registry.field_212628_q.func_148757_b((Object)enchantmentdata.field_76302_b);
                        this.worldClue[j1] = enchantmentdata.field_76303_c;
                    }
                    this.func_75142_b();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.enchantClue[i] = -1;
                    this.worldClue[i] = -1;
                }
            }
        }
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        ItemStack itemstack = this.tableInventory.func_70301_a(0);
        ItemStack itemstack1 = this.tableInventory.func_70301_a(1);
        int i = id + 1;
        if ((itemstack1.func_190926_b() || itemstack1.func_190916_E() < 1) && !playerIn.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (itemstack.func_190926_b() || playerIn.field_71068_ca < this.worldClue[id] && !playerIn.field_71075_bZ.field_75098_d) {
            return false;
        }
        this.worldPosCallable.func_221486_a((p_217003_6_, p_217003_7_) -> {
            ItemStack itemstack2 = itemstack;
            List<EnchantmentData> list = this.getEnchantmentList(itemstack, id);
            if (!list.isEmpty()) {
                Map enchants;
                boolean flag;
                playerIn.func_192024_a(itemstack, this.worldClue[id]);
                boolean bl = flag = itemstack.func_77973_b() == Items.field_151122_aG;
                if (flag) {
                    itemstack2 = new ItemStack((IItemProvider)Items.field_151134_bR);
                    CompoundNBT compoundnbt = itemstack.func_77978_p();
                    if (compoundnbt != null) {
                        itemstack2.func_77982_d(compoundnbt.func_74737_b());
                    }
                    this.tableInventory.func_70299_a(0, itemstack2);
                }
                if ((enchants = EnchantmentHelper.func_82781_a((ItemStack)itemstack2)).size() > 0) {
                    for (int j = 0; j < list.size(); ++j) {
                        EnchantmentData data = list.get(j);
                        if (enchants.containsKey(data.field_76302_b)) {
                            enchants.replace(data.field_76302_b, data.field_76303_c);
                            continue;
                        }
                        enchants.put(data.field_76302_b, data.field_76303_c);
                    }
                    EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)itemstack2);
                } else {
                    for (int j = 0; j < list.size(); ++j) {
                        EnchantmentData data = list.get(j);
                        if (flag) {
                            EnchantedBookItem.func_92115_a((ItemStack)itemstack2, (EnchantmentData)data);
                            continue;
                        }
                        itemstack2.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack1.func_190918_g(1);
                    if (itemstack1.func_190926_b()) {
                        this.tableInventory.func_70299_a(1, ItemStack.field_190927_a);
                    }
                }
                playerIn.func_195066_a(Stats.field_188091_Y);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_192129_i.func_192190_a((ServerPlayerEntity)playerIn, itemstack2, i);
                }
                this.tableInventory.func_70296_d();
                this.xpSeed.func_221494_a(playerIn.func_175138_ci());
                this.func_75130_a(this.tableInventory);
                p_217003_6_.func_184133_a((PlayerEntity)null, p_217003_7_, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, p_217003_6_.field_73012_v.nextFloat() * 0.1f + 0.7f);
            }
        });
        return true;
    }

    public static int getEnchantmentLevel(Enchantment enchID, ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        ResourceLocation resourcelocation = net.minecraft.util.registry.Registry.field_212628_q.func_177774_c((Object)enchID);
        ListNBT listnbt = stack.func_77973_b() == Items.field_151134_bR ? EnchantedBookItem.func_92110_g((ItemStack)stack) : stack.func_77986_q();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            ResourceLocation resourcelocation1 = ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("id"));
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            return MathHelper.func_76125_a((int)compoundnbt.func_74762_e("lvl"), (int)0, (int)255);
        }
        return 0;
    }

    private List<EnchantmentData> getEnchantmentList(ItemStack stack, int enchantSlot) {
        this.rand.setSeed(this.xpSeed.func_221495_b() + enchantSlot);
        ItemStack test = stack.func_77946_l();
        EnchantmentHelper.func_82782_a(new HashMap(), (ItemStack)test);
        if (test.func_77973_b() == Items.field_151134_bR) {
            test = new ItemStack((IItemProvider)Items.field_151122_aG);
        }
        ItemStack finalTest = test;
        Map existing = EnchantmentHelper.func_82781_a((ItemStack)stack);
        ArrayList valid = Lists.newArrayList((Iterable)ForgeRegistries.ENCHANTMENTS.getValues());
        valid.removeIf(ench -> {
            boolean canApply = ench.canApplyAtEnchantingTable(finalTest) || finalTest.func_77973_b() == Items.field_151122_aG && ench.isAllowedOnBooks();
            return !canApply || ench.func_185261_e() || existing.containsKey(ench) && (Integer)existing.get(ench) >= ench.func_77325_b();
        });
        for (Map.Entry e : existing.entrySet()) {
            Iterator iterator = valid.iterator();
            while (iterator.hasNext()) {
                Enchantment next = (Enchantment)iterator.next();
                if (((Enchantment)e.getKey()).func_191560_c(next) || e.getKey() == next) continue;
                iterator.remove();
            }
        }
        ArrayList<EnchantmentData> enchants = new ArrayList<EnchantmentData>();
        if (valid.isEmpty()) {
            return enchants;
        }
        for (int i = 0; i < enchantSlot; ++i) {
            this.rand.nextInt(valid.size());
        }
        Enchantment enchant = (Enchantment)valid.get(this.rand.nextInt(valid.size()));
        int level = SoulEnchanterContainer.getEnchantmentLevel(enchant, stack);
        if (level > 0) {
            enchants.add(new EnchantmentData(enchant, level + 1));
        } else {
            enchants.add(new EnchantmentData(enchant, 1));
        }
        return enchants;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSoulShardAmount() {
        ItemStack itemstack = this.tableInventory.func_70301_a(1);
        return itemstack.func_190926_b() ? 0 : itemstack.func_190916_E();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getXPSeed() {
        return this.xpSeed.func_221495_b();
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, playerIn.field_70170_p, this.tableInventory));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return SoulEnchanterContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)Registry.SOUL_ENCHANTER.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (itemstack1.func_77973_b() == Registry.SOUL_SHARD.get()) {
                if (!this.func_75135_a(itemstack1, 1, 2, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d() || !((Slot)this.field_75151_b.get(0)).func_75214_a(itemstack1)) {
                    return ItemStack.field_190927_a;
                }
                ItemStack itemstack2 = itemstack1.func_77946_l();
                itemstack2.func_190920_e(1);
                itemstack1.func_190918_g(1);
                ((Slot)this.field_75151_b.get(0)).func_75215_d(itemstack2);
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }
}

