/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.ritual.Ritual;
import elucent.eidolon.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RitualPage
extends Page {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_ritual_page.png");
    Ritual ritual;
    ItemStack center;
    RitualIngredient[] inputs;

    public RitualPage(Ritual ritual, ItemStack center, RitualIngredient ... inputs) {
        super(BACKGROUND);
        this.ritual = ritual;
        this.center = center;
        this.inputs = inputs;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, MatrixStack mStack, int x, int y, int mouseX, int mouseY) {
        float angleStep = Math.min(30, 180 / this.inputs.length);
        double rootAngle = 90.0f - (float)(this.inputs.length - 1) * angleStep / 2.0f;
        for (int i = 0; i < this.inputs.length; ++i) {
            double a = Math.toRadians(rootAngle + (double)(angleStep * (float)i));
            int dx = (int)(64.0 + 48.0 * Math.cos(a));
            int dy = (int)(88.0 + 48.0 * Math.sin(a));
            if (this.inputs[i].isFocus) {
                gui.func_238474_b_(mStack, x + dx - 13, y + dy - 13, 128, 0, 26, 24);
                continue;
            }
            gui.func_238474_b_(mStack, x + dx - 8, y + dy - 8, 154, 0, 16, 16);
        }
        RenderSystem.enableBlend();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.alphaFunc((int)518, (float)0.00390625f);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Tessellator tess = Tessellator.func_178181_a();
        RenderSystem.disableTexture();
        RenderSystem.depthMask((boolean)false);
        RenderUtil.dragon(mStack, (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)tess.func_178180_c()), x + 64, y + 48, 20.0, 20.0f, this.ritual.getRed(), this.ritual.getGreen(), this.ritual.getBlue());
        tess.func_78381_a();
        RenderSystem.enableTexture();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        for (int j = 0; j < 2; ++j) {
            RenderUtil.litQuad(mStack, (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)tess.func_178180_c()), x + 52, y + 36, 24.0, 24.0, this.ritual.getRed(), this.ritual.getGreen(), this.ritual.getBlue(), (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(this.ritual.getSymbol()));
            tess.func_78381_a();
        }
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableBlend();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderIngredients(CodexGui gui, MatrixStack mStack, int x, int y, int mouseX, int mouseY) {
        float angleStep = Math.min(30, 180 / this.inputs.length);
        double rootAngle = 90.0f - (float)(this.inputs.length - 1) * angleStep / 2.0f;
        for (int i = 0; i < this.inputs.length; ++i) {
            double a = Math.toRadians(rootAngle + (double)(angleStep * (float)i));
            int dx = (int)(64.0 + 48.0 * Math.cos(a));
            int dy = (int)(88.0 + 48.0 * Math.sin(a));
            RitualPage.drawItem(gui, mStack, this.inputs[i].stack, x + dx - 8, y + dy - 8, mouseX, mouseY);
        }
        RitualPage.drawItem(gui, mStack, this.center, x + 56, y + 80, mouseX, mouseY);
    }

    public static class RitualIngredient {
        public ItemStack stack;
        public boolean isFocus;

        public RitualIngredient(ItemStack stack, boolean isFocus) {
            this.stack = stack;
            this.isFocus = isFocus;
        }
    }
}

