/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import elucent.eidolon.codex.Chapter;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.util.ColorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Category {
    ItemStack icon;
    String key;
    Chapter chapter;
    int color;
    float hoveramount = 0.0f;

    public Category(String name, ItemStack icon, int color, Chapter chapter) {
        this.icon = icon;
        this.key = name;
        this.chapter = chapter;
        this.color = color;
    }

    protected void reset() {
        this.hoveramount = 0.0f;
    }

    static void colorBlit(MatrixStack mStack, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight, int color) {
        Matrix4f matrix = mStack.func_227866_c_().func_227870_a_();
        int maxX = x + width;
        int maxY = y + height;
        float minU = (float)uOffset / (float)textureWidth;
        float minV = (float)vOffset / (float)textureHeight;
        float maxU = minU + (float)width / (float)textureWidth;
        float maxV = minV + (float)height / (float)textureHeight;
        int r = ColorUtil.getRed(color);
        int g = ColorUtil.getGreen(color);
        int b = ColorUtil.getBlue(color);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)maxY, 0.0f).func_225583_a_(minU, maxV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)maxX, (float)maxY, 0.0f).func_225583_a_(maxU, maxV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)maxX, (float)y, 0.0f).func_225583_a_(maxU, minV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_225583_a_(minU, minV).func_225586_a_(r, g, b, 255).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public boolean click(CodexGui gui, int x, int y, boolean right, int mouseX, int mouseY) {
        boolean hover;
        int w = 36;
        if (!right) {
            x -= 36;
        }
        w = (int)((float)w + this.hoveramount * 12.0f);
        if (!right) {
            x = (int)((float)x - this.hoveramount * 12.0f);
        }
        boolean bl = hover = mouseX >= x && mouseY >= y && mouseX <= x + w && mouseY <= y + 19;
        if (hover) {
            gui.currentPage = 0;
            gui.currentChapter = this.chapter;
            gui.resetPages();
            return true;
        }
        return false;
    }

    public void draw(CodexGui gui, MatrixStack mStack, int x, int y, boolean right, int mouseX, int mouseY) {
        boolean hover;
        int w = 36;
        if (!right) {
            x -= 36;
        }
        w = (int)((float)w + this.hoveramount * 12.0f);
        if (!right) {
            x = (int)((float)x - this.hoveramount * 12.0f);
        }
        boolean bl = hover = mouseX >= x && mouseY >= y && mouseX <= x + w && mouseY <= y + 19;
        if (hover && this.hoveramount < 1.0f) {
            this.hoveramount += Minecraft.func_71410_x().func_184121_ak() / 4.0f;
        } else if (!hover && this.hoveramount > 0.0f) {
            this.hoveramount -= Minecraft.func_71410_x().func_184121_ak() / 4.0f;
        }
        this.hoveramount = MathHelper.func_76131_a((float)this.hoveramount, (float)0.0f, (float)1.0f);
        if (right) {
            x -= 12;
            x = (int)((float)x + this.hoveramount * 12.0f);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CodexGui.CODEX_BACKGROUND);
        Category.colorBlit(mStack, x, y, 208, right ? 208 : 227, 48, 19, 512, 512, this.color);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(this.icon, x + (right ? 23 : 9), y + 1);
    }

    public void drawTooltip(CodexGui gui, MatrixStack mStack, int x, int y, boolean right, int mouseX, int mouseY) {
        boolean hover;
        int w = 36;
        if (!right) {
            x -= 36;
        }
        w = (int)((float)w + this.hoveramount * 12.0f);
        if (!right) {
            x = (int)((float)x - this.hoveramount * 12.0f);
        }
        boolean bl = hover = mouseX >= x && mouseY >= y && mouseX <= x + w && mouseY <= y + 19;
        if (hover) {
            gui.func_238652_a_(mStack, (ITextComponent)new TranslationTextComponent("eidolon.codex.category." + this.key), mouseX, mouseY);
        }
    }
}

