/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon;

import elucent.eidolon.ClientConfig;
import elucent.eidolon.ClientEvents;
import elucent.eidolon.Config;
import elucent.eidolon.Events;
import elucent.eidolon.Registry;
import elucent.eidolon.WorldGen;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.capability.KnowledgeImpl;
import elucent.eidolon.capability.KnowledgeStorage;
import elucent.eidolon.capability.ReputationImpl;
import elucent.eidolon.capability.ReputationStorage;
import elucent.eidolon.codex.CodexChapters;
import elucent.eidolon.entity.EmptyRenderer;
import elucent.eidolon.entity.NecromancerEntity;
import elucent.eidolon.entity.NecromancerModel;
import elucent.eidolon.entity.NecromancerRenderer;
import elucent.eidolon.entity.WraithEntity;
import elucent.eidolon.entity.WraithModel;
import elucent.eidolon.entity.WraithRenderer;
import elucent.eidolon.entity.ZombieBruteEntity;
import elucent.eidolon.entity.ZombieBruteModel;
import elucent.eidolon.entity.ZombieBruteRenderer;
import elucent.eidolon.gui.SoulEnchanterScreen;
import elucent.eidolon.gui.WoodenBrewingStandScreen;
import elucent.eidolon.gui.WorktableScreen;
import elucent.eidolon.network.Networking;
import elucent.eidolon.proxy.ClientProxy;
import elucent.eidolon.proxy.ISidedProxy;
import elucent.eidolon.proxy.ServerProxy;
import elucent.eidolon.recipe.CrucibleRegistry;
import elucent.eidolon.recipe.WorktableRegistry;
import elucent.eidolon.ritual.RitualRegistry;
import elucent.eidolon.spell.AltarEntries;
import elucent.eidolon.tile.BrazierTileRenderer;
import elucent.eidolon.tile.CrucibleTileRenderer;
import elucent.eidolon.tile.GobletTileRenderer;
import elucent.eidolon.tile.HandTileRenderer;
import elucent.eidolon.tile.NecroticFocusTileRenderer;
import elucent.eidolon.tile.SoulEnchanterTileRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="eidolon")
public class Eidolon {
    public static ISidedProxy proxy = (ISidedProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final String MODID = "eidolon";
    public static final ItemGroup TAB = new ItemGroup("eidolon"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Registry.SHADOW_GEM.get(), 1);
        }
    };

    public Eidolon() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendImc);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientConfig.SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new Registry());
        Registry.init();
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)new WorldGen());
        WorldGen.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
            return new Object();
        });
    }

    public void setup(FMLCommonSetupEvent event) {
        Networking.init();
        WorldGen.init();
        event.enqueueWork(() -> {
            CrucibleRegistry.init();
            WorktableRegistry.init();
            RitualRegistry.init();
            CodexChapters.init();
            Registry.addBrewingRecipes();
            AltarEntries.init();
        });
        event.enqueueWork(this::defineAttributes);
        CapabilityManager.INSTANCE.register(IReputation.class, (Capability.IStorage)new ReputationStorage(), ReputationImpl::new);
        CapabilityManager.INSTANCE.register(IKnowledge.class, (Capability.IStorage)new KnowledgeStorage(), KnowledgeImpl::new);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)Registry.ZOMBIE_BRUTE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)Registry.WRAITH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registry.ZOMBIE_BRUTE.get()), erm -> new ZombieBruteRenderer(erm, new ZombieBruteModel(), 0.6f));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registry.WRAITH.get()), erm -> new WraithRenderer(erm, new WraithModel(), 0.6f));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registry.NECROMANCER.get()), erm -> new NecromancerRenderer(erm, new NecromancerModel(0.0f), 0.6f));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registry.SOULFIRE_PROJECTILE.get()), erm -> new EmptyRenderer(erm));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registry.BONECHILL_PROJECTILE.get()), erm -> new EmptyRenderer(erm));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registry.NECROMANCER_SPELL.get()), erm -> new EmptyRenderer(erm));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registry.CHANT_CASTER.get()), erm -> new EmptyRenderer(erm));
        ClientRegistry.bindTileEntityRenderer(Registry.HAND_TILE_ENTITY, trd -> new HandTileRenderer((TileEntityRendererDispatcher)trd));
        ClientRegistry.bindTileEntityRenderer(Registry.BRAZIER_TILE_ENTITY, trd -> new BrazierTileRenderer((TileEntityRendererDispatcher)trd));
        ClientRegistry.bindTileEntityRenderer(Registry.NECROTIC_FOCUS_TILE_ENTITY, trd -> new NecroticFocusTileRenderer((TileEntityRendererDispatcher)trd));
        ClientRegistry.bindTileEntityRenderer(Registry.CRUCIBLE_TILE_ENTITY, trd -> new CrucibleTileRenderer((TileEntityRendererDispatcher)trd));
        ClientRegistry.bindTileEntityRenderer(Registry.SOUL_ENCHANTER_TILE_ENTITY, trd -> new SoulEnchanterTileRenderer((TileEntityRendererDispatcher)trd));
        ClientRegistry.bindTileEntityRenderer(Registry.GOBLET_TILE_ENTITY, trd -> new GobletTileRenderer((TileEntityRendererDispatcher)trd));
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ENCHANTED_ASH.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.WOODEN_STAND.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.GOBLET.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.UNHOLY_EFFIGY.get()), (RenderType)RenderType.func_228641_d_());
        event.enqueueWork(() -> {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.WORKTABLE_CONTAINER.get()), WorktableScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.SOUL_ENCHANTER_CONTAINER.get()), SoulEnchanterScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.WOODEN_STAND_CONTAINER.get()), WoodenBrewingStandScreen::new);
        });
    }

    public void defineAttributes() {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)Registry.ZOMBIE_BRUTE.get()), (AttributeModifierMap)ZombieBruteEntity.createAttributes());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)Registry.WRAITH.get()), (AttributeModifierMap)WraithEntity.createAttributes());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)Registry.NECROMANCER.get()), (AttributeModifierMap)NecromancerEntity.createAttributes());
    }

    public void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.NECKLACE.getMessageBuilder().build());
    }
}

