/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class TraderTileentityBase
extends VillagerTileentity
implements ITickableTileEntity {
    private Block workstation = Blocks.field_150350_a;
    private long nextRestock;

    public TraderTileentityBase(TileEntityType type, BlockState defaultState) {
        super(type, defaultState);
    }

    public Block getWorkstation() {
        return this.workstation;
    }

    public boolean hasWorkstation() {
        return this.workstation != Blocks.field_150350_a;
    }

    public void setWorkstation(Block workstation) {
        this.workstation = workstation;
        if (this.hasVillager()) {
            this.fixProfession();
        }
        this.func_70296_d();
        this.sync();
    }

    public Block removeWorkstation() {
        Block w = this.workstation;
        this.setWorkstation(Blocks.field_150350_a);
        return w;
    }

    public boolean isValidBlock(Block block) {
        return PointOfInterestType.func_221047_b((BlockState)block.func_176223_P()).isPresent();
    }

    public VillagerProfession getWorkstationProfession() {
        return PointOfInterestType.func_221047_b((BlockState)this.workstation.func_176223_P()).flatMap(pointOfInterestType -> ForgeRegistries.PROFESSIONS.getValues().stream().filter(villagerProfession -> villagerProfession.func_221149_b() == pointOfInterestType).findFirst()).orElse(VillagerProfession.field_221151_a);
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        if (this.hasWorkstation()) {
            this.fixProfession();
        }
    }

    private void fixProfession() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null || v.func_213708_dV() > 0 || v.func_213700_eh().func_221130_b().equals(VillagerProfession.field_221162_l)) {
            return;
        }
        v.func_213753_a(v.func_213700_eh().func_221126_a(this.getWorkstationProfession()));
    }

    public boolean openTradingGUI(PlayerEntity playerEntity) {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return false;
        }
        if (villagerEntity.func_70631_g_()) {
            return false;
        }
        VillagerProfession profession = villagerEntity.func_213700_eh().func_221130_b();
        if (profession.equals(VillagerProfession.field_221151_a) || profession.equals(VillagerProfession.field_221162_l)) {
            return false;
        }
        if (villagerEntity.func_213716_dX()) {
            return false;
        }
        villagerEntity.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 0.5);
        villagerEntity.func_213740_f(playerEntity);
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null) {
            return;
        }
        if (this.advanceAge()) {
            this.sync();
        }
        this.func_70296_d();
        VillagerBlockBase.playRandomVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187910_gj);
        if (!v.func_213716_dX()) {
            if (v.field_213777_bF) {
                v.func_175554_cu();
                v.field_213777_bF = false;
                this.sync();
            }
            if (this.field_145850_b.func_82737_E() - this.getLastRestock() > this.nextRestock && v.func_213700_eh().func_221130_b().equals(this.getWorkstationProfession())) {
                this.restock();
                this.nextRestock = this.calculateNextRestock();
            }
        }
    }

    protected long calculateNextRestock() {
        return (Integer)Main.SERVER_CONFIG.traderMinRestockTime.get() + this.field_145850_b.field_73012_v.nextInt(Math.max((Integer)Main.SERVER_CONFIG.traderMaxRestockTime.get() - (Integer)Main.SERVER_CONFIG.traderMinRestockTime.get(), 1));
    }

    protected void restock() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return;
        }
        try {
            villagerEntity.func_213766_ei();
            VillagerBlockBase.playVillagerSound(this.field_145850_b, this.func_174877_v(), villagerEntity.func_213700_eh().func_221130_b().func_226558_e_());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected long getLastRestock() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return 0L;
        }
        return villagerEntity.field_213785_bP;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.hasWorkstation()) {
            compound.func_74778_a("Workstation", this.workstation.getRegistryName().toString());
        }
        compound.func_74772_a("NextRestock", this.nextRestock);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("Workstation")) {
            this.workstation = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i("Workstation")));
        } else {
            this.removeWorkstation();
        }
        this.nextRestock = compound.func_74763_f("NextRestock");
        super.func_230337_a_(state, compound);
    }
}

