/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class FarmerTileentity
extends VillagerTileentity
implements ITickableTileEntity {
    private BlockState crop;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private IItemHandlerModifiable handler;

    public FarmerTileentity() {
        super(ModTileEntities.FARMER, ModBlocks.FARMER.func_176223_P());
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        if (villager.func_213708_dV() <= 0 && !villager.func_213700_eh().func_221130_b().equals(VillagerProfession.field_221162_l)) {
            villager.func_213753_a(villager.func_213700_eh().func_221126_a(VillagerProfession.field_221156_f));
        }
    }

    public void setCrop(Item seed) {
        this.crop = seed == null ? null : this.getSeedCrop(seed);
        this.func_70296_d();
        this.sync();
    }

    public Block removeSeed() {
        if (this.crop == null) {
            return null;
        }
        Block s = this.crop.func_177230_c();
        this.setCrop(null);
        return s;
    }

    public boolean isValidSeed(Item seed) {
        return this.getSeedCrop(seed) != null;
    }

    public BlockState getSeedCrop(Item seed) {
        IPlantable plantable;
        if (seed == Items.field_151014_N) {
            return Blocks.field_150464_aj.func_176223_P();
        }
        if (seed == Items.field_151174_bG) {
            return Blocks.field_150469_bN.func_176223_P();
        }
        if (seed == Items.field_151172_bF) {
            return Blocks.field_150459_bM.func_176223_P();
        }
        if (seed == Items.field_185163_cU) {
            return Blocks.field_185773_cZ.func_176223_P();
        }
        if (seed instanceof IPlantable && (plantable = (IPlantable)seed).getPlantType((IBlockReader)this.field_145850_b, this.func_174877_v()) == PlantType.CROP) {
            return plantable.getPlant((IBlockReader)this.field_145850_b, this.func_174877_v());
        }
        return null;
    }

    @Nullable
    public BlockState getCrop() {
        return this.crop;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v != null) {
            VillagerBlockBase.playRandomVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187910_gj);
            if (this.advanceAge()) {
                this.sync();
            }
            this.func_70296_d();
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.field_145850_b.field_73012_v.nextInt((Integer)Main.SERVER_CONFIG.farmSpeed.get()) == 0 && this.ageCrop(v)) {
            this.sync();
            this.func_70296_d();
        }
    }

    private boolean ageCrop(@Nullable EasyVillagerEntity villager) {
        BlockState c = this.getCrop();
        if (c == null) {
            return false;
        }
        Optional<Property> ageProp = c.func_235904_r_().stream().filter(p -> p.func_177701_a().equals("age")).findFirst();
        if (!ageProp.isPresent() || !(ageProp.get() instanceof IntegerProperty)) {
            return false;
        }
        IntegerProperty p2 = (IntegerProperty)ageProp.get();
        Integer max = (Integer)p2.func_177700_c().stream().max(Integer::compare).get();
        int age = (Integer)c.func_177229_b((Property)p2);
        if (age >= max) {
            if (villager == null || villager.func_70631_g_() || !villager.func_213700_eh().func_221130_b().equals(VillagerProfession.field_221156_f)) {
                return false;
            }
            LootContext.Builder context = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p())).func_216015_a(LootParameters.field_216287_g, (Object)c).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a);
            List drops = c.func_215693_a(context);
            IItemHandlerModifiable itemHandler = this.getItemHandler();
            for (ItemStack stack : drops) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    stack = itemHandler.insertItem(i, stack, false);
                }
            }
            this.crop = (BlockState)this.crop.func_206870_a((Property)p2, (Comparable)Integer.valueOf(0));
            VillagerBlockBase.playVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_219698_mF);
            return true;
        }
        this.crop = (BlockState)this.crop.func_206870_a((Property)p2, (Comparable)Integer.valueOf(age + 1));
        return true;
    }

    public IInventory getOutputInventory() {
        return new ItemListInventory(this.inventory, () -> ((FarmerTileentity)this).func_70296_d());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.crop != null) {
            compound.func_218657_a("Crop", (INBT)NBTUtil.func_190009_a((BlockState)this.crop));
        }
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.inventory, (boolean)false);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("Crop")) {
            this.crop = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("Crop"));
        } else {
            this.removeSeed();
        }
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        super.func_230337_a_(state, compound);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(this::getItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        if (this.handler == null) {
            this.handler = new ItemStackHandler(this.inventory);
        }
        return this.handler;
    }
}

