/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ConverterTileentity
extends VillagerTileentity
implements ITickableTileEntity {
    private NonNullList<ItemStack> inputInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private NonNullList<ItemStack> outputInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private long timer;
    private UUID owner;
    private IItemHandlerModifiable foodInventoryHandler;
    private IItemHandlerModifiable outputInventoryHandler;

    public ConverterTileentity() {
        super(ModTileEntities.CONVERTER, ModBlocks.CONVERTER.func_176223_P());
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.timer <= 0L && !this.hasVillager()) {
            for (ItemStack stack : this.inputInventory) {
                if (!(stack.func_77973_b() instanceof VillagerItem) || !this.consumeConvertItems()) continue;
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                this.setVillager(copy);
                stack.func_190918_g(1);
                this.sync();
                break;
            }
        }
        if (this.hasVillager()) {
            PlayerEntity ownerPlayer;
            if (this.advanceAge()) {
                this.sync();
            }
            if (this.timer == (long)ConverterTileentity.getZombifyTime()) {
                VillagerBlockBase.playVillagerSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_187945_hs);
                this.sync();
            } else if (this.timer == (long)ConverterTileentity.getCureTime()) {
                VillagerBlockBase.playVillagerSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_187942_hp);
                this.sync();
            } else if (this.timer == (long)ConverterTileentity.getConvertTime()) {
                VillagerBlockBase.playVillagerSound(this.field_145850_b, this.field_174879_c, SoundEvents.field_187941_ho);
                this.sync();
            } else if (this.timer >= (long)ConverterTileentity.getFinalizeTime() && (ownerPlayer = this.getOwnerPlayer()) != null) {
                for (int i = 0; i < this.outputInventory.size(); ++i) {
                    ItemStack stack = (ItemStack)this.outputInventory.get(i);
                    if (!stack.func_190926_b()) continue;
                    EasyVillagerEntity villagerEntity = this.getVillagerEntity();
                    villagerEntity.func_213739_a(IReputationType.field_221029_a, (Entity)ownerPlayer);
                    this.outputInventory.set(i, (Object)this.removeVillager().func_77946_l());
                    this.timer = 0L;
                    this.sync();
                    break;
                }
            }
            ++this.timer;
            this.func_70296_d();
            if (this.timer < (long)ConverterTileentity.getZombifyTime() || this.timer >= (long)ConverterTileentity.getConvertTime()) {
                VillagerBlockBase.playRandomVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187910_gj);
            } else {
                VillagerBlockBase.playRandomVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187940_hn);
            }
            VillagerBlockBase.playRandomVillagerSound(this.field_145850_b, this.func_174877_v(), SoundEvents.field_187899_gZ);
        } else if (this.timer != 0L) {
            this.timer = 0L;
            this.func_70296_d();
        }
    }

    private boolean consumeConvertItems() {
        ItemStack appleStack = null;
        ItemStack potionStack = null;
        for (ItemStack stack : this.inputInventory) {
            if (appleStack == null && stack.func_77973_b() == Items.field_151153_ao) {
                appleStack = stack;
            }
            if (potionStack != null || !ConverterTileentity.isWeakness(stack)) continue;
            potionStack = stack;
        }
        if (appleStack != null && potionStack != null) {
            appleStack.func_190918_g(1);
            potionStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public static boolean isWeakness(ItemStack stack) {
        return PotionUtils.func_185191_c((ItemStack)stack).equals(Potions.field_185226_I);
    }

    public long getTimer() {
        return this.timer;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public PlayerEntity getOwnerPlayer() {
        if (this.owner == null) {
            return null;
        }
        if (this.field_145850_b instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
            return serverWorld.func_73046_m().func_184103_al().func_177451_a(this.owner);
        }
        return this.field_145850_b.func_217371_b(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("InputInventory", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.inputInventory, (boolean)true));
        compound.func_218657_a("OutputInventory", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.outputInventory, (boolean)true));
        compound.func_74772_a("Timer", this.timer);
        if (this.owner != null) {
            compound.func_186854_a("Owner", this.owner);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("InputInventory"), this.inputInventory);
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("OutputInventory"), this.outputInventory);
        this.timer = compound.func_74763_f("Timer");
        this.owner = compound.func_74764_b("Owner") ? compound.func_186857_a("Owner") : null;
        super.func_230337_a_(state, compound);
    }

    public IInventory getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((ConverterTileentity)this).func_70296_d());
    }

    public IInventory getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((ConverterTileentity)this).func_70296_d());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null && side.equals((Object)Direction.DOWN)) {
                return LazyOptional.of(this::getOutputInventoryItemHandler).cast();
            }
            return LazyOptional.of(this::getInputInventoryItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getInputInventoryItemHandler() {
        if (this.foodInventoryHandler == null) {
            this.foodInventoryHandler = new ItemStackHandler(this.inputInventory);
        }
        return this.foodInventoryHandler;
    }

    public IItemHandlerModifiable getOutputInventoryItemHandler() {
        if (this.outputInventoryHandler == null) {
            this.outputInventoryHandler = new ItemStackHandler(this.outputInventory);
        }
        return this.outputInventoryHandler;
    }

    public static int getZombifyTime() {
        return 60;
    }

    public static int getCureTime() {
        return ConverterTileentity.getZombifyTime() + 60;
    }

    public static int getConvertTime() {
        return ConverterTileentity.getCureTime() + (Integer)Main.SERVER_CONFIG.convertingTime.get();
    }

    public static int getFinalizeTime() {
        return ConverterTileentity.getConvertTime() + 60;
    }
}

