/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easy_villagers.corelib.block.IItemBlock;
import de.maxhenkel.easy_villagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.ModItemGroups;
import de.maxhenkel.easyvillagers.blocks.FarmerBlock;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.BreederTileentity;
import de.maxhenkel.easyvillagers.gui.BreederContainer;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import de.maxhenkel.easyvillagers.items.render.BreederItemRenderer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BreederBlock
extends VillagerBlockBase
implements ITileEntityProvider,
IItemBlock {
    public BreederBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.5f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.setRegistryName(new ResourceLocation("easy_villagers", "breeder"));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ModItemGroups.TAB_EASY_VILLAGERS).setISTER(() -> BreederItemRenderer::new)).setRegistryName(this.getRegistryName());
    }

    public ActionResultType func_225533_a_(final BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof BreederTileentity)) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        final BreederTileentity breeder = (BreederTileentity)tileEntity;
        if (!breeder.hasVillager1() && heldItem.func_77973_b() instanceof VillagerItem) {
            breeder.setVillager1(heldItem.func_77946_l());
            ItemUtils.decrItemStack(heldItem, player);
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_187915_go);
            return ActionResultType.SUCCESS;
        }
        if (!breeder.hasVillager2() && heldItem.func_77973_b() instanceof VillagerItem) {
            breeder.setVillager2(heldItem.func_77946_l());
            ItemUtils.decrItemStack(heldItem, player);
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_187915_go);
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && breeder.hasVillager2()) {
            ItemStack stack = breeder.removeVillager2();
            if (heldItem.func_190926_b()) {
                player.func_184611_a(handIn, stack);
            } else if (!player.field_71071_by.func_70441_a(stack)) {
                Direction direction = (Direction)state.func_177229_b((Property)FarmerBlock.FACING);
                InventoryHelper.func_180173_a((World)worldIn, (double)((double)(direction.func_82601_c() + pos.func_177958_n()) + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)(direction.func_82599_e() + pos.func_177952_p()) + 0.5), (ItemStack)stack);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_219721_mv);
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_() && breeder.hasVillager1()) {
            ItemStack stack = breeder.removeVillager1();
            if (heldItem.func_190926_b()) {
                player.func_184611_a(handIn, stack);
            } else if (!player.field_71071_by.func_70441_a(stack)) {
                Direction direction = (Direction)state.func_177229_b((Property)FarmerBlock.FACING);
                InventoryHelper.func_180173_a((World)worldIn, (double)((double)(direction.func_82601_c() + pos.func_177958_n()) + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)(direction.func_82599_e() + pos.func_177952_p()) + 0.5), (ItemStack)stack);
            }
            VillagerBlockBase.playVillagerSound(worldIn, pos, SoundEvents.field_219721_mv);
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a(new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent(state.func_177230_c().func_149739_a());
            }

            @Nullable
            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                return new BreederContainer(id, playerInventory, breeder.getFoodInventory(), breeder.getOutputInventory());
            }
        });
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new BreederTileentity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }
}

