/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears.common.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends FilterOutputStream {
    private int buffer = 0;
    private int index = 0;

    public BitOutputStream(OutputStream out) {
        super(out);
    }

    public void writeBit(int bit) throws IOException {
        this.buffer <<= 1;
        this.buffer |= bit & 1;
        ++this.index;
        if (this.index >= 8) {
            this.out.write(this.buffer);
            this.index = 0;
            this.buffer = 0;
        }
    }

    @Override
    @Deprecated
    public void write(int value) throws IOException {
        if (this.index == -1) {
            this.out.write(value);
        } else {
            for (int i = 7; i >= 0; --i) {
                this.writeBit(value >> i & 1);
            }
        }
    }

    public void write(boolean value) throws IOException {
        this.writeBit(value ? 1 : 0);
    }

    public void write(int bits, long value) throws IOException {
        if (bits < 1 || bits >= 64) {
            throw new IllegalArgumentException("bits(" + bits + ") is out of range");
        }
        long cur = Long.reverse(value) >> 64 - bits;
        for (int i = 0; i < bits; ++i) {
            this.writeBit((int)(cur & 1L));
            cur >>= 1;
        }
    }

    public void writeSAM(int bits, int value) throws IOException {
        this.write(value < 0);
        this.write(bits, Math.abs(value));
    }

    public void writeSAMUnit(int bits, float value) throws IOException {
        this.write(value < 0.0f);
        int max = (1 << bits) - 1;
        this.write(bits, (int)Math.abs(value * (float)max));
    }

    public void writeUnit(int bits, float value) throws IOException {
        int max = (1 << bits) - 1;
        this.write(bits, (int)Math.ceil(value * (float)max));
    }

    @Override
    public void write(byte[] value) throws IOException {
        if (this.index == 0) {
            this.out.write(value);
        } else {
            for (byte b : value) {
                this.write(b);
            }
        }
    }

    public void align() throws IOException {
        while (this.index != 0) {
            this.writeBit(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.align();
    }
}

