/*
 * Decompiled with CFR 0.152.
 */
package net.celeri.dynmus;

import dev.architectury.registry.registries.DeferredRegister;
import java.util.stream.IntStream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.celeri.dynmus.config.DynamicMusicConfig;
import net.celeri.dynmus.util.DynamicMusicHelper;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3562;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class DynamicMusic {
    public static final String MOD_ID = "dynmus";
    public static final class_3414 MUSIC_END_BOSS = class_3414.method_47908((class_2960)new class_2960("dynmus", "music.end.boss"));
    private static boolean inCave = false;
    private static boolean inPseudoMinecraft = false;
    private static double averageDarkness = 15.0;
    private static final class_6862<class_2248> caveBlocks = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("dynmus", "cave_blocks"));
    private static final class_6862<class_2248> mineshaftBlocks = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("dynmus", "mineshaft_blocks"));

    public static void init() {
        AutoConfig.register(DynamicMusicConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(GsonConfigSerializer::new));
        DeferredRegister SOUND_EVENTS_REGISTER = DeferredRegister.create((String)MOD_ID, (class_5321)class_7924.field_41225);
        for (class_3414 sound : DynamicMusicHelper.getMusics().values()) {
            SOUND_EVENTS_REGISTER.register(sound.method_14833().method_12832(), () -> sound);
        }
        SOUND_EVENTS_REGISTER.register(MUSIC_END_BOSS.method_14833().method_12832(), () -> MUSIC_END_BOSS);
        SOUND_EVENTS_REGISTER.register();
    }

    public static void tick(class_1937 level, class_2338 pos) {
        DynamicMusicConfig config = (DynamicMusicConfig)AutoConfig.getConfigHolder(DynamicMusicConfig.class).getConfig();
        class_3562 blockLightListener = level.method_22336().method_15562(class_1944.field_9282);
        int caveSearchRange = config.generalConfig.caveDetection.searchRange;
        int mineshaftSearchRange = config.generalConfig.mineshaftDetection.searchRange;
        int searchRange = Math.max(caveSearchRange, mineshaftSearchRange);
        if (searchRange >= 1) {
            int airBlocks = 0;
            int lightSum = 0;
            int caveAllSolidBlocks = 0;
            int caveBlocks = 0;
            int mineshaftAllSolidBlock = 0;
            int mineshaftBlocks = 0;
            for (int x = -searchRange; x < searchRange; ++x) {
                for (int y = -searchRange; y < searchRange; ++y) {
                    for (int z = -searchRange; z < searchRange; ++z) {
                        class_2338 offsetPos = new class_2338((class_2382)pos).method_10069(x, y, z);
                        class_2680 blockState = level.method_8320(offsetPos);
                        if (blockState.method_26215()) {
                            ++airBlocks;
                            lightSum += blockLightListener.method_15543(offsetPos);
                            continue;
                        }
                        if (blockState.method_27852(class_2246.field_10164) || blockState.method_27852(class_2246.field_10382)) continue;
                        int biggestCoordinate = IntStream.of(x, y, z).max().getAsInt();
                        int smallestCoordinate = IntStream.of(x, y, z).min().getAsInt();
                        if (smallestCoordinate > -caveSearchRange && biggestCoordinate < caveSearchRange) {
                            ++caveAllSolidBlocks;
                            if (DynamicMusic.isCaveBlock(blockState)) {
                                ++caveBlocks;
                            }
                        }
                        if (smallestCoordinate <= -mineshaftSearchRange || biggestCoordinate >= mineshaftSearchRange) continue;
                        ++mineshaftAllSolidBlock;
                        if (!DynamicMusic.isMineshaftBlock(blockState)) continue;
                        ++mineshaftBlocks;
                    }
                }
            }
            inCave = !level.method_8311(pos) && config.generalConfig.caveDetection.stonePercent <= (double)caveBlocks / (double)caveAllSolidBlocks;
            inPseudoMinecraft = inCave && config.generalConfig.mineshaftDetection.percent <= (double)mineshaftBlocks / (double)mineshaftAllSolidBlock;
            averageDarkness = (double)lightSum / (double)airBlocks;
        }
    }

    private static boolean isCaveBlock(class_2680 blockState) {
        return blockState.method_40144().anyMatch(tag -> tag == caveBlocks);
    }

    private static boolean isMineshaftBlock(class_2680 blockState) {
        return blockState.method_40144().anyMatch(tag -> tag == mineshaftBlocks);
    }

    public static boolean isInCave() {
        return inCave;
    }

    public static boolean isInPseudoMinecraft() {
        return inPseudoMinecraft;
    }

    public static double getAverageDarkness() {
        return averageDarkness;
    }
}

