/*
 * Decompiled with CFR 0.152.
 */
package dynamicfps.util;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class ScreenOptimizationCompat {
    private static Set<String> optedInScreens = new HashSet<String>();
    private static Set<String> optedOutScreens = new HashSet<String>();

    public static boolean isOptedIn(String className) {
        return optedInScreens.contains(className);
    }

    public static boolean isOptedOut(String className) {
        return optedOutScreens.contains(className);
    }

    private static void parseModMetadata(ModContainer mod) {
        CustomValue.CvObject optimizedScreens;
        ModMetadata data = mod.getMetadata();
        try {
            CustomValue.CvObject root = data.getCustomValue("dynamic_fps").getAsObject();
            optimizedScreens = root.get("optimized_screens").getAsObject();
        }
        catch (ClassCastException | NullPointerException e) {
            return;
        }
        MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
        ScreenOptimizationCompat.addToSet(resolver, optimizedScreens.get("enabled"), optedInScreens);
        ScreenOptimizationCompat.addToSet(resolver, optimizedScreens.get("disabled"), optedOutScreens);
    }

    private static void addToSet(MappingResolver resolver, @Nullable CustomValue values, Set<String> set) {
        if (values == null || values.getType() != CustomValue.CvType.ARRAY) {
            return;
        }
        values.getAsArray().forEach(value -> {
            if (value.getType() == CustomValue.CvType.STRING) {
                set.add(resolver.mapClassName("intermediary", value.getAsString()));
            }
        });
    }

    static {
        FabricLoader.getInstance().getAllMods().forEach(ScreenOptimizationCompat::parseModMetadata);
    }
}

