/*
 * Decompiled with CFR 0.152.
 */
package dynamicfps;

import dynamicfps.DynamicFPSConfig;
import dynamicfps.FlawlessFrames;
import dynamicfps.HudInfoRenderer;
import dynamicfps.util.KeyBindingHandler;
import dynamicfps.util.Localization;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.Nullable;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import org.lwjgl.glfw.GLFW;

public class DynamicFPSMod
implements ModInitializer {
    public static final String MOD_ID = "dynamicfps";
    public static DynamicFPSConfig config = null;
    private static boolean isDisabled = false;
    private static boolean isForcingLowFPS = false;
    private static final KeyBindingHandler toggleForcedKeyBinding = new KeyBindingHandler(Localization.translationKey("key", "toggle_forced"), "key.categories.misc", () -> {
        isForcingLowFPS = !isForcingLowFPS;
    });
    private static final KeyBindingHandler toggleDisabledKeyBinding = new KeyBindingHandler(Localization.translationKey("key", "toggle_disabled"), "key.categories.misc", () -> {
        isDisabled = !isDisabled;
    });
    private static class_310 client;
    private static class_1041 window;
    private static boolean isFocused;
    private static boolean isVisible;
    private static boolean isHovered;
    private static long lastRender;
    private static boolean wasFocused;
    private static boolean wasVisible;
    private static boolean hasRenderedLastFrame;

    public static boolean isDisabled() {
        return isDisabled;
    }

    public static boolean isForcingLowFPS() {
        return isForcingLowFPS;
    }

    public void onInitialize() {
        config = DynamicFPSConfig.load();
        toggleForcedKeyBinding.register();
        toggleDisabledKeyBinding.register();
        HudRenderCallback.EVENT.register((Object)new HudInfoRenderer());
        FlawlessFrames.onClientInitialization();
    }

    public static boolean checkForRender() {
        if (isDisabled || FlawlessFrames.isActive()) {
            return true;
        }
        if (client == null) {
            client = class_310.method_1551();
            window = client.method_22683();
        }
        isFocused = client.method_1569();
        isVisible = GLFW.glfwGetWindowAttrib((long)window.method_4490(), (int)131076) != 0;
        isHovered = GLFW.glfwGetWindowAttrib((long)window.method_4490(), (int)131083) != 0;
        DynamicFPSMod.checkForStateChanges();
        long currentTime = class_156.method_658();
        long timeSinceLastRender = currentTime - lastRender;
        if (!DynamicFPSMod.checkForRender(timeSinceLastRender)) {
            return false;
        }
        lastRender = currentTime;
        return true;
    }

    public static boolean shouldShowToasts() {
        return isDisabled || FlawlessFrames.isActive() || DynamicFPSMod.fpsOverride() == null;
    }

    private static void checkForStateChanges() {
        if (isFocused != wasFocused) {
            wasFocused = isFocused;
            if (isFocused) {
                DynamicFPSMod.onFocus();
            } else {
                DynamicFPSMod.onUnfocus();
            }
        }
        if (isVisible != wasVisible) {
            wasVisible = isVisible;
            if (isVisible) {
                DynamicFPSMod.onAppear();
            } else {
                DynamicFPSMod.onDisappear();
            }
        }
    }

    private static void onFocus() {
        DynamicFPSMod.setVolumeMultiplier(1.0f);
    }

    private static void onUnfocus() {
        if (isVisible) {
            DynamicFPSMod.setVolumeMultiplier(DynamicFPSMod.config.unfocusedVolumeMultiplier);
        }
        if (DynamicFPSMod.config.runGCOnUnfocus) {
            System.gc();
        }
    }

    private static void onAppear() {
        if (!isFocused) {
            DynamicFPSMod.setVolumeMultiplier(DynamicFPSMod.config.unfocusedVolumeMultiplier);
        }
    }

    private static void onDisappear() {
        DynamicFPSMod.setVolumeMultiplier(DynamicFPSMod.config.hiddenVolumeMultiplier);
    }

    private static void setVolumeMultiplier(float multiplier) {
        boolean clientWillPause;
        boolean bl = clientWillPause = !isFocused && DynamicFPSMod.client.field_1690.field_1837 && DynamicFPSMod.client.field_1755 == null;
        if (multiplier == 0.0f && clientWillPause) {
            return;
        }
        float baseVolume = DynamicFPSMod.client.field_1690.method_1630(class_3419.field_15250);
        client.method_1483().method_4865(class_3419.field_15250, baseVolume * multiplier);
    }

    private static boolean checkForRender(long timeSinceLastRender) {
        boolean shouldSkipRender;
        Integer fpsOverride = DynamicFPSMod.fpsOverride();
        if (fpsOverride == null) {
            hasRenderedLastFrame = false;
            return true;
        }
        if (!hasRenderedLastFrame) {
            hasRenderedLastFrame = true;
            return true;
        }
        if (fpsOverride == 0) {
            DynamicFPSMod.idle(1000L);
            return false;
        }
        long frameTime = 1000 / fpsOverride;
        boolean bl = shouldSkipRender = timeSinceLastRender < frameTime;
        if (!shouldSkipRender) {
            return true;
        }
        DynamicFPSMod.idle(frameTime);
        return false;
    }

    private static void idle(long waitMillis) {
        waitMillis = Math.min(waitMillis, 30L);
        LockSupport.parkNanos("waiting to render", waitMillis * 1000000L);
    }

    @Nullable
    private static Integer fpsOverride() {
        if (!isVisible) {
            return 0;
        }
        if (isForcingLowFPS) {
            return DynamicFPSMod.config.unfocusedFPS;
        }
        if (DynamicFPSMod.config.restoreFPSWhenHovered && isHovered) {
            return null;
        }
        if (DynamicFPSMod.config.reduceFPSWhenUnfocused && !client.method_1569()) {
            return DynamicFPSMod.config.unfocusedFPS;
        }
        return null;
    }

    static {
        wasFocused = true;
        wasVisible = true;
        hasRenderedLastFrame = false;
    }
}

