/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.client.gui;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import de.guntram.mcmod.durabilityviewer.handler.ConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.itemindicator.ColytraDamageIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.InventorySlotsIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemCountIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemDamageIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.TREnergyIndicator;
import de.guntram.mcmod.durabilityviewer.sound.ColytraBreakingWarner;
import de.guntram.mcmod.durabilityviewer.sound.ItemBreakingWarner;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1041;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.reborn.energy.EnergyHolder;

public class GuiItemDurability {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_310 minecraft = class_310.method_1551();
    private static boolean visible;
    private final class_327 fontRenderer;
    private final class_918 itemRenderer;
    private long lastWarningTime;
    private class_1799 lastWarningItem;
    private static final int iconWidth = 16;
    private static final int iconHeight = 16;
    private static final int spacing = 2;
    private static boolean haveTrinketsApi;
    private static boolean haveTRCore;
    private ItemBreakingWarner mainHandWarner;
    private ItemBreakingWarner offHandWarner;
    private ItemBreakingWarner helmetWarner;
    private ItemBreakingWarner chestWarner;
    private ItemBreakingWarner pantsWarner;
    private ItemBreakingWarner bootsWarner;
    private ItemBreakingWarner colytraWarner;
    private ItemBreakingWarner[] trinketWarners;

    public static void toggleVisibility() {
        visible = !visible;
    }

    public GuiItemDurability() {
        this.fontRenderer = this.minecraft.field_1772;
        this.itemRenderer = this.minecraft.method_1480();
        visible = true;
        this.mainHandWarner = new ItemBreakingWarner();
        this.offHandWarner = new ItemBreakingWarner();
        this.helmetWarner = new ItemBreakingWarner();
        this.chestWarner = new ItemBreakingWarner();
        this.pantsWarner = new ItemBreakingWarner();
        this.bootsWarner = new ItemBreakingWarner();
        this.colytraWarner = new ColytraBreakingWarner();
        try {
            Class.forName("dev.emi.trinkets.api.TrinketsApi");
            LOGGER.info("Using trinkets in DurabilityViewer");
            int slotCount = this.getTrinketSlotCount((class_1309)this.minecraft.field_1724);
            haveTrinketsApi = slotCount > 0;
            this.trinketWarners = new ItemBreakingWarner[slotCount];
            for (int i = 0; i < this.trinketWarners.length; ++i) {
                this.trinketWarners[i] = new ItemBreakingWarner();
            }
        }
        catch (ClassNotFoundException ex) {
            LOGGER.info("DurabilityViewer did not find Trinkets API");
            this.trinketWarners = new ItemBreakingWarner[0];
        }
        try {
            Class.forName("team.reborn.energy.EnergyHolder");
            haveTRCore = true;
        }
        catch (ClassNotFoundException ex) {
            LOGGER.info("DurabilityViewer did not find Tech Reborn");
        }
    }

    private int getInventoryArrowCount() {
        int arrows = 0;
        for (class_1799 stack : this.minecraft.field_1724.method_31548().field_7547) {
            if (!this.isArrow(stack)) continue;
            arrows += stack.method_7947();
        }
        return arrows;
    }

    private class_1799 getFirstArrowStack() {
        if (this.isArrow(this.minecraft.field_1724.method_6079())) {
            return this.minecraft.field_1724.method_6079();
        }
        if (this.isArrow(this.minecraft.field_1724.method_6047())) {
            return this.minecraft.field_1724.method_6047();
        }
        int size = this.minecraft.field_1724.method_31548().method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 itemstack = this.minecraft.field_1724.method_31548().method_5438(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrow(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() instanceof class_1744;
    }

    public void onRenderGameOverlayPost(class_332 context, float partialTicks) {
        int ypos;
        int xposTrinkets;
        int xposTools;
        int xposArmor;
        int totalHeight;
        long timeSinceLastWarning;
        InventorySlotsIndicator invSlots;
        class_746 player = this.minecraft.field_1724;
        class_1799 needToWarn = null;
        ItemIndicator mainHand = this.damageOrEnergy((class_1657)player, class_1304.field_6173);
        ItemIndicator offHand = this.damageOrEnergy((class_1657)player, class_1304.field_6171);
        class_1799 chestItem = player.method_6118(class_1304.field_6174);
        ColytraDamageIndicator colytra = null;
        if (chestItem != null && chestItem.method_7969() != null && chestItem.method_7969().method_10545("colytra:ElytraUpgrade")) {
            colytra = new ColytraDamageIndicator(chestItem);
        }
        ItemDamageIndicator boots = new ItemDamageIndicator(player.method_6118(class_1304.field_6166));
        ItemDamageIndicator leggings = new ItemDamageIndicator(player.method_6118(class_1304.field_6172));
        ItemDamageIndicator chestplate = new ItemDamageIndicator(chestItem);
        ItemDamageIndicator helmet = new ItemDamageIndicator(player.method_6118(class_1304.field_6169));
        ItemCountIndicator arrows = null;
        InventorySlotsIndicator inventorySlotsIndicator = invSlots = ConfigurationHandler.getShowChestIcon() ? new InventorySlotsIndicator(this.minecraft.field_1724.method_31548()) : null;
        if (needToWarn == null && this.mainHandWarner.checkBreaks(player.method_6118(class_1304.field_6173))) {
            needToWarn = player.method_6118(class_1304.field_6173);
        }
        if (needToWarn == null && this.offHandWarner.checkBreaks(player.method_6118(class_1304.field_6171))) {
            needToWarn = player.method_6118(class_1304.field_6171);
        }
        if (needToWarn == null && this.bootsWarner.checkBreaks(player.method_6118(class_1304.field_6166))) {
            needToWarn = player.method_6118(class_1304.field_6166);
        }
        if (needToWarn == null && this.pantsWarner.checkBreaks(player.method_6118(class_1304.field_6172))) {
            needToWarn = player.method_6118(class_1304.field_6172);
        }
        if (needToWarn == null && this.chestWarner.checkBreaks(chestItem)) {
            needToWarn = chestItem;
        }
        if (needToWarn == null && this.helmetWarner.checkBreaks(player.method_6118(class_1304.field_6169))) {
            needToWarn = player.method_6118(class_1304.field_6169);
        }
        if (needToWarn == null && this.colytraWarner.checkBreaks(chestItem)) {
            needToWarn = chestItem;
        }
        ItemIndicator[] trinkets = null;
        if (haveTrinketsApi) {
            int i;
            List<class_1799> equipped = this.getTrinkets((class_1309)player);
            trinkets = new ItemIndicator[equipped.size()];
            if (trinkets.length > this.trinketWarners.length) {
                this.trinketWarners = new ItemBreakingWarner[trinkets.length];
                for (i = 0; i < this.trinketWarners.length; ++i) {
                    this.trinketWarners[i] = new ItemBreakingWarner();
                }
            }
            LOGGER.debug("know about " + trinkets.length + " trinkets, invSize is " + equipped.size() + ", have " + this.trinketWarners.length + " warners");
            for (i = 0; i < trinkets.length; ++i) {
                trinkets[i] = new ItemDamageIndicator(equipped.get(i), ConfigurationHandler.getShowAllTrinkets());
                if (needToWarn == null && this.trinketWarners[i].checkBreaks(equipped.get(i))) {
                    needToWarn = equipped.get(i);
                }
                LOGGER.debug("trinket position " + i + " has item " + equipped.get(i).method_7909().toString());
            }
        } else {
            trinkets = new ItemIndicator[]{};
        }
        if (needToWarn != null) {
            if ((ConfigurationHandler.getWarnMode() & 1) == 1) {
                ItemBreakingWarner.playWarningSound();
            }
            this.lastWarningTime = System.currentTimeMillis();
            this.lastWarningItem = needToWarn;
        }
        if ((timeSinceLastWarning = System.currentTimeMillis() - this.lastWarningTime) < 1000L && (ConfigurationHandler.getWarnMode() & 2) == 2) {
            this.renderItemBreakingOverlay(context, this.lastWarningItem, timeSinceLastWarning);
        }
        if (!visible || this.minecraft.field_1690.field_1866) {
            return;
        }
        if (mainHand.getItemStack().method_7909() instanceof class_1811 || offHand.getItemStack().method_7909() instanceof class_1811) {
            arrows = new ItemCountIndicator(this.getFirstArrowStack(), this.getInventoryArrowCount());
        }
        class_1041 mainWindow = class_310.method_1551().method_22683();
        RenderSize armorSize = ConfigurationHandler.getArmorAroundHotbar() ? new RenderSize(0, 0) : this.renderItems(context, 0, 0, false, RenderPos.left, 0, boots, leggings, colytra, chestplate, helmet);
        RenderSize toolsSize = this.renderItems(context, 0, 0, false, RenderPos.right, 0, invSlots, mainHand, offHand, arrows);
        RenderSize trinketsSize = this.renderItems(context, 0, 0, false, RenderPos.left, 0, trinkets);
        int n = totalHeight = toolsSize.height > armorSize.height ? toolsSize.height : armorSize.height;
        if (trinketsSize.height > totalHeight) {
            totalHeight = trinketsSize.height;
        }
        if (trinketsSize.width == 0 && trinkets.length > 0 && ConfigurationHandler.getShowAllTrinkets()) {
            trinketsSize.width = 20;
        }
        switch (ConfigurationHandler.getCorner()) {
            case TOP_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                xposTrinkets = 5 + armorSize.width + trinketsSize.width;
                ypos = 5;
                break;
            }
            case TOP_RIGHT: {
                xposArmor = mainWindow.method_4486() - 5 - armorSize.width;
                xposTools = xposArmor - toolsSize.width;
                xposTrinkets = xposTools - trinketsSize.width;
                ypos = 60;
                break;
            }
            case BOTTOM_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                xposTrinkets = 5 + armorSize.width + trinketsSize.width;
                ypos = mainWindow.method_4502() - 5 - totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                xposArmor = mainWindow.method_4486() - 5 - armorSize.width;
                xposTools = mainWindow.method_4486() - 5 - armorSize.width - toolsSize.width;
                xposTrinkets = xposTools - trinketsSize.width;
                ypos = mainWindow.method_4502() - 5 - totalHeight;
                break;
            }
            default: {
                return;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (ConfigurationHandler.getArmorAroundHotbar()) {
            int leftOffset = -120;
            int rightOffset = 100;
            if (!player.method_6118(class_1304.field_6171).method_7960()) {
                if (this.minecraft.field_1690.method_42552().method_41753() == class_1306.field_6183) {
                    leftOffset -= 20;
                } else {
                    rightOffset += 20;
                }
            }
            int helmetTextWidth = this.fontRenderer.method_1727(helmet.getDisplayValue());
            int chestTextWidth = this.fontRenderer.method_1727(chestplate.getDisplayValue());
            this.renderItems(context, mainWindow.method_4486() / 2 + leftOffset - helmetTextWidth, mainWindow.method_4502() - 32 - 2, true, RenderPos.left, helmetTextWidth + 16 + 2, helmet);
            this.renderItems(context, mainWindow.method_4486() / 2 + leftOffset - chestTextWidth, mainWindow.method_4502() - 16 - 2, true, RenderPos.left, chestTextWidth + 16 + 2, chestplate);
            if (colytra != null) {
                int colytraTextWidth = this.fontRenderer.method_1727(colytra.getDisplayValue());
                this.renderItems(context, mainWindow.method_4486() / 2 + leftOffset - chestTextWidth - colytraTextWidth - 16, mainWindow.method_4502() - 16 - 2, true, RenderPos.left, colytraTextWidth + 16 + 2, colytra);
            }
            this.renderItems(context, mainWindow.method_4486() / 2 + rightOffset, mainWindow.method_4502() - 32 - 2, true, RenderPos.right, armorSize.width, leggings);
            this.renderItems(context, mainWindow.method_4486() / 2 + rightOffset, mainWindow.method_4502() - 16 - 2, true, RenderPos.right, armorSize.width, boots);
            xposTools = ConfigurationHandler.getCorner().isRight() ? (xposTools += armorSize.width) : (xposTools -= armorSize.width);
        } else {
            this.renderItems(context, xposArmor, ypos, true, ConfigurationHandler.getCorner().isLeft() ? RenderPos.left : RenderPos.right, armorSize.width, helmet, chestplate, colytra, leggings, boots);
        }
        this.renderItems(context, xposTools, ypos, true, ConfigurationHandler.getCorner().isRight() ? RenderPos.right : RenderPos.left, toolsSize.width, invSlots, mainHand, offHand, arrows);
        this.renderItems(context, xposTrinkets, ypos, true, ConfigurationHandler.getCorner().isRight() ? RenderPos.right : RenderPos.left, trinketsSize.width, trinkets);
    }

    private ItemIndicator damageOrEnergy(class_1657 player, class_1304 slot) {
        class_1799 stack = player.method_6118(slot);
        if (stack.method_7963()) {
            return new ItemDamageIndicator(stack);
        }
        if (haveTRCore && stack.method_7909() instanceof EnergyHolder && stack.method_7969() != null && stack.method_7969().method_10573("energy", 6)) {
            return new TREnergyIndicator(stack);
        }
        return new ItemDamageIndicator(stack);
    }

    private void renderItemBreakingOverlay(class_332 context, class_1799 itemStack, long timeDelta) {
        class_1041 mainWindow = class_310.method_1551().method_22683();
        float alpha = 1.0f - (float)timeDelta / 1000.0f;
        float xWarn = mainWindow.method_4486() / 2;
        float yWarn = mainWindow.method_4502() / 2;
        float scale = 5.0f;
        context.method_25294(0, 0, mainWindow.method_4486(), mainWindow.method_4502(), 0xFF0000 + ((int)(alpha * 128.0f) << 24));
        class_4587 stack = RenderSystem.getModelViewStack();
        stack.method_22903();
        stack.method_22905(scale, scale, scale);
        RenderSystem.applyModelViewMatrix();
        context.method_51427(itemStack, (int)(xWarn / scale - 8.0f), (int)(yWarn / scale - 8.0f));
        stack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void afterRenderStatusEffects(class_332 context, float partialTicks) {
        if (ConfigurationHandler.showEffectDuration()) {
            class_1041 mainWindow = class_310.method_1551().method_22683();
            Collection collection = this.minecraft.field_1724.method_6026();
            int posGood = 0;
            int posBad = 0;
            for (class_1293 potioneffect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                int ypos;
                if (!potioneffect.method_5592()) continue;
                class_1291 potion = potioneffect.method_5579();
                int xpos = mainWindow.method_4486();
                if (potion.method_5573()) {
                    xpos -= (posGood += 25);
                    ypos = 15;
                } else {
                    xpos -= (posBad += 25);
                    ypos = 41;
                }
                int duration = potioneffect.method_5584();
                String show = duration > 1200 ? duration / 1200 + "m" : duration / 20 + "s";
                context.method_25303(this.fontRenderer, show, xpos + 2, ypos, ItemIndicator.color_yellow);
            }
        }
    }

    private RenderSize renderItems(class_332 context, int xpos, int ypos, boolean reallyDraw, RenderPos numberPos, int maxWidth, ItemIndicator ... items) {
        RenderSize result = new RenderSize(0, 0);
        for (ItemIndicator item : items) {
            if (item == null || item.isEmpty() || !item.isItemStackDamageable()) continue;
            String displayString = item.getDisplayValue();
            int width = this.fontRenderer.method_1727(displayString);
            if (width > result.width) {
                result.width = width;
            }
            if (reallyDraw) {
                int color = item.getDisplayColor();
                context.method_51427(item.getItemStack(), numberPos == RenderPos.left ? xpos + maxWidth - 16 - 2 : xpos, ypos + result.height);
                int n = numberPos != RenderPos.right ? xpos : xpos + 16 + 2;
                int n2 = ypos + result.height;
                Objects.requireNonNull(this.fontRenderer);
                context.method_25303(this.fontRenderer, displayString, n, n2 + 9 / 2 + (numberPos == RenderPos.over ? 10 : 0), color);
            }
            result.height += 16;
        }
        if (result.width != 0) {
            result.width += 20;
        }
        return result;
    }

    public int getTrinketSlotCount(class_1309 player) {
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return 0;
        }
        return ((TrinketComponent)component.get()).getEquipped(prdct -> true).size();
    }

    public List<class_1799> getTrinkets(class_1309 player) {
        Optional component = TrinketsApi.getTrinketComponent((class_1309)player);
        if (component.isEmpty()) {
            return null;
        }
        return ((TrinketComponent)component.get()).getEquipped(prdct -> true).stream().map(pair -> (class_1799)pair.method_15441()).toList();
    }

    static {
        haveTrinketsApi = false;
        haveTRCore = false;
    }

    private class RenderSize {
        int width;
        int height;

        RenderSize(int w, int h) {
            this.width = w;
            this.height = h;
        }
    }

    private static enum RenderPos {
        left,
        over,
        right;

    }
}

