/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.ModList;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;

public class JSONUtils {
    public static boolean areRequirementsMet(JsonObject object) {
        if (object.has("requirements")) {
            JsonArray present;
            JsonObject conditions = object.getAsJsonObject("requirements");
            if (conditions.has("present")) {
                present = conditions.getAsJsonArray("present");
                for (JsonElement mod : present) {
                    if (ModList.get().isLoaded(mod.getAsString())) continue;
                    return false;
                }
            }
            if (conditions.has("absent")) {
                present = conditions.getAsJsonArray("absent");
                for (JsonElement mod : present) {
                    if (!ModList.get().isLoaded(mod.getAsString())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockState deserializeBlockStateProperties(Block block, JsonObject element) {
        BlockState state = block.func_176223_P();
        if (element.has("properties")) {
            JsonObject data = element.get("properties").getAsJsonObject();
            for (Property property : state.func_235904_r_()) {
                if (!data.has(property.func_177701_a())) continue;
                state = JSONUtils.parseProperty(state, property, data.get(property.func_177701_a()).getAsString());
            }
        }
        return state;
    }

    public static int getWeight(JsonObject object) {
        return object.has("weight") ? object.get("weight").getAsInt() : 1;
    }

    public static Vector3i getOffset(JsonObject jsonObject) {
        int x = 0;
        int y = 0;
        int z = 0;
        if (jsonObject.has("x")) {
            x = jsonObject.get("x").getAsInt();
        }
        if (jsonObject.has("y")) {
            y = jsonObject.get("y").getAsInt();
        }
        if (jsonObject.has("z")) {
            z = jsonObject.get("z").getAsInt();
        }
        if (x == 0 && y == 0 && z == 0) {
            return DungeonModels.NO_OFFSET;
        }
        return new Vector3i(x, y, z);
    }

    private static <T extends Comparable<T>> BlockState parseProperty(BlockState state, Property<T> property, String value) {
        Optional optional = property.func_185929_b(value);
        if (optional.isPresent()) {
            Comparable t = (Comparable)optional.get();
            return (BlockState)state.func_206870_a(property, t);
        }
        DungeonCrawl.LOGGER.warn("Couldn't apply property {} with value {} to {}", (Object)property.func_177701_a(), (Object)value, (Object)state.func_177230_c().getRegistryName());
        return state;
    }

    public static JsonObject serializeBlockState(JsonObject object, BlockState state) {
        Block block = state.func_177230_c();
        if (block.getRegistryName() == null) {
            DungeonCrawl.LOGGER.error("No registry name found for block {} ({})", (Object)block, block.getClass());
            return new JsonObject();
        }
        object.addProperty("block", block.getRegistryName().toString());
        BlockState defaultState = block.func_176223_P();
        JsonObject properties = new JsonObject();
        state.func_235904_r_().forEach(property -> {
            if (!state.func_177229_b(property).equals(defaultState.func_177229_b(property))) {
                properties.addProperty(property.func_177701_a(), state.func_177229_b(property).toString());
            }
        });
        if (properties.size() > 0) {
            object.add("properties", (JsonElement)properties);
        }
        return object;
    }
}

