/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.block.provider.SingleBlock;
import xiroc.dungeoncrawl.theme.Theme;

public class SecondaryTheme {
    public final BlockStateProvider pillar;
    public final BlockStateProvider trapDoor;
    public final BlockStateProvider door;
    public final BlockStateProvider material;
    public final BlockStateProvider stairs;
    public final BlockStateProvider slab;
    public final BlockStateProvider fence;
    public final BlockStateProvider fenceGate;
    public final BlockStateProvider button;
    public final BlockStateProvider pressurePlate;
    protected ResourceLocation key;
    @Nullable
    protected Integer id;

    public SecondaryTheme(BlockStateProvider pillar, BlockStateProvider trapDoor, BlockStateProvider door, BlockStateProvider material, BlockStateProvider stairs, BlockStateProvider slab, BlockStateProvider fence, BlockStateProvider fenceGate, BlockStateProvider button, BlockStateProvider pressurePlate) {
        this.pillar = pillar;
        this.trapDoor = trapDoor;
        this.door = door;
        this.material = material;
        this.stairs = stairs;
        this.slab = slab;
        this.fence = fence;
        this.fenceGate = fenceGate;
        this.button = button;
        this.pressurePlate = pressurePlate;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public BlockStateProvider getPillar() {
        return this.pillar;
    }

    public BlockStateProvider getTrapDoor() {
        return this.trapDoor;
    }

    public BlockStateProvider getDoor() {
        return this.door;
    }

    public BlockStateProvider getMaterial() {
        return this.material;
    }

    public BlockStateProvider getStairs() {
        return this.stairs;
    }

    public BlockStateProvider getSlab() {
        return this.slab;
    }

    public BlockStateProvider getFence() {
        return this.fence;
    }

    public BlockStateProvider getFenceGate() {
        return this.fenceGate;
    }

    public BlockStateProvider getButton() {
        return this.button;
    }

    public BlockStateProvider getPressurePlate() {
        return this.pressurePlate;
    }

    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        JsonObject theme = new JsonObject();
        theme.add("button", (JsonElement)this.button.serialize());
        theme.add("door", (JsonElement)this.door.serialize());
        theme.add("fence", (JsonElement)this.fence.serialize());
        theme.add("fence_gate", (JsonElement)this.fenceGate.serialize());
        theme.add("material", (JsonElement)this.material.serialize());
        theme.add("pillar", (JsonElement)this.pillar.serialize());
        theme.add("pressure_plate", (JsonElement)this.pressurePlate.serialize());
        theme.add("slab", (JsonElement)this.slab.serialize());
        theme.add("stairs", (JsonElement)this.stairs.serialize());
        theme.add("trapdoor", (JsonElement)this.trapDoor.serialize());
        object.add("theme", (JsonElement)theme);
        return object;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BlockStateProvider button = SingleBlock.AIR;
        private BlockStateProvider door = SingleBlock.AIR;
        private BlockStateProvider fence = SingleBlock.AIR;
        private BlockStateProvider fenceGate = SingleBlock.AIR;
        private BlockStateProvider material = SingleBlock.AIR;
        private BlockStateProvider pillar = SingleBlock.AIR;
        private BlockStateProvider pressurePlate = SingleBlock.AIR;
        private BlockStateProvider slab = SingleBlock.AIR;
        private BlockStateProvider stairs = SingleBlock.AIR;
        private BlockStateProvider trapdoor = SingleBlock.AIR;
        private Integer id;

        public Builder legacyId(int id) {
            this.id = id;
            return this;
        }

        public Builder button(BlockStateProvider provider) {
            this.button = provider;
            return this;
        }

        public Builder door(BlockStateProvider provider) {
            this.door = provider;
            return this;
        }

        public Builder fence(BlockStateProvider provider) {
            this.fence = provider;
            return this;
        }

        public Builder fenceGate(BlockStateProvider provider) {
            this.fenceGate = provider;
            return this;
        }

        public Builder material(BlockStateProvider provider) {
            this.material = provider;
            return this;
        }

        public Builder pillar(BlockStateProvider provider) {
            this.pillar = provider;
            return this;
        }

        public Builder pressurePlate(BlockStateProvider provider) {
            this.pressurePlate = provider;
            return this;
        }

        public Builder slab(BlockStateProvider provider) {
            this.slab = provider;
            return this;
        }

        public Builder stairs(BlockStateProvider provider) {
            this.stairs = provider;
            return this;
        }

        public Builder trapdoor(BlockStateProvider provider) {
            this.trapdoor = provider;
            return this;
        }

        public SecondaryTheme build() {
            SecondaryTheme secondaryTheme = new SecondaryTheme(this.pillar, this.trapdoor, this.door, this.material, this.stairs, this.slab, this.fence, this.fenceGate, this.button, this.pressurePlate);
            if (this.id != null) {
                Theme.ID_TO_SECONDARY_THEME.put(this.id, secondaryTheme);
            }
            return secondaryTheme;
        }
    }
}

