/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.nbt.INBT;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.misc.Banner;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureItem;
import xiroc.dungeoncrawl.dungeon.treasure.WeightedRandomTreasureItem;

public class RandomItems {
    public static final int COLOR = 3847130;
    public static final ItemStack[] ITEMS;
    public static final ItemStack[] RARE_ITEMS;
    public static final ItemStack REINFORCED_BOW;
    public static final ItemStack BOOTS_OF_BATTLE;
    public static final ItemStack PANTS_OF_DEFLECTION;
    public static final ItemStack LUMBERJACKET;
    public static final ItemStack YOKEL_AXE;
    public static final ItemStack DOOM;
    public static final ItemStack THE_SLAYER;
    public static final ItemStack DEMON_HUNTER_CROSSBOW;
    public static final ItemStack THIEF_DAGGER;
    public static final ItemStack THE_GREAT_CLEAVER;
    public static final ItemStack ARCHANGEL_SWORD;
    public static final ItemStack REPULSER;
    public static final ItemStack ELB_BOW;
    public static WeightedRandomTreasureItem STAGE_1;
    public static WeightedRandomTreasureItem STAGE_2;
    public static WeightedRandomTreasureItem STAGE_3;
    public static WeightedRandomTreasureItem STAGE_4;
    public static WeightedRandomTreasureItem STAGE_5;
    private static final RandomValueRange[] UNBREAKING_LEVELS;

    public static void loadJson(IResourceManager resourceManager) {
        try {
            JsonParser parser = new JsonParser();
            ResourceLocation stage1 = DungeonCrawl.locate("treasure/stage_1.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage1.toString());
            JsonArray array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage1).func_199027_b()))).getAsJsonArray();
            STAGE_1 = WeightedRandomTreasureItem.fromJson(array);
            ResourceLocation stage2 = DungeonCrawl.locate("treasure/stage_2.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage2.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage2).func_199027_b()))).getAsJsonArray();
            STAGE_2 = WeightedRandomTreasureItem.fromJson(array);
            ResourceLocation stage3 = DungeonCrawl.locate("treasure/stage_3.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage3.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage3).func_199027_b()))).getAsJsonArray();
            STAGE_3 = WeightedRandomTreasureItem.fromJson(array);
            ResourceLocation stage4 = DungeonCrawl.locate("treasure/stage_4.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage4.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage4).func_199027_b()))).getAsJsonArray();
            STAGE_4 = WeightedRandomTreasureItem.fromJson(array);
            ResourceLocation stage5 = DungeonCrawl.locate("treasure/stage_5.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage5.toString());
            array = parser.parse(new JsonReader((Reader)new InputStreamReader(resourceManager.func_199002_a(stage5).func_199027_b()))).getAsJsonArray();
            STAGE_5 = WeightedRandomTreasureItem.fromJson(array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack generate(ServerWorld world, Random rand, Integer lootLevel) {
        switch (lootLevel) {
            case 0: {
                return STAGE_1.roll(rand).createItem((IWorld)world, rand, lootLevel);
            }
            case 1: {
                return STAGE_2.roll(rand).createItem((IWorld)world, rand, lootLevel);
            }
            case 2: {
                return STAGE_3.roll(rand).createItem((IWorld)world, rand, lootLevel);
            }
            case 3: {
                return STAGE_4.roll(rand).createItem((IWorld)world, rand, lootLevel);
            }
        }
        return STAGE_5.roll(rand).createItem((IWorld)world, rand, lootLevel);
    }

    public static TreasureItem createEnchantedSpecialItem(String itemName) {
        return new TreasureItem("minecraft:air").setProcessor((world, rand, lootLevel) -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item != null) {
                ItemStack stack = new ItemStack((IItemProvider)item);
                if (rand.nextFloat() < 0.5f + 0.1f * (float)lootLevel.intValue()) {
                    return EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)stack, (int)(10 + 3 * lootLevel), (lootLevel > 2 ? 1 : 0) != 0);
                }
                return stack;
            }
            DungeonCrawl.LOGGER.error("The item {} does not exist.", (Object)itemName);
            return ItemStack.field_190927_a;
        });
    }

    public static ItemStack createShield(Random rand, int lootLevel) {
        ItemStack shield = new ItemStack((IItemProvider)Items.field_185159_cQ);
        lootLevel = Math.min(4, lootLevel);
        float f = rand.nextFloat();
        if (f < 0.12f + (float)lootLevel * 0.02f) {
            shield.func_77966_a(Enchantments.field_185307_s, UNBREAKING_LEVELS[lootLevel].func_186511_a(rand));
            if (f < 0.04f + (float)lootLevel * 0.01f) {
                shield.func_77966_a(Enchantments.field_185296_A, 1);
            }
            if (rand.nextFloat() < 0.75f) {
                shield.func_77966_a(Enchantments.field_190940_C, 1);
            }
        }
        shield.func_196082_o().func_218657_a("BlockEntityTag", (INBT)Banner.createPatterns(rand));
        return shield;
    }

    static {
        UNBREAKING_LEVELS = new RandomValueRange[]{new RandomValueRange(1.0f, 1.0f), new RandomValueRange(1.0f, 2.0f), new RandomValueRange(2.0f, 2.0f), new RandomValueRange(2.0f, 3.0f), new RandomValueRange(3.0f, 3.0f)};
        REINFORCED_BOW = new ItemStack((IItemProvider)Items.field_151031_f);
        REINFORCED_BOW.func_77966_a(Enchantments.field_185307_s, 1);
        REINFORCED_BOW.func_77966_a(Enchantments.field_185309_u, 1);
        REINFORCED_BOW.func_200302_a((ITextComponent)new StringTextComponent("Reinforced Bow"));
        BOOTS_OF_BATTLE = new ItemStack((IItemProvider)Items.field_151021_T);
        RandomEquipment.setArmorColor(BOOTS_OF_BATTLE, 3847130);
        BOOTS_OF_BATTLE.func_77966_a(Enchantments.field_185307_s, 1);
        BOOTS_OF_BATTLE.func_77966_a(Enchantments.field_180310_c, 1);
        BOOTS_OF_BATTLE.func_200302_a((ITextComponent)new StringTextComponent("Boots of Battle"));
        PANTS_OF_DEFLECTION = new ItemStack((IItemProvider)Items.field_151026_S);
        RandomEquipment.setArmorColor(PANTS_OF_DEFLECTION, 3847130);
        PANTS_OF_DEFLECTION.func_77966_a(Enchantments.field_180310_c, 2);
        PANTS_OF_DEFLECTION.func_77966_a(Enchantments.field_92091_k, 1);
        PANTS_OF_DEFLECTION.func_200302_a((ITextComponent)new StringTextComponent("Pants of Deflection"));
        LUMBERJACKET = new ItemStack((IItemProvider)Items.field_151027_R);
        RandomEquipment.setArmorColor(LUMBERJACKET, 11546150);
        LUMBERJACKET.func_77966_a(Enchantments.field_185307_s, 3);
        LUMBERJACKET.func_77966_a(Enchantments.field_77329_d, 1);
        LUMBERJACKET.func_200302_a((ITextComponent)new StringTextComponent("Lumberjacket"));
        YOKEL_AXE = new ItemStack((IItemProvider)Items.field_151036_c);
        YOKEL_AXE.func_77966_a(Enchantments.field_185305_q, 2);
        YOKEL_AXE.func_77966_a(Enchantments.field_185302_k, 1);
        YOKEL_AXE.func_77966_a(Enchantments.field_185307_s, 1);
        YOKEL_AXE.func_200302_a((ITextComponent)new StringTextComponent("Yokel's Axe"));
        DOOM = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:golden_sword")));
        DOOM.func_77966_a(Enchantments.field_185302_k, 1);
        DOOM.func_77966_a(Enchantments.field_77334_n, 2);
        DOOM.func_77966_a(Enchantments.field_185307_s, 1);
        DOOM.func_200302_a((ITextComponent)new StringTextComponent("Doom"));
        THE_SLAYER = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:diamond_sword")));
        THE_SLAYER.func_77966_a(Enchantments.field_185302_k, 4);
        THE_SLAYER.func_200302_a((ITextComponent)new StringTextComponent("The Slayer"));
        DEMON_HUNTER_CROSSBOW = new ItemStack((IItemProvider)Items.field_222114_py);
        DEMON_HUNTER_CROSSBOW.func_77966_a(Enchantments.field_222194_I, 2);
        DEMON_HUNTER_CROSSBOW.func_77966_a(Enchantments.field_222192_G, 1);
        DEMON_HUNTER_CROSSBOW.func_77966_a(Enchantments.field_222193_H, 1);
        DEMON_HUNTER_CROSSBOW.func_77966_a(Enchantments.field_185309_u, 4);
        DEMON_HUNTER_CROSSBOW.func_200302_a((ITextComponent)new StringTextComponent("Demon Hunter's Crossbow"));
        THIEF_DAGGER = new ItemStack((IItemProvider)Items.field_151040_l);
        THIEF_DAGGER.func_77966_a(Enchantments.field_185302_k, 1);
        THIEF_DAGGER.func_77966_a(Enchantments.field_185304_p, 3);
        THIEF_DAGGER.func_200302_a((ITextComponent)new StringTextComponent("Thief's Dagger"));
        THE_GREAT_CLEAVER = new ItemStack((IItemProvider)Items.field_151048_u);
        THE_GREAT_CLEAVER.func_77966_a(Enchantments.field_191530_r, 3);
        THE_GREAT_CLEAVER.func_77966_a(Enchantments.field_185303_l, 4);
        THE_GREAT_CLEAVER.func_77966_a(Enchantments.field_185307_s, 3);
        THE_GREAT_CLEAVER.func_200302_a((ITextComponent)new StringTextComponent("The Great Cleaver"));
        ARCHANGEL_SWORD = new ItemStack((IItemProvider)Items.field_151010_B);
        ARCHANGEL_SWORD.func_77966_a(Enchantments.field_185302_k, 4);
        ARCHANGEL_SWORD.func_77966_a(Enchantments.field_185307_s, 2);
        ARCHANGEL_SWORD.func_77966_a(Enchantments.field_190940_C, 1);
        ARCHANGEL_SWORD.func_200302_a((ITextComponent)new StringTextComponent("Archangel's Sword"));
        REPULSER = new ItemStack((IItemProvider)Items.field_151040_l);
        REPULSER.func_77966_a(Enchantments.field_180313_o, 2);
        REPULSER.func_77966_a(Enchantments.field_191530_r, 1);
        REPULSER.func_200302_a((ITextComponent)new StringTextComponent("Repulser"));
        ELB_BOW = new ItemStack((IItemProvider)Items.field_151031_f);
        ELB_BOW.func_77966_a(Enchantments.field_185309_u, 4);
        ELB_BOW.func_77966_a(Enchantments.field_222194_I, 3);
        ELB_BOW.func_77966_a(Enchantments.field_185296_A, 1);
        ELB_BOW.func_200302_a((ITextComponent)new StringTextComponent("Bow of the Elbs"));
        ITEMS = new ItemStack[]{REINFORCED_BOW, BOOTS_OF_BATTLE, LUMBERJACKET, YOKEL_AXE, DOOM, ARCHANGEL_SWORD, REPULSER};
        RARE_ITEMS = new ItemStack[]{THE_SLAYER, DEMON_HUNTER_CROSSBOW, THIEF_DAGGER, THE_GREAT_CLEAVER};
    }
}

