/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.dreadsteel.item.weapon;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.mindoth.dreadsteel.Dreadsteel;
import net.mindoth.dreadsteel.config.DreadsteelCommonConfig;
import net.mindoth.dreadsteel.entity.EntityScytheProjectileBlack;
import net.mindoth.dreadsteel.entity.EntityScytheProjectileBronze;
import net.mindoth.dreadsteel.entity.EntityScytheProjectileDefault;
import net.mindoth.dreadsteel.entity.EntityScytheProjectileWhite;
import net.mindoth.dreadsteel.item.weapon.DreadsteelTier;
import net.mindoth.dreadsteel.message.MessageSwingArm;
import net.mindoth.dreadsteel.registries.DreadsteelEntities;
import net.mindoth.dreadsteel.registries.DreadsteelItems;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dreadsteel")
public class DreadsteelScythe
extends SwordItem {
    @SubscribeEvent
    public static void dreadsteelScytheAttributeEvent(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (((Boolean)DreadsteelCommonConfig.SCYTHE_STATS_CHECK.get()).booleanValue() && item == DreadsteelItems.DREADSTEEL_SCYTHE.get() && event.getSlotType() == EquipmentSlotType.MAINHAND) {
            event.removeAttribute(Attributes.field_233823_f_);
            event.addModifier(Attributes.field_233823_f_, new AttributeModifier(field_111210_e, "Weapon modifier", (double)((Integer)DreadsteelCommonConfig.SCYTHE_DAMAGE.get() - 1), AttributeModifier.Operation.ADDITION));
            event.removeAttribute(Attributes.field_233825_h_);
            event.addModifier(Attributes.field_233825_h_, new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        }
    }

    public DreadsteelScythe(DreadsteelTier p_i48460_1_, int p_i48460_2_, float p_i48460_3_, Item.Properties p_i48460_4_) {
        super((IItemTier)p_i48460_1_, p_i48460_2_, p_i48460_3_, p_i48460_4_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.dreadsteel.dreadsteel_scythe"));
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        DreadsteelScythe.onLeftClick(event.getPlayer(), event.getItemStack());
        if (event.getWorld().field_72995_K) {
            Dreadsteel.sendMSGToServer(new MessageSwingArm());
        }
    }

    public static void onLeftClick(PlayerEntity playerEntity, ItemStack stack) {
        if (stack.func_77973_b() == DreadsteelItems.DREADSTEEL_SCYTHE.get()) {
            DreadsteelScythe.spawnProjectile(stack, playerEntity);
        }
    }

    public static void spawnProjectile(ItemStack stack, PlayerEntity player) {
        CompoundNBT tag = stack.func_196082_o();
        if ((float)player.field_110158_av > 0.5f) {
            return;
        }
        if (player.func_184586_b(Hand.MAIN_HAND) == stack) {
            Vector3d vector3d;
            AbstractArrowEntity shot;
            Multimap dmg = stack.func_111283_C(EquipmentSlotType.MAINHAND);
            double totalDmg = 0.0;
            for (AttributeModifier modifier : dmg.get((Object)Attributes.field_233823_f_)) {
                totalDmg += modifier.func_111164_d();
            }
            if (tag.func_74764_b("CustomModelData")) {
                Vector3f vector3f;
                if (tag.func_74762_e("CustomModelData") == 1) {
                    shot = new EntityScytheProjectileWhite((EntityType<? extends AbstractArrowEntity>)((EntityType)DreadsteelEntities.SCYTHE_PROJECTILE_WHITE.get()), player.field_70170_p, (LivingEntity)player, totalDmg);
                    vector3d = player.func_70040_Z();
                    vector3f = new Vector3f(vector3d);
                    shot.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), 2.0f, 0.5f);
                    player.field_70170_p.func_217376_c((Entity)shot);
                }
                if (tag.func_74762_e("CustomModelData") == 2) {
                    shot = new EntityScytheProjectileBlack((EntityType<? extends AbstractArrowEntity>)((EntityType)DreadsteelEntities.SCYTHE_PROJECTILE_BLACK.get()), player.field_70170_p, (LivingEntity)player, totalDmg);
                    vector3d = player.func_70040_Z();
                    vector3f = new Vector3f(vector3d);
                    shot.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), 2.0f, 0.5f);
                    player.field_70170_p.func_217376_c((Entity)shot);
                }
                if (tag.func_74762_e("CustomModelData") == 3) {
                    shot = new EntityScytheProjectileBronze((EntityType<? extends AbstractArrowEntity>)((EntityType)DreadsteelEntities.SCYTHE_PROJECTILE_BRONZE.get()), player.field_70170_p, (LivingEntity)player, totalDmg);
                    vector3d = player.func_70040_Z();
                    vector3f = new Vector3f(vector3d);
                    shot.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), 2.0f, 0.5f);
                    player.field_70170_p.func_217376_c((Entity)shot);
                }
            } else {
                shot = new EntityScytheProjectileDefault((EntityType<? extends AbstractArrowEntity>)((EntityType)DreadsteelEntities.SCYTHE_PROJECTILE_DEFAULT.get()), player.field_70170_p, (LivingEntity)player, totalDmg);
                vector3d = player.func_70040_Z();
                Vector3f vector3f = new Vector3f(vector3d);
                shot.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), 2.0f, 0.5f);
                player.field_70170_p.func_217376_c((Entity)shot);
            }
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_203274_ip, SoundCategory.PLAYERS, 0.75f, 0.75f);
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }
}

