/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.dreadsteel.item.armor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mindoth.dreadsteel.client.models.armor.DreadsteelModel;
import net.mindoth.dreadsteel.config.DreadsteelCommonConfig;
import net.mindoth.dreadsteel.registries.DreadsteelItems;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dreadsteel")
public class DreadsteelArmor
extends ArmorItem {
    public static final Map<String, UUID> NAME_UUID_MAP = new HashMap<String, UUID>();
    private final LazyValue<BipedModel<?>> model = (LazyValue)DistExecutor.unsafeRunForDist(() -> () -> new LazyValue(() -> this.provideArmorModelForSlot(slot)), () -> () -> null);

    public static UUID getUUID(ItemStack stack) {
        return NAME_UUID_MAP.computeIfAbsent(stack.func_77973_b().getRegistryName().toString(), s -> UUID.nameUUIDFromBytes(s.getBytes()));
    }

    @SubscribeEvent
    public static void dreadsteelAttributeEvent(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (((Boolean)DreadsteelCommonConfig.ARMOR_STATS_CHECK.get()).booleanValue()) {
            if (item == DreadsteelItems.DREADSTEEL_HELMET.get() && event.getSlotType() == EquipmentSlotType.HEAD) {
                event.removeAttribute(Attributes.field_233826_i_);
                event.removeAttribute(Attributes.field_233827_j_);
                event.removeAttribute(Attributes.field_233820_c_);
                event.addModifier(Attributes.field_233826_i_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.HELMET_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
                event.addModifier(Attributes.field_233827_j_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
                event.addModifier(Attributes.field_233820_c_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (item == DreadsteelItems.DREADSTEEL_CHESTPLATE.get() && event.getSlotType() == EquipmentSlotType.CHEST) {
                event.removeAttribute(Attributes.field_233826_i_);
                event.removeAttribute(Attributes.field_233827_j_);
                event.removeAttribute(Attributes.field_233820_c_);
                event.addModifier(Attributes.field_233826_i_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.CHESTPLATE_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
                event.addModifier(Attributes.field_233827_j_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
                event.addModifier(Attributes.field_233820_c_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (item == DreadsteelItems.DREADSTEEL_LEGGINGS.get() && event.getSlotType() == EquipmentSlotType.LEGS) {
                event.removeAttribute(Attributes.field_233826_i_);
                event.removeAttribute(Attributes.field_233827_j_);
                event.removeAttribute(Attributes.field_233820_c_);
                event.addModifier(Attributes.field_233826_i_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.LEGGINGS_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
                event.addModifier(Attributes.field_233827_j_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
                event.addModifier(Attributes.field_233820_c_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (item == DreadsteelItems.DREADSTEEL_BOOTS.get() && event.getSlotType() == EquipmentSlotType.FEET) {
                event.removeAttribute(Attributes.field_233826_i_);
                event.removeAttribute(Attributes.field_233827_j_);
                event.removeAttribute(Attributes.field_233820_c_);
                event.addModifier(Attributes.field_233826_i_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_armor", (double)((Integer)DreadsteelCommonConfig.BOOTS_ARMOR.get()).intValue(), AttributeModifier.Operation.ADDITION));
                event.addModifier(Attributes.field_233827_j_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_toughness", (double)((Integer)DreadsteelCommonConfig.ARMOR_TOUGHNESS.get()).intValue(), AttributeModifier.Operation.ADDITION));
                event.addModifier(Attributes.field_233820_c_, new AttributeModifier(DreadsteelArmor.getUUID(stack), "dreadsteel_knockback_resistance", ((Double)DreadsteelCommonConfig.ARMOR_KNOCKBACK_RESISTANCE.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public DreadsteelArmor(IArmorMaterial material, EquipmentSlotType slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    @SubscribeEvent
    public static void noHat(RenderPlayerEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == DreadsteelItems.DREADSTEEL_HELMET.get()) {
            ((PlayerModel)event.getRenderer().func_217764_d()).field_178720_f.field_78806_j = false;
        }
    }

    @SubscribeEvent
    public static void dreadsteelSetDefence(LivingAttackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == DreadsteelItems.DREADSTEEL_HELMET.get() && entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == DreadsteelItems.DREADSTEEL_CHESTPLATE.get() && entity.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() == DreadsteelItems.DREADSTEEL_LEGGINGS.get() && entity.func_184582_a(EquipmentSlotType.FEET).func_77973_b() == DreadsteelItems.DREADSTEEL_BOOTS.get() && (event.getSource().func_76355_l().equals(DamageSource.field_180137_b.func_76355_l()) || event.getSource().func_76355_l().equals(DamageSource.field_76372_a.func_76355_l()) || event.getSource().func_76355_l().equals(DamageSource.field_76370_b.func_76355_l()) || event.getSource().func_76355_l().equals(DamageSource.field_76367_g.func_76355_l()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerUseArmorItem(PlayerInteractEvent.RightClickItem event) {
        CompoundNBT tag;
        ItemStack headStack = event.getPlayer().func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chestStack = event.getPlayer().func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legsStack = event.getPlayer().func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feetStack = event.getPlayer().func_184582_a(EquipmentSlotType.FEET);
        ItemStack mainStack = event.getPlayer().func_184582_a(EquipmentSlotType.MAINHAND);
        ItemStack offStack = event.getPlayer().func_184582_a(EquipmentSlotType.OFFHAND);
        if (event.getItemStack().func_77973_b().equals(DreadsteelItems.WHITE_KIT.get())) {
            if (headStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_HELMET.get())) {
                tag = headStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 1);
                headStack.func_77982_d(tag);
            }
            if (chestStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_CHESTPLATE.get())) {
                tag = chestStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 1);
                chestStack.func_77982_d(tag);
            }
            if (legsStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_LEGGINGS.get())) {
                tag = legsStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 1);
                legsStack.func_77982_d(tag);
            }
            if (feetStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_BOOTS.get())) {
                tag = feetStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 1);
                feetStack.func_77982_d(tag);
            }
            if (mainStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = mainStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 1);
                mainStack.func_77982_d(tag);
            }
            if (offStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = offStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 1);
                offStack.func_77982_d(tag);
            }
            if (mainStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = mainStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 1);
                mainStack.func_77982_d(tag);
            }
            if (offStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = offStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 1);
                offStack.func_77982_d(tag);
            }
            if (!event.getPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            event.getPlayer().func_213823_a(SoundEvents.field_187719_p, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (event.getItemStack().func_77973_b().equals(DreadsteelItems.BLACK_KIT.get())) {
            if (headStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_HELMET.get())) {
                tag = headStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 2);
                headStack.func_77982_d(tag);
            }
            if (chestStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_CHESTPLATE.get())) {
                tag = chestStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 2);
                chestStack.func_77982_d(tag);
            }
            if (legsStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_LEGGINGS.get())) {
                tag = legsStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 2);
                legsStack.func_77982_d(tag);
            }
            if (feetStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_BOOTS.get())) {
                tag = feetStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 2);
                feetStack.func_77982_d(tag);
            }
            if (mainStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = mainStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 2);
                mainStack.func_77982_d(tag);
            }
            if (offStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = offStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 2);
                offStack.func_77982_d(tag);
            }
            if (mainStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = mainStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 2);
                mainStack.func_77982_d(tag);
            }
            if (offStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = offStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 2);
                offStack.func_77982_d(tag);
            }
            if (!event.getPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            event.getPlayer().func_213823_a(SoundEvents.field_187719_p, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (event.getItemStack().func_77973_b().equals(DreadsteelItems.BRONZE_KIT.get())) {
            if (headStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_HELMET.get())) {
                tag = headStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 3);
                headStack.func_77982_d(tag);
            }
            if (chestStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_CHESTPLATE.get())) {
                tag = chestStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 3);
                chestStack.func_77982_d(tag);
            }
            if (legsStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_LEGGINGS.get())) {
                tag = legsStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 3);
                legsStack.func_77982_d(tag);
            }
            if (feetStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_BOOTS.get())) {
                tag = feetStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 3);
                feetStack.func_77982_d(tag);
            }
            if (mainStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = mainStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 3);
                mainStack.func_77982_d(tag);
            }
            if (offStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                tag = offStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 3);
                offStack.func_77982_d(tag);
            }
            if (mainStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = mainStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 3);
                mainStack.func_77982_d(tag);
            }
            if (offStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                tag = offStack.func_196082_o();
                tag.func_74768_a("CustomModelData", 3);
                offStack.func_77982_d(tag);
            }
            if (!event.getPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            event.getPlayer().func_213823_a(SoundEvents.field_187719_p, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (event.getItemStack().func_77973_b().equals(DreadsteelItems.DEFAULT_KIT.get())) {
            if (headStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_HELMET.get())) {
                headStack.func_196083_e("CustomModelData");
            }
            if (chestStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_CHESTPLATE.get())) {
                chestStack.func_196083_e("CustomModelData");
            }
            if (legsStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_LEGGINGS.get())) {
                legsStack.func_196083_e("CustomModelData");
            }
            if (feetStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_BOOTS.get())) {
                feetStack.func_196083_e("CustomModelData");
            }
            if (mainStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                mainStack.func_196083_e("CustomModelData");
            }
            if (offStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SCYTHE.get())) {
                offStack.func_196083_e("CustomModelData");
            }
            if (mainStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                mainStack.func_196083_e("CustomModelData");
            }
            if (offStack.func_77973_b().equals(DreadsteelItems.DREADSTEEL_SHIELD.get())) {
                offStack.func_196083_e("CustomModelData");
            }
            if (!event.getPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            event.getPlayer().func_213823_a(SoundEvents.field_187719_p, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        CompoundNBT tag = stack.func_77978_p();
        String color = null;
        if (tag != null) {
            if (tag.func_74762_e("CustomModelData") == 1) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_white.png";
            }
            if (tag.func_74762_e("CustomModelData") == 2) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_black.png";
            }
            if (tag.func_74762_e("CustomModelData") == 3) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_bronze.png";
            }
            if (tag.func_74762_e("CustomModelData") == 0) {
                color = "dreadsteel:textures/item/dreadsteel_armor_model_default.png";
            }
        } else {
            color = "dreadsteel:textures/item/dreadsteel_armor_model_default.png";
        }
        return color;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((BipedModel)this.model.func_179281_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<?> provideArmorModelForSlot(EquipmentSlotType slot) {
        return new DreadsteelModel(slot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.dreadsteel.dreadsteel_setbonus"));
        super.func_77624_a(stack, world, tooltip, flagIn);
    }

    public static enum MaterialDreadsteel implements IArmorMaterial
    {
        DREADSTEEL("dreadsteel", 0, new int[]{9, 12, 15, 10}, 25, SoundEvents.field_232681_Q_, 8.0f, 0.25f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)DreadsteelItems.DREADSTEEL_INGOT.get()}));

        private static final int[] MAX_DAMAGE_ARRAY;
        private final String name;
        private final int maxDamageFactor;
        private final int[] damageReductionAmountArray;
        private final int enchantability;
        private final SoundEvent soundEvent;
        private final float toughness;
        private final float knockbackResistance;
        private final LazyValue<Ingredient> repairMaterial;

        private MaterialDreadsteel(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
            this.name = name;
            this.maxDamageFactor = maxDamageFactor;
            this.damageReductionAmountArray = damageReductionAmountArray;
            this.enchantability = enchantability;
            this.soundEvent = soundEvent;
            this.toughness = toughness;
            this.knockbackResistance = knockbackResistance;
            this.repairMaterial = new LazyValue(repairMaterial);
        }

        public int func_200896_a(EquipmentSlotType slotIn) {
            return MAX_DAMAGE_ARRAY[slotIn.func_188454_b()] * this.maxDamageFactor;
        }

        public int func_200902_b(EquipmentSlotType slotIn) {
            return this.damageReductionAmountArray[slotIn.func_188454_b()];
        }

        public int func_200900_a() {
            return this.enchantability;
        }

        public SoundEvent func_200899_b() {
            return this.soundEvent;
        }

        public Ingredient func_200898_c() {
            return (Ingredient)this.repairMaterial.func_179281_c();
        }

        @OnlyIn(value=Dist.CLIENT)
        public String func_200897_d() {
            return this.name;
        }

        public float func_200901_e() {
            return this.toughness;
        }

        public float func_230304_f_() {
            return this.knockbackResistance;
        }

        static {
            MAX_DAMAGE_ARRAY = new int[]{9, 12, 15, 10};
        }
    }
}

