/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.lib;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.utils.CyclingItemGroup;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.lib.BaseModule;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleImpl;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleItem;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.foxmcloud.draconicadditions.DAConfig;
import net.foxmcloud.draconicadditions.modules.ModuleTypes;
import net.foxmcloud.draconicadditions.modules.TickAccelData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="draconicadditions", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="draconicadditions")
public class DAModules {
    @ObjectHolder(value="chaotic_auto_feed")
    public static Module<NoData> chaoticAutoFeed;
    @ObjectHolder(value="draconic_tick_accel")
    public static Module<TickAccelData> draconicTickAccel;
    @ObjectHolder(value="chaotic_tick_accel")
    public static Module<TickAccelData> chaoticTickAccel;
    private static transient ArrayList<ResourceLocation> ITEM_REGISTRY_ORDER;
    public static transient Map<BaseModule<?>, Item> moduleItemMap;
    private static transient CyclingItemGroup moduleGroup;

    private static void registerModules() {
        DAModules.register(new ModuleImpl(com.brandon3055.draconicevolution.api.modules.ModuleTypes.AUTO_FEED, TechLevel.CHAOTIC, DAModules.autoFeedData((float)DAConfig.chaoticFeedAmount)), "chaotic_auto_feed");
        DAModules.register(new ModuleImpl(ModuleTypes.TICK_ACCEL, TechLevel.DRACONIC, DAModules.tickAccelData(DAConfig.draconicAccelTicks)), "draconic_tick_accel");
        DAModules.register(new ModuleImpl(ModuleTypes.TICK_ACCEL, TechLevel.CHAOTIC, DAModules.tickAccelData(DAConfig.chaoticAccelTicks)), "chaotic_tick_accel");
    }

    private static Function<Module<AutoFeedData>, AutoFeedData> autoFeedData(float defFoodStorage) {
        return e -> {
            float foodStorage = (float)ModuleCfg.getModuleDouble((Module)e, (String)"food_storage", (double)defFoodStorage);
            return new AutoFeedData((double)foodStorage);
        };
    }

    private static Function<Module<TickAccelData>, TickAccelData> tickAccelData(int defTickSpeed) {
        return e -> {
            int speed = ModuleCfg.getModuleInt((Module)e, (String)"tick_accel", (int)defTickSpeed);
            return new TickAccelData(speed);
        };
    }

    private static void register(ModuleImpl<?> module, String name) {
        ModuleItem item = new ModuleItem(new Item.Properties().func_200916_a((ItemGroup)moduleGroup), module);
        item.setRegistryName(name + "_module");
        module.setRegistryName(name);
        module.setModuleItem((Item)item);
        moduleItemMap.put((BaseModule<?>)module, (Item)item);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        moduleItemMap.clear();
        DAModules.registerModules();
        moduleItemMap.keySet().forEach(BaseModule::reloadData);
        moduleItemMap.values().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
        ModuleCfg.saveStateConfig();
    }

    @SubscribeEvent
    public static void registerModules(RegistryEvent.Register<Module<?>> event) {
        moduleItemMap.keySet().forEach(e -> event.getRegistry().register((IForgeRegistryEntry)e));
    }

    static {
        ITEM_REGISTRY_ORDER = new ArrayList();
        moduleItemMap = new LinkedHashMap();
        moduleGroup = new CyclingItemGroup("draconicadditions.modules", 40, () -> moduleItemMap.values().toArray(new Item[0]), ITEM_REGISTRY_ORDER);
    }
}

