/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.tools;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.EquipCfg;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.CommonMethods;
import net.foxmcloud.draconicadditions.DAConfig;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.foxmcloud.draconicadditions.items.IChaosContainer;
import net.foxmcloud.draconicadditions.items.ISimpleCountdown;
import net.foxmcloud.draconicadditions.items.ModularEnergyItem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChaosContainer
extends ModularEnergyItem
implements IChaosContainer,
IInvCharge,
ISimpleCountdown {
    public static final ModuleCategory CHAOSCONTAINER = new ModuleCategory();

    public ChaosContainer(TechPropBuilder props) {
        super(props);
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = super.createHost(stack);
        host.addCategories(new ModuleCategory[]{CHAOSCONTAINER});
        host.addAdditionalType(ModuleTypes.SHIELD_BOOST);
        return host;
    }

    public void upkeep(PlayerEntity player, ItemStack stack, World world) {
        if (this.getChaos(stack) > 0 && !player.func_184812_l_() && !player.func_175149_v()) {
            long RFToDrain;
            if (CommonMethods.cheatCheck(stack, world) || !this.hasShielding(stack)) {
                this.extractEnergy(player, stack, Long.MAX_VALUE);
            }
            if (this.extractEnergy(player, stack, RFToDrain = this.getRFCost(stack)) < RFToDrain) {
                Vector3 pos = new Vector3(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                CommonMethods.explodeEntity(pos, world);
                player.func_70097_a(CommonMethods.chaosBurst, (float)this.getChaos(stack));
                player.func_146105_b((ITextComponent)new TranslationTextComponent("info.da.chaos.explode"), true);
                stack.func_190918_g(1);
            } else if (this.isOverCapacity(stack) && this.hasShielding(stack)) {
                if (this.getCurrentCountdown(stack) <= 0 || this.getCountdownAmount(stack) <= this.getCurrentCountdown(stack)) {
                    this.resetCountdown(stack);
                }
                if (this.advanceCountdown(stack)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("info.da.chaos.warning").func_240699_a_(TextFormatting.RED), true);
                } else if (this.getCurrentCountdown(stack) == this.getCountdownAmount(stack) / 2) {
                    player.func_146105_b((ITextComponent)new StringTextComponent(""), true);
                }
            }
        } else {
            CommonMethods.cheatCheck(stack, world);
        }
    }

    public void handleTick(ItemStack stack, LivingEntity entity, @Nullable EquipmentSlotType slot, boolean inEquipModSlot) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (player.field_70170_p.field_72995_K && this.isOverCapacity(stack) && this.hasShielding(stack) && !player.func_184812_l_() && !player.func_175149_v() && this.getCurrentCountdown(stack) <= 0) {
            float pitch = 1.5f + (float)(1.0 - (double)EnergyUtils.getEnergyStored((ItemStack)stack) / (double)EnergyUtils.getMaxEnergyStored((ItemStack)stack)) * 0.5f;
            player.field_70170_p.func_184133_a(player, new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()), DESounds.beam, SoundCategory.MASTER, 1.0f, pitch);
        }
        this.upkeep(player, stack, player.field_70170_p);
    }

    public boolean onDroppedByPlayer(ItemStack stack, PlayerEntity player) {
        if (this.getChaos(stack) > 0 && !player.func_184812_l_()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("msg.da.chaosContainer.cantdrop"), true);
            return false;
        }
        ItemNBTHelper.setLong((ItemStack)stack, (String)"cheatCheck", (long)0L);
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            if (this.getChaos(stack) > 0 && !ent.func_180431_b(CommonMethods.chaosBurst)) {
                Vector3 pos = new Vector3(ent.func_226277_ct_(), ent.func_226278_cu_(), ent.func_226281_cx_());
                CommonMethods.explodeEntity(pos, player.field_70170_p);
                if (!player.field_70170_p.field_72995_K) {
                    float damage = Math.min((float)this.getChaos(stack), ent.func_110143_aJ());
                    entity.func_70097_a(CommonMethods.chaosBurst, damage);
                    this.removeChaos(stack, (int)Math.floor(damage));
                }
                return true;
            }
        }
        return false;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (world.func_175625_s(pos = context.func_195995_a()) instanceof TileChaosHolderBase) {
            TileChaosHolderBase tileEntity = (TileChaosHolderBase)world.func_175625_s(pos);
            if (((ChaosContainer)stack.func_77973_b()).getChaos(stack) > 0 && tileEntity.chaos.get() != tileEntity.getMaxChaos()) {
                int chaosToRemove = Math.min(tileEntity.getMaxChaos() - tileEntity.chaos.get(), this.getChaos(stack));
                int removed = this.removeChaos(stack, chaosToRemove);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("info.da.chaos.xfer.to", new Object[]{removed, tileEntity.func_200200_C_()}), true);
                tileEntity.chaos.add(removed);
            } else {
                int chaosToAdd = Math.min(this.getMaxChaos(stack) - this.getChaos(stack), tileEntity.chaos.get());
                int added = chaosToAdd - this.addChaos(stack, chaosToAdd);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("info.da.chaos.xfer.from", new Object[]{added, tileEntity.func_200200_C_()}), true);
                tileEntity.chaos.subtract(added);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.getChaos(oldStack) != this.getChaos(newStack);
    }

    public boolean canCharge(ItemStack stack, LivingEntity player, boolean isHeld) {
        return true;
    }

    @Override
    public int getMaxChaos(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse((Object)new ModuleHostImpl(TechLevel.CHAOTIC, 4, 4, "curios", false, new ModuleCategory[]{CHAOSCONTAINER}));
        return ((ShieldData)host.getModuleData(ModuleTypes.SHIELD_BOOST, (ModuleData)new ShieldData(0, 0.0))).getShieldCapacity() * 10;
    }

    private double getRFCostPerChaos(ShieldData shielding) {
        return (double)(shielding.getShieldCapacity() * shielding.getShieldCapacity()) * EquipCfg.shieldPassiveModifier / shielding.getShieldRecharge() * DAConfig.chaosContainerRFMultiplier;
    }

    private long getRFCost(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        ShieldData shielding = (ShieldData)host.getModuleData(ModuleTypes.SHIELD_BOOST, (ModuleData)new ShieldData(0, 0.0));
        return Math.round(this.getRFCostPerChaos(shielding) * (double)this.getChaos(stack) * (this.isOverCapacity(stack) && this.hasShielding(stack) ? Math.pow(2.0, (double)this.getChaos(stack) / (double)this.getMaxChaos(stack)) : 1.0));
    }

    private boolean isOverCapacity(ItemStack stack) {
        int chaos = this.getChaos(stack);
        int maxChaos = this.getMaxChaos(stack);
        return this.getChaos(stack) > this.getMaxChaos(stack);
    }

    private boolean hasShielding(ItemStack stack) {
        return this.getMaxChaos(stack) > 0;
    }

    @Override
    public int getCountdownAmount(ItemStack stack) {
        return Math.max((int)Math.round((double)EnergyUtils.getEnergyStored((ItemStack)stack) / (double)EnergyUtils.getMaxEnergyStored((ItemStack)stack) * 40.0), 2);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean hasEnergy;
        if (!Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("[Modular Item]").func_240699_a_(TextFormatting.BLUE));
        }
        tooltip.add(this.getChaosInfo(stack));
        EnergyUtils.addEnergyInfo((ItemStack)stack, tooltip);
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElse(null);
        if (host != null) {
            long rfCost = this.getRFCost(stack);
            if (rfCost >= 0L) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.da.opCost", new Object[]{Utils.formatNumber((long)rfCost)}).func_240699_a_(TextFormatting.GRAY));
            }
            if (this.isOverCapacity(stack) && this.hasShielding(stack)) {
                tooltip.add((ITextComponent)(this.getCurrentCountdown(stack) > this.getCountdownAmount(stack) / 2 ? new TranslationTextComponent("info.da.chaos.warning").func_240699_a_(TextFormatting.RED) : new StringTextComponent("")));
            }
        }
        boolean bl = hasEnergy = EnergyUtils.getMaxEnergyStored((ItemStack)stack) > 0L;
        if (!hasEnergy || !this.hasShielding(stack)) {
            if (!this.hasShielding(stack)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.da.chaos.noShield").func_240699_a_(TextFormatting.RED));
            }
            if (!hasEnergy) {
                tooltip.add((ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.requires_energy").func_240699_a_(TextFormatting.RED));
            }
            if (KeyBindings.toolModules != null && KeyBindings.toolModules.func_238171_j_() != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("modular_item.draconicevolution.requires_energy_press", new Object[]{KeyBindings.toolModules.func_238171_j_().getString()}).func_240699_a_(TextFormatting.BLUE));
            }
        }
    }
}

