/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.curios;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.brandonscore.lib.TechPropBuilder;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.CommonMethods;
import net.foxmcloud.draconicadditions.DAConfig;
import net.foxmcloud.draconicadditions.items.ModularEnergyItem;
import net.foxmcloud.draconicadditions.modules.ModuleTypes;
import net.foxmcloud.draconicadditions.modules.TickAccelData;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotTypePreset;

public class ModularHarness
extends ModularEnergyItem
implements IInvCharge {
    public static final ModuleCategory HARNESS = new ModuleCategory();
    private static final String receive = "receive_energy_from_machine";
    private static final String tickAccelSpeed = "tick_accel_speed";

    public ModularHarness(TechPropBuilder props) {
        super(props);
    }

    public boolean canCharge(ItemStack stack, LivingEntity player, boolean isHeld) {
        return !ModularHarness.isReceiving(stack);
    }

    public void handleTick(ItemStack stack, LivingEntity entity, @Nullable EquipmentSlotType slot, boolean inEquipModSlot) {
        boolean validEquipSlot;
        boolean bl = validEquipSlot = slot != null ? false : inEquipModSlot;
        if (!validEquipSlot && !DAConfig.harnessTickOutOfCuriosSlot || !ModularHarness.hasAttachedTileEntity(stack, entity.field_70170_p)) {
            return;
        }
        World world = entity.field_70170_p;
        BlockPos pos = entity.func_233580_cy_().func_177984_a();
        CommonMethods.BlockStorage oldBlock = new CommonMethods.BlockStorage(world, pos, false);
        TileEntity tile = ModularHarness.placeAndGetTileEntity(world, pos, entity.func_189653_aC(), stack);
        if (tile == null) {
            return;
        }
        stack.getCapability(DECapabilities.OP_STORAGE).ifPresent(e -> {
            IOPStorageModifiable storage = (IOPStorageModifiable)e;
            IOPStorage teStorage = EnergyUtils.getStorage((TileEntity)tile, null);
            if (teStorage != null) {
                if (ModularHarness.isReceiving(stack)) {
                    storage.receiveOP(EnergyUtils.extractEnergy((TileEntity)tile, (long)Math.min(storage.receiveOP(storage.maxReceive(), true), teStorage.getOPStored()), null, (boolean)false), false);
                    DEContent.capacitor_chaotic.handleTick(stack, entity, slot, inEquipModSlot);
                } else if (tile != null) {
                    storage.extractOP(EnergyUtils.insertEnergy((TileEntity)tile, (long)storage.extractOP(storage.maxExtract(), true), null, (boolean)false), false);
                }
            }
            if (tile instanceof ITickableTileEntity) {
                ITickableTileEntity tickingTile = (ITickableTileEntity)tile;
                int ticksToProcess = ModularHarness.getCurrentTickSpeed(stack) - 1;
                int rfCost = ModularHarness.getRFCostForTicks(ticksToProcess);
                if (storage.extractOP((long)rfCost, true) >= (long)rfCost) {
                    storage.extractOP((long)rfCost, false);
                    for (int i = 0; i < ticksToProcess; ++i) {
                        tickingTile.func_73660_a();
                    }
                }
            }
        });
        if (tile instanceof ITickableTileEntity) {
            ((ITickableTileEntity)tile).func_73660_a();
        }
        ModularHarness.storeTileEntity(world, pos, stack, entity, false);
        oldBlock.restoreBlock(null, false);
    }

    @Override
    public ModuleHostImpl createHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, this.techLevel.index, 2, "harness", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(new ModuleCategory[]{ModuleCategory.ENERGY, HARNESS});
        host.addPropertyBuilder(props -> {
            TickAccelData speed;
            props.add(new BooleanProperty(receive, false));
            props.add(new BooleanProperty("charge_held_item", false));
            props.add(new BooleanProperty("charge_armor", false));
            props.add(new BooleanProperty("charge_hot_bar", false));
            props.add(new BooleanProperty("charge_main", false));
            if (EquipmentManager.equipModLoaded()) {
                props.add(new BooleanProperty("charge_" + EquipmentManager.equipModID(), false));
            }
            if ((speed = (TickAccelData)host.getModuleData(ModuleTypes.TICK_ACCEL)) != null) {
                Supplier<Integer> speedGetter = () -> {
                    TickAccelData data = (TickAccelData)host.getModuleData(ModuleTypes.TICK_ACCEL);
                    return data == null ? 0 : data.getSpeed();
                };
                props.add(new IntegerProperty(tickAccelSpeed, speedGetter.get().intValue()).min(0).max(speedGetter).setFormatter(ConfigProperty.IntegerFormatter.RAW));
            }
        });
        return host;
    }

    @Override
    @Nullable
    public ModularOPStorage createOPStorage(ItemStack stack, ModuleHostImpl host) {
        long capacity = (long)((double)EquipCfg.getBaseEnergy((TechLevel)this.techLevel) * DAConfig.harnessCapacityMultiplier);
        return new ModularOPStorage(host, capacity, capacity / 64L, true);
    }

    public boolean canEquip(LivingEntity livingEntity, String identifier) {
        return identifier.equals(SlotTypePreset.BACK.getIdentifier());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        String name = ModularHarness.getAttachedName(stack);
        if (name != null && name != "") {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.da.modular_harness.storedBlock").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(ModularHarness.getAttachedName(stack)).func_240699_a_(TextFormatting.GRAY)));
            String rf = Utils.formatNumber((long)ModularHarness.getRFCostForTicks(ModularHarness.getCurrentTickSpeed(stack)));
            tooltip.add((ITextComponent)new TranslationTextComponent("info.da.opCost", new Object[]{rf}).func_240699_a_(TextFormatting.GRAY));
        }
        EnergyUtils.addEnergyInfo((ItemStack)stack, tooltip);
    }

    public static int getCurrentTickSpeed(ItemStack stack) {
        PropertyProvider props = (PropertyProvider)stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).orElse(null);
        int ticks = 1 + (props != null && props.getInt(tickAccelSpeed) != null ? props.getInt(tickAccelSpeed).getValue() : 0);
        return ticks;
    }

    public static int getRFCostForTicks(int ticks) {
        return ticks > 1 ? (int)Math.pow(400.0, (double)ticks * 0.25 + 0.25) : 0;
    }

    public static boolean storeTileEntity(World world, BlockPos pos, ItemStack stack, LivingEntity entity, boolean removeBlock) {
        if (world instanceof ServerWorld) {
            if (world.func_175625_s(pos) != null) {
                CommonMethods.BlockStorage block = new CommonMethods.BlockStorage(world, pos, removeBlock);
                block.storeBlockInTag(stack.func_196082_o());
            } else {
                entity.func_145747_a((ITextComponent)new TranslationTextComponent("info.da.modular_harness.cantmove"), Util.field_240973_b_);
                return false;
            }
        }
        return true;
    }

    public static TileEntity placeAndGetTileEntity(World world, BlockPos pos, @Nullable Vector2f rotation, ItemStack stack) {
        if (CommonMethods.BlockStorage.restoreBlockFromTag(world, pos, rotation, stack.func_77978_p(), false, false)) {
            return world.func_175625_s(pos);
        }
        return null;
    }

    public static String getAttachedName(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            Block block = CommonMethods.BlockStorage.getBlockFromTag(stack.func_77978_p());
            return block == null || block == Blocks.field_150350_a ? null : block.func_235333_g_().getString();
        }
        return null;
    }

    public static boolean hasAttachedTileEntity(ItemStack stack, World world) {
        return stack.func_196082_o().func_74764_b("storedBlockState");
    }

    public static boolean isReceiving(ItemStack stack) {
        BooleanProperty isReceiving = new BooleanProperty(null, false);
        stack.getCapability(DECapabilities.PROPERTY_PROVIDER_CAPABILITY).ifPresent(props -> isReceiving.setValue(props.getBool(receive).getValue()));
        return isReceiving.getValue();
    }
}

