/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.datagen;

import com.brandon3055.draconicevolution.api.modules.Module;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.foxmcloud.draconicadditions.lib.DAModules;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "draconicadditions", existingFileHelper);
    }

    protected void registerModels() {
        this.blockItem((Block)DAContent.chaosLiquefier);
        this.simpleItem(DAContent.chaosHeart);
        this.simpleItem(DAContent.inertPotatoHelm);
        this.simpleItem(DAContent.inertPotatoChest);
        this.simpleItem(DAContent.inertPotatoLegs);
        this.simpleItem(DAContent.inertPotatoBoots);
        this.simpleArmor((Item)DAContent.infusedPotatoHelm);
        this.simpleArmor((Item)DAContent.infusedPotatoChest);
        this.simpleArmor((Item)DAContent.infusedPotatoLegs);
        this.simpleArmor((Item)DAContent.infusedPotatoBoots);
        this.simpleItem((Item)DAContent.chaosContainer, "items/tools/animated");
        this.simpleCurios(DAContent.necklaceWyvern);
        this.simpleCurios(DAContent.necklaceDraconic);
        this.simpleCurios(DAContent.necklaceChaotic);
        this.simpleCurios(DAContent.harnessWyvern);
        this.simpleCurios(DAContent.harnessDraconic);
        this.simpleCurios(DAContent.harnessChaotic);
        this.simpleItem((Item)DAContent.hermal, new ResourceLocation("minecraft", "item/poisonous_potato"));
        this.simpleModule(DAModules.chaoticAutoFeed);
        this.simpleModule(DAModules.draconicTickAccel);
        this.simpleModule(DAModules.chaoticTickAccel);
    }

    private void simpleItem(Item item) {
        this.simpleItem(item, "items/crafting");
    }

    private void simpleArmor(Item item) {
        this.simpleItem(item, "items/armor");
    }

    private void simpleCurios(Item item) {
        this.simpleItem(item, "items/curios");
    }

    private void simpleItem(Item item, String textureFolder) {
        if (item == null) {
            return;
        }
        ResourceLocation reg = item.getRegistryName();
        this.simpleItem(item, new ResourceLocation(reg.func_110624_b(), textureFolder + "/" + reg.func_110623_a()));
    }

    private void simpleItem(Item item, ResourceLocation texture) {
        if (item == null) {
            return;
        }
        ResourceLocation reg = item.getRegistryName();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    private void simpleModule(Module<?> module) {
        this.simpleModule(module, "items/modules");
    }

    private void simpleModule(Module<?> module, String textureFolder) {
        if (module == null || module.getItem() == null) {
            return;
        }
        ResourceLocation reg = module.getItem().getRegistryName();
        this.simpleItem(module.getItem(), new ResourceLocation(reg.func_110624_b(), textureFolder + "/" + reg.func_110623_a().replace("_module", "")));
    }

    private void blockItem(Block block) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = block.getRegistryName();
        this.blockItem(block, new ResourceLocation(reg.func_110624_b(), "block/" + reg.func_110623_a()));
    }

    private void blockItem(Block block, ResourceLocation blockModel) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = block.getRegistryName();
        ((ItemModelBuilder)this.getBuilder(reg.func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile(blockModel));
    }

    private void dummyModel(Block block) {
        this.dummyModel(block.func_199767_j());
    }

    private void dummyModel(Item item) {
        ((ItemModelBuilder)this.getBuilder(item.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"));
    }

    public String func_200397_b() {
        return "Draconic Additions Item Models";
    }
}

