/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.blocks.tileentity;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.foxmcloud.draconicadditions.inventory.GUILayoutFactories;
import net.foxmcloud.draconicadditions.lib.DAContent;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileChaosLiquefier
extends TileChaosHolderBase
implements ITickableTileEntity,
IChangeListener,
IRSSwitchable,
INamedContainerProvider,
IInteractTile {
    private int chargeRate = 10000000;
    public int maxCharge = 200;
    public TileItemStackHandler itemHandler = new TileItemStackHandler(2);
    public final ManagedInt charge = (ManagedInt)this.register((IManagedData)new ManagedInt("charge", 0, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedInt chargeTo = (ManagedInt)this.register((IManagedData)new ManagedInt("chargeTo", this.maxCharge, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", false, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public OPStorage opStorage = new OPStorage(2000000000L, 20000000L, 20000000L);

    public TileChaosLiquefier() {
        super(DAContent.tileChaosLiquefier);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth().syncTile();
        this.itemHandler.setStackValidator(this::isItemValidForSlot);
        this.setupPowerSlot((IItemHandler)this.itemHandler, 1, (IOPStorage)this.opStorage, false);
        this.installIOTracker(this.opStorage);
    }

    public void func_73660_a() {
        super.tick();
        if (this.field_145850_b.field_72995_K) {
            if (this.active.get()) {
                if (this.charge.get() >= 0 && this.charge.get() < this.chargeTo.get() - 1) {
                    float beamPitch = 1.5f * (float)this.charge.get() / (float)this.maxCharge + 0.5f;
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, DESounds.beam, SoundCategory.BLOCKS, 0.2f, beamPitch, false);
                } else {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, DESounds.boom, SoundCategory.BLOCKS, 1.0f, 2.0f, false);
                }
            }
        } else {
            this.active.set(this.charge.get() > 0);
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            if (!stack.func_190926_b() && this.isItemValidForSlot(0, stack) && this.chaos.get() <= this.getMaxChaos() - this.calcChaos(stack) && this.isTileEnabled()) {
                int finalCharge = this.calcCharge(stack);
                if (finalCharge != this.chargeTo.get()) {
                    this.chargeTo.set(finalCharge);
                }
                if (this.opStorage.getEnergyStored() >= this.chargeRate) {
                    this.charge.add(1);
                    this.opStorage.extractOP((long)this.chargeRate, false);
                    if (this.charge.get() >= this.chargeTo.get()) {
                        this.discharge();
                    }
                } else if (this.charge.get() > 0) {
                    this.charge.subtract(1);
                }
            } else if (this.charge.get() > 0) {
                this.charge.subtract(1);
            }
        }
    }

    public void discharge() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        this.chaos.add(this.calcChaos(stack));
        if (this.chaos.get() > this.getMaxChaos()) {
            this.chaos.set(this.getMaxChaos());
        }
        stack.func_190918_g(1);
        if (stack.func_190916_E() == 0) {
            stack = ItemStack.field_190927_a;
        }
        this.charge.set(0);
    }

    public int calcChaos(ItemStack stack) {
        if (this.isItemValidForSlot(0, stack)) {
            switch (this.chaosID(stack.func_77973_b())) {
                case 1: {
                    return 1300;
                }
                case 2: {
                    return 150;
                }
                case 3: {
                    return 17;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 1800;
                }
            }
            return 0;
        }
        return 0;
    }

    public int calcCharge(ItemStack stack) {
        if (this.isItemValidForSlot(0, stack)) {
            switch (this.chaosID(stack.func_77973_b())) {
                case 1: {
                    return this.maxCharge;
                }
                case 2: {
                    return this.maxCharge / 2;
                }
                case 3: {
                    return this.maxCharge / 4;
                }
                case 4: {
                    return this.maxCharge / 8;
                }
                case 5: {
                    return this.maxCharge;
                }
            }
            return 0;
        }
        return 0;
    }

    public int chaosID(Item item) {
        if (item == DEContent.chaos_shard) {
            return 1;
        }
        if (item == DEContent.chaos_frag_large) {
            return 2;
        }
        if (item == DEContent.chaos_frag_medium) {
            return 3;
        }
        if (item == DEContent.chaos_frag_small) {
            return 4;
        }
        if (item == DAContent.chaosHeart) {
            return 5;
        }
        return 0;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (index == 0) {
            return this.chaosID(stack.func_77973_b()) > 0;
        }
        return EnergyUtils.canExtractEnergy((ItemStack)stack);
    }

    public Container createMenu(int currentWindowIndex, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerBCTile(DAContent.containerChaosLiquefier, currentWindowIndex, player.field_71071_by, (TileBCore)this, GUILayoutFactories.CHAOS_LIQUEFIER_LAYOUT);
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return true;
    }
}

