/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.handlers.DESounds;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.registries.ForgeRegistries;

public class CommonMethods {
    public static final DamageSource chaosBurst = new DamageSource("chaosBurst").func_76348_h();
    private static final short gracePeriod = 100;

    public static boolean cheatCheck(ItemStack stack, World world) {
        long containerTime = ItemNBTHelper.getLong((ItemStack)stack, (String)"cheatCheck", (long)0L);
        long serverTime = world.func_82737_E();
        boolean isCheating = false;
        if (containerTime < serverTime - 100L && containerTime > 100L) {
            isCheating = true;
        }
        ItemNBTHelper.setLong((ItemStack)stack, (String)"cheatCheck", (long)serverTime);
        return isCheating;
    }

    public static void explodeEntity(Vector3 pos, World world) {
        world.func_184133_a(null, new BlockPos(pos.x, pos.y, pos.z), DESounds.beam, SoundCategory.MASTER, 0.25f, 0.5f);
        world.func_184133_a(null, new BlockPos(pos.x, pos.y, pos.z), DESounds.fusionComplete, SoundCategory.MASTER, 1.0f, 2.0f);
        if (world.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
            }
        }
    }

    public static Direction getHorizontalDirectionFromLookAngle(Vector2f lookAngle) {
        float r;
        for (r = lookAngle.field_189983_j; r < 0.0f; r += 360.0f) {
        }
        if ((r %= 360.0f) > 315.0f || r <= 45.0f) {
            return Direction.SOUTH;
        }
        if (r > 45.0f && r <= 135.0f) {
            return Direction.WEST;
        }
        if (r > 135.0f && r <= 225.0f) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    public static Direction getDirectionFromLookAngle(Vector2f lookAngle) {
        if (lookAngle.field_189982_i > 45.0f) {
            return Direction.UP;
        }
        if (lookAngle.field_189982_i < -45.0f) {
            return Direction.DOWN;
        }
        return CommonMethods.getHorizontalDirectionFromLookAngle(lookAngle);
    }

    public static void overwriteBlockStateUnsafe(World world, BlockPos pos, BlockState blockState) {
        pos = pos.func_185334_h();
        int x = pos.func_177958_n() & 0xF;
        int y = pos.func_177956_o();
        int z = pos.func_177952_p() & 0xF;
        Chunk chunk = world.func_175726_f(pos);
        if (world.field_72995_K) {
            chunk.func_177436_a(pos, blockState, false);
            return;
        }
        ChunkSection chunksection = chunk.func_76587_i()[y >> 4];
        if (chunksection == Chunk.field_186036_a) {
            chunk.func_76587_i()[y >> 4] = chunksection = new ChunkSection(y >> 4 << 4);
        }
        TileEntity oldTile = world.func_175625_s(pos);
        BlockState oldState = (BlockState)chunksection.func_186049_g().func_222639_b(x, y & 0xF, z, (Object)blockState);
        if (oldState == blockState) {
            return;
        }
        if (blockState.hasTileEntity() && oldTile != null && !oldTile.func_200662_C().getRegistryName().toString().contentEquals(blockState.func_177230_c().getRegistryName().toString())) {
            world.func_175690_a(pos, blockState.createTileEntity((IBlockReader)world));
        }
    }

    public static CompoundNBT createFakeNBT(BlockPos pos) {
        CompoundNBT fakeNBT = new CompoundNBT();
        fakeNBT.func_74768_a("x", pos.func_177958_n());
        fakeNBT.func_74768_a("y", pos.func_177956_o());
        fakeNBT.func_74768_a("z", pos.func_177952_p());
        return fakeNBT;
    }

    public static class BlockStorage {
        private World oldWorld;
        private BlockPos oldPos;
        public BlockState blockState;
        public CompoundNBT tileNBT;

        public BlockStorage(World world, BlockPos pos) {
            this.storeBlockAt(world, pos);
        }

        public BlockStorage(World world, BlockPos pos, boolean removeBlock) {
            this.storeBlockAt(world, pos, removeBlock);
        }

        public BlockStorage(World world, BlockPos pos, BlockState blockState, CompoundNBT tileNBT) {
            this.oldWorld = world;
            this.oldPos = pos;
            this.blockState = blockState;
            this.tileNBT = tileNBT;
        }

        public void storeBlockAt(World world, BlockPos pos) {
            this.storeBlockAt(world, pos, false);
        }

        public void storeBlockAt(World world, BlockPos pos, boolean removeBlock) {
            this.oldWorld = world;
            this.oldPos = pos;
            this.blockState = world.func_180495_p(pos);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity != null) {
                this.tileNBT = tileEntity.serializeNBT();
                if (removeBlock) {
                    world.func_175625_s(pos).deserializeNBT(CommonMethods.createFakeNBT(pos));
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }

        public boolean restoreBlockAt(World world, BlockPos pos, @Nullable Vector2f rotation) {
            return this.restoreBlockAt(world, pos, rotation, true);
        }

        public boolean restoreBlockAt(World world, BlockPos pos, @Nullable Vector2f rotation, boolean permanent) {
            if (this.blockState != null) {
                String tileID;
                String savedID;
                TileEntity tileEntity;
                int flags;
                BlockStorage oldBlock = new BlockStorage(world, pos, false);
                int n = flags = permanent ? 19 : 0;
                if (permanent) {
                    world.func_180501_a(pos, this.blockState, flags);
                } else {
                    CommonMethods.overwriteBlockStateUnsafe(world, pos, this.blockState);
                }
                BlockState newState = world.func_180495_p(pos);
                if (newState.func_177230_c() != this.blockState.func_177230_c()) {
                    oldBlock.restoreBlock();
                    return false;
                }
                if (this.blockState.hasTileEntity() && this.tileNBT != null && this.tileNBT.func_74764_b("id") && (tileEntity = world.func_175625_s(pos)) != null && (savedID = this.tileNBT.func_74779_i("id")).contentEquals(tileID = tileEntity.func_200662_C().getRegistryName().toString())) {
                    tileEntity.deserializeNBT(this.tileNBT);
                    tileEntity.func_226984_a_(world, pos);
                    if (permanent) {
                        tileEntity.requestModelDataUpdate();
                    }
                }
                if (rotation != null) {
                    this.blockState.func_206871_b().forEach((prop, comp) -> {
                        if (prop instanceof DirectionProperty) {
                            Direction dir;
                            DirectionProperty dirProp = (DirectionProperty)prop;
                            if (dirProp == BlockStateProperties.field_208155_H) {
                                this.blockState = (BlockState)this.blockState.func_206870_a((Property)dirProp, (Comparable)CommonMethods.getDirectionFromLookAngle(rotation));
                            } else if (dirProp == BlockStateProperties.field_208157_J && (dir = CommonMethods.getHorizontalDirectionFromLookAngle(rotation)) != null) {
                                this.blockState = (BlockState)this.blockState.func_206870_a((Property)dirProp, (Comparable)dir);
                            }
                        }
                    });
                }
                if (permanent) {
                    world.func_180501_a(pos, this.blockState, flags);
                } else {
                    CommonMethods.overwriteBlockStateUnsafe(world, pos, this.blockState);
                }
                return true;
            }
            return false;
        }

        public void restoreBlock() {
            this.restoreBlock(null);
        }

        public void restoreBlock(@Nullable Vector2f rotation) {
            this.restoreBlock(rotation, true);
        }

        public void restoreBlock(@Nullable Vector2f rotation, boolean permanent) {
            this.restoreBlockAt(this.oldWorld, this.oldPos, rotation, permanent);
        }

        public CompoundNBT storeBlockInTag(CompoundNBT nbt) {
            return BlockStorage.storeBlockInTag(this.blockState, this.tileNBT, nbt);
        }

        public static CompoundNBT storeBlockInTag(World world, BlockPos pos, boolean removeBlock, CompoundNBT nbt) {
            BlockStorage block = new BlockStorage(world, pos, removeBlock);
            BlockStorage.storeBlockInTag(block.blockState, block.tileNBT, nbt);
            if (removeBlock) {
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            return nbt;
        }

        public static CompoundNBT storeBlockInTag(BlockState blockState, CompoundNBT tileNBT, CompoundNBT nbt) {
            String blockName = blockState.func_177230_c().getRegistryName().toString();
            nbt.func_74778_a("storedBlock", blockName);
            nbt.func_74768_a("storedBlockState", Block.func_196246_j((BlockState)blockState));
            if (tileNBT != null) {
                nbt.func_218657_a("storedTileEntity", (INBT)tileNBT);
            }
            return nbt;
        }

        public static boolean restoreBlockFromTag(World world, BlockPos pos, @Nullable Vector2f rotation, CompoundNBT nbt, boolean permanent, boolean clearNBT) {
            BlockStorage newBlock;
            if (nbt == null) {
                return false;
            }
            Block block = BlockStorage.getBlockFromTag(nbt);
            BlockState blockState = BlockStorage.getBlockStateFromTag(nbt);
            if (block == null || blockState == null) {
                return false;
            }
            if (blockState.func_177230_c() != block) {
                blockState = block.func_176223_P();
            }
            CompoundNBT tileNBT = null;
            if (nbt.func_74764_b("storedTileEntity")) {
                tileNBT = (CompoundNBT)nbt.func_74781_a("storedTileEntity");
            }
            if (!(newBlock = new BlockStorage(world, pos, blockState, tileNBT)).restoreBlockAt(world, pos, rotation, permanent)) {
                return false;
            }
            if (clearNBT) {
                nbt.func_82580_o("storedBlock");
                nbt.func_82580_o("storedBlockState");
                nbt.func_82580_o("storedTileEntity");
            }
            return true;
        }

        public static Block getBlockFromTag(CompoundNBT nbt) {
            return nbt == null ? null : (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("storedBlock")));
        }

        public static BlockState getBlockStateFromTag(CompoundNBT nbt) {
            return nbt != null && nbt.func_74764_b("storedBlockState") ? Block.func_196257_b((int)nbt.func_74762_e("storedBlockState")) : null;
        }
    }
}

