/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.brandonscore.lib.MultiBlockStorage;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.MultiBlockHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.blocks.tileentity.TileCoreStructure;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class EnergyCoreStructure
extends MultiBlockHelper {
    private final int FLAG_RENDER = 0;
    private final int FLAG_FORME = 1;
    private final int FLAG_REVERT = 2;
    private MultiBlockStorage[] structureTiers = new MultiBlockStorage[8];
    private TileEnergyCore core;
    public static boolean coreForming = false;

    public EnergyCoreStructure initialize(TileEnergyCore core) {
        this.core = core;
        this.structureTiers[0] = this.buildTier1();
        this.structureTiers[1] = this.buildTier2();
        this.structureTiers[2] = this.buildTier3();
        this.structureTiers[3] = this.buildTier4();
        this.structureTiers[4] = this.buildTier5();
        this.structureTiers[5] = this.buildTier6();
        this.structureTiers[6] = this.buildTier7();
        this.structureTiers[7] = this.buildTierOMG();
        return this;
    }

    public boolean checkTier(int tier) {
        BlockPos offset = this.getCoreOffset(tier);
        switch (tier) {
            case 1: {
                return this.structureTiers[0].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
            }
            case 2: {
                return this.structureTiers[1].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
            }
            case 3: {
                return this.structureTiers[2].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
            }
            case 4: {
                return this.structureTiers[3].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
            }
            case 5: {
                return this.structureTiers[4].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
            }
            case 6: {
                return this.structureTiers[5].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
            }
            case 7: {
                return this.structureTiers[6].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
            }
            case 8: {
                return this.structureTiers[7].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
            }
        }
        if (tier <= 0) {
            LogHelper.error("[EnergyCoreStructure] Tier value to small. As far as TileEnergyStorageCore is concerned the tiers now start at 1 not 0. This class automatically handles the conversion now");
        } else {
            LogHelper.error("[EnergyCoreStructure#checkTeir] What exactly were you expecting after Tier 8? Infinity.MAX_VALUE?");
        }
        return false;
    }

    public void placeTier(int tier) {
        BlockPos offset = this.getCoreOffset(tier);
        switch (tier) {
            case 1: {
                this.structureTiers[0].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
                return;
            }
            case 2: {
                this.structureTiers[1].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
                return;
            }
            case 3: {
                this.structureTiers[2].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
                return;
            }
            case 4: {
                this.structureTiers[3].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
                return;
            }
            case 5: {
                this.structureTiers[4].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
                return;
            }
            case 6: {
                this.structureTiers[5].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
                return;
            }
            case 7: {
                this.structureTiers[6].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
                return;
            }
            case 8: {
                this.structureTiers[7].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)offset));
                return;
            }
        }
        if (tier <= 0) {
            LogHelper.error("[EnergyCoreStructure] Tier value to small. As far as TileEnergyStorageCore is concerned the tiers now start at 1 not 0. This class automatically handles the conversion now");
        } else {
            LogHelper.error("[EnergyCoreStructure#placeTier] What exactly were you expecting after Tier 8? Infinity.MAX_VALUE?");
        }
    }

    public void renderTier(int tier) {
        this.forTier(tier, 0);
    }

    public void formTier(int tier) {
        coreForming = true;
        this.forTier(tier, 1);
        coreForming = false;
    }

    public void revertTier(int tier) {
        this.forTier(tier, 2);
    }

    private void forTier(int tier, int flag) {
        if (--tier < 0) {
            LogHelper.error("[EnergyCoreStructure] Tier value to small. As far as TileEnergyStorageCore is concerned the tiers now start at 1 not 0. This class automatically handles the conversion now");
        } else if (tier >= this.structureTiers.length) {
            LogHelper.error("[EnergyCoreStructure#placeTier] What exactly were you expecting after Tier 8? Infinity.MAX_VALUE?");
        } else {
            this.structureTiers[tier].forEachInStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vector3i)this.getCoreOffset(tier + 1)), flag);
        }
    }

    public MultiBlockStorage getStorageForTier(int tier) {
        return this.structureTiers[tier - 1];
    }

    public void forBlock(String name, World world, BlockPos pos, BlockPos startPos, int flag) {
        TileEntity tile;
        if (name.isEmpty() || name.equals(DEContent.energy_core.getRegistryName().toString())) {
            return;
        }
        if (flag == 0) {
            if (world.field_72995_K) {
                this.renderBuildGuide(name, world, pos, startPos, flag);
            }
        } else if (flag == 1) {
            world.func_175656_a(pos, DEContent.energy_core_structure.func_176223_P());
            TileEntity tile2 = world.func_175625_s(pos);
            if (tile2 instanceof TileCoreStructure) {
                ((TileCoreStructure)tile2).blockName.set(name);
                ((TileCoreStructure)tile2).setController(this.core);
            }
        } else if (flag == 2 && (tile = world.func_175625_s(pos)) instanceof TileCoreStructure) {
            ((TileCoreStructure)tile).revert();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBuildGuide(String name, World world, BlockPos pos, BlockPos startPos, int flag) {
        boolean invalid;
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        Vec3D corePos = Vec3D.getCenter((BlockPos)startPos.func_177973_b((Vector3i)this.getCoreOffset(this.core.tier.get())));
        double dist = Utils.getDistanceAtoB((Vec3D)corePos, (Vec3D)Vec3D.getCenter((BlockPos)pos));
        double pDist = corePos.distance((Entity)Minecraft.func_71410_x().field_71439_g);
        if (GuiEnergyCore.layer != -1) {
            pDist = GuiEnergyCore.layer + 2;
        }
        BlockState atPos = world.func_180495_p(pos);
        boolean bl = invalid = !world.func_175623_d(pos) && (atPos.func_177230_c().getRegistryName() == null || !atPos.func_177230_c().getRegistryName().toString().equals(name));
        if (dist + 2.0 > pDist && !invalid) {
            return;
        }
        if (name.equals("") || name.equals("air")) {
            return;
        }
        BlockPos translation = new BlockPos(pos.func_177958_n() - startPos.func_177958_n(), pos.func_177956_o() - startPos.func_177956_o(), pos.func_177952_p() - startPos.func_177952_p());
        translation = translation.func_177971_a((Vector3i)this.getCoreOffset(this.core.tier.get()));
        int alpha = -16777216;
        if (invalid) {
            alpha = (int)((Math.sin((double)ClientEventHandler.elapsedTicks / 20.0) + 1.0) / 2.0 * 255.0) << 24;
        }
        BlockState state = block.func_176223_P();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)translation.func_177958_n(), (double)translation.func_177956_o(), (double)translation.func_177952_p());
        if (invalid) {
            RenderSystem.disableDepthTest();
            RenderSystem.alphaFunc((int)516, (float)0.0f);
            double s = Math.sin((double)ClientEventHandler.elapsedTicks / 10.0) * 0.1;
            RenderSystem.scaled((double)(0.8 + s), (double)(0.8 + s), (double)(0.8 + s));
            RenderSystem.translated((double)(0.1 - s), (double)(0.1 - s), (double)(0.1 - s));
        } else {
            RenderSystem.scaled((double)0.8, (double)0.8, (double)0.8);
            RenderSystem.translated((double)0.1, (double)0.1, (double)0.1);
        }
        if (invalid) {
            RenderSystem.enableDepthTest();
            RenderSystem.alphaFunc((int)516, (float)0.1f);
        }
        RenderSystem.popMatrix();
    }

    private MultiBlockStorage buildTier1() {
        MultiBlockStorage storage = new MultiBlockStorage(1, (MultiBlockHelper)this);
        String X = DEContent.energy_core.getRegistryName().toString();
        storage.addRow(new String[]{X});
        return storage;
    }

    private MultiBlockStorage buildTier2() {
        MultiBlockStorage storage = new MultiBlockStorage(3, (MultiBlockHelper)this);
        String e = "";
        String X = DEContent.energy_core.getRegistryName().toString();
        String D = DEContent.block_draconium.getRegistryName().toString();
        storage.addRow(new String[]{e, e, e});
        storage.addRow(new String[]{e, D, e});
        storage.addRow(new String[]{e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, D, e});
        storage.addRow(new String[]{D, X, D});
        storage.addRow(new String[]{e, D, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e});
        storage.addRow(new String[]{e, D, e});
        storage.addRow(new String[]{e, e, e});
        return storage;
    }

    private MultiBlockStorage buildTier3() {
        MultiBlockStorage storage = new MultiBlockStorage(3, (MultiBlockHelper)this);
        String X = DEContent.energy_core.getRegistryName().toString();
        String D = DEContent.block_draconium.getRegistryName().toString();
        storage.addRow(new String[]{D, D, D});
        storage.addRow(new String[]{D, D, D});
        storage.addRow(new String[]{D, D, D});
        storage.newLayer();
        storage.addRow(new String[]{D, D, D});
        storage.addRow(new String[]{D, X, D});
        storage.addRow(new String[]{D, D, D});
        storage.newLayer();
        storage.addRow(new String[]{D, D, D});
        storage.addRow(new String[]{D, D, D});
        storage.addRow(new String[]{D, D, D});
        return storage;
    }

    private MultiBlockStorage buildTier4() {
        MultiBlockStorage storage = new MultiBlockStorage(5, (MultiBlockHelper)this);
        String e = "";
        String X = DEContent.energy_core.getRegistryName().toString();
        String D = DEContent.block_draconium.getRegistryName().toString();
        String R = Blocks.field_150451_bX.getRegistryName().toString();
        storage.addRow(new String[]{e, e, e, e, e});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{D, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, D});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.newLayer();
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{D, R, R, R, D});
        storage.addRow(new String[]{D, R, X, R, D});
        storage.addRow(new String[]{D, R, R, R, D});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.newLayer();
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{D, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, D});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{e, D, D, D, e});
        storage.addRow(new String[]{e, e, e, e, e});
        return storage;
    }

    private MultiBlockStorage buildTier5() {
        MultiBlockStorage storage = new MultiBlockStorage(7, (MultiBlockHelper)this);
        String e = "";
        String X = DEContent.energy_core.getRegistryName().toString();
        String D = DEContent.block_draconium.getRegistryName().toString();
        String R = Blocks.field_150451_bX.getRegistryName().toString();
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, X, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, e, D, D, D, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e});
        return storage;
    }

    private MultiBlockStorage buildTier6() {
        MultiBlockStorage storage = new MultiBlockStorage(9, (MultiBlockHelper)this);
        String e = "";
        String X = DEContent.energy_core.getRegistryName().toString();
        String D = DEContent.block_draconium.getRegistryName().toString();
        String R = Blocks.field_150451_bX.getRegistryName().toString();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, D, D, D, D, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, D, D, D, D, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, D, D, D, D, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, D, D, D, D, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, X, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, D, D, D, D, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, D, D, D, D, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, D, D, D, D, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, D, D, D, D, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e});
        return storage;
    }

    private MultiBlockStorage buildTier7() {
        MultiBlockStorage storage = new MultiBlockStorage(11, (MultiBlockHelper)this);
        String e = "";
        String X = DEContent.energy_core.getRegistryName().toString();
        String D = DEContent.block_draconium.getRegistryName().toString();
        String R = Blocks.field_150451_bX.getRegistryName().toString();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, X, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{D, R, R, R, R, R, R, R, R, R, D});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, D, R, R, R, R, R, R, R, D, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, D, R, R, R, R, R, D, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, R, R, R, D, e, e, e});
        storage.addRow(new String[]{e, e, e, D, D, D, D, D, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.newLayer();
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, D, D, D, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e});
        return storage;
    }

    /*
     * Opcode count of 19002 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private MultiBlockStorage buildTierOMG() {
        MultiBlockStorage storage = new MultiBlockStorage(13, (MultiBlockHelper)this);
        String e = "";
        String A = DEContent.block_draconium_awakened.getRegistryName().toString();
        String X = DEContent.energy_core.getRegistryName().toString();
        String D = DEContent.block_draconium.getRegistryName().toString();
        if (DEOldConfig.hardMode) {
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, A, A, A, A, A, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, A, A, A, A, A, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, A, A, A, A, A, A, A, e, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, e, A, A, A, A, A, A, A, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, X, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{A, A, D, D, D, D, D, D, D, D, D, A, A});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, A, A, A, A, A, A, A, e, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, A, A, D, D, D, D, D, D, D, A, A, e});
            storage.addRow(new String[]{e, e, A, A, A, A, A, A, A, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, A, A, A, A, A, A, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, D, D, D, D, D, A, A, e, e});
            storage.addRow(new String[]{e, e, A, A, A, A, A, A, A, A, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
        } else {
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, X, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{A, D, D, D, D, D, D, D, D, D, D, D, A});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, A, D, D, D, D, D, D, D, D, D, A, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, A, D, D, D, D, D, D, D, A, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, D, D, D, D, D, A, e, e, e});
            storage.addRow(new String[]{e, e, e, A, A, A, A, A, A, A, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.newLayer();
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, A, A, A, A, A, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
            storage.addRow(new String[]{e, e, e, e, e, e, e, e, e, e, e, e, e});
        }
        return storage;
    }

    public boolean checkBlock(String name, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCoreStructure && ((TileCoreStructure)tile).blockName.get().equals(name)) {
            return true;
        }
        return super.checkBlock(name, world, pos);
    }

    public BlockPos getCoreOffset(int tier) {
        int offset = tier == 1 ? 0 : (tier == 2 || tier == 3 ? -1 : -(tier - 2));
        return new BlockPos(offset, offset, offset);
    }

    public void setBlock(String name, World world, BlockPos pos) {
        if (!name.equals(DEContent.energy_core.getRegistryName().toString()) && name.length() > 0) {
            super.setBlock(name, world, pos);
        }
    }
}

