/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.brandonscore.lib.PairXZ;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.SimplexNoise;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;

public class ChaosWorldGenHandler {
    public static boolean generateChunk(Feature<NoFeatureConfig> feature, ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos featurePos) {
        ChunkPos chunkPos = new ChunkPos(featurePos);
        PairXZ<Integer, Integer> closestSpawn = ChaosWorldGenHandler.getClosestChaosSpawn(chunkPos);
        if ((Integer)closestSpawn.x == 0 && (Integer)closestSpawn.z == 0) {
            return false;
        }
        int posX = chunkPos.field_77276_a * 16;
        int posZ = chunkPos.field_77275_b * 16;
        int copyStartDistance = 180;
        if (Math.abs(posX - (Integer)closestSpawn.x) > copyStartDistance || Math.abs(posZ - (Integer)closestSpawn.z) > copyStartDistance) {
            return false;
        }
        boolean chunkModified = false;
        if ((Integer)closestSpawn.x > posX && (Integer)closestSpawn.x <= posX + 16 && (Integer)closestSpawn.z > posZ && (Integer)closestSpawn.z <= posZ + 16) {
            ChaosWorldGenHandler.generateStructures(reader, closestSpawn, rand);
            chunkModified = true;
        }
        if (!DEOldConfig.chaosIslandVoidMode) {
            for (int trueX = posX; trueX < posX + 16; ++trueX) {
                for (int y = 0; y < 255; ++y) {
                    for (int trueZ = posZ; trueZ < posZ + 16; ++trueZ) {
                        double plateauFalloff;
                        int x = trueX - (Integer)closestSpawn.x;
                        int z = trueZ - (Integer)closestSpawn.z;
                        int size = 80;
                        double dist = Math.sqrt(x * x + (y - 16) * (y - 16) + z * z);
                        double xd = (double)x / (double)size;
                        double yd = (double)y / 32.0;
                        double zd = (double)z / (double)size;
                        double centerFalloff = 1.0 / (dist * 0.05);
                        if (centerFalloff < 0.0) {
                            centerFalloff = 0.0;
                        }
                        if ((plateauFalloff = yd < 0.4 ? yd * 2.5 : (yd <= 0.6 ? 1.0 : (yd > 0.6 && yd < 1.0 ? 1.0 - (yd - 0.6) * 2.5 : 0.0))) == 0.0 || centerFalloff == 0.0) continue;
                        double heightMapFalloff = 0.0;
                        for (int octave = 1; octave < 5; ++octave) {
                            heightMapFalloff += (SimplexNoise.noise((double)(xd * (double)octave + (double)((Integer)closestSpawn.x).intValue()), (double)(zd * (double)octave + (double)((Integer)closestSpawn.z).intValue())) + 1.0) * 0.5 * 0.01 * ((double)octave * 10.0 * 1.0 - dist * 0.001);
                        }
                        if (heightMapFalloff <= 0.0) {
                            heightMapFalloff = 0.0;
                        }
                        if ((heightMapFalloff += (0.5 - Math.abs(yd - 0.5)) * 0.15) == 0.0) continue;
                        double density = centerFalloff * plateauFalloff * heightMapFalloff;
                        BlockPos pos = new BlockPos(x + (Integer)closestSpawn.x, y + 64 + DEOldConfig.chaosIslandYOffset, z + (Integer)closestSpawn.z);
                        if (!(density > 0.1) || !reader.func_175623_d(pos) || reader.func_180495_p(pos).func_177230_c() == Blocks.field_201941_jj) continue;
                        reader.func_180501_a(pos, dist > 60.0 || dist > (double)rand.nextInt(60) ? Blocks.field_150377_bs.func_176223_P() : Blocks.field_150343_Z.func_176223_P(), 3);
                        chunkModified = true;
                    }
                }
            }
        }
        return chunkModified;
    }

    public static void generateStructures(ISeedReader reader, PairXZ<Integer, Integer> islandCenter, Random random) {
        int outerRadius = 330;
        int shardY = 80 + DEOldConfig.chaosIslandYOffset;
        int coreHeight = 10;
        int coreWidth = 20;
        for (int y = shardY - coreHeight; y <= shardY + coreHeight; ++y) {
            int h = Math.abs(y - shardY);
            int inRadius = h - 3;
            double yp = (double)(coreHeight - h) / (double)coreHeight;
            int outRadius = (int)(yp * (double)coreWidth);
            outRadius -= outRadius * outRadius / 100;
            ChaosWorldGenHandler.genCoreSlice(reader, (Integer)islandCenter.x, y, (Integer)islandCenter.z, inRadius, shardY, coreWidth, true, random);
            ChaosWorldGenHandler.genCoreSlice(reader, (Integer)islandCenter.x, y, (Integer)islandCenter.z, outRadius, shardY, coreWidth, false, random);
        }
        BlockPos center = new BlockPos(((Integer)islandCenter.x).intValue(), shardY, ((Integer)islandCenter.z).intValue());
        reader.func_180501_a(center, DEContent.chaos_crystal.func_176223_P(), 3);
        TileChaosCrystal tileChaosShard = (TileChaosCrystal)reader.func_175625_s(center);
        if (tileChaosShard != null) {
            tileChaosShard.onValidPlacement();
        }
        WorldEntityHandler.addWorldEntity((World)reader.func_201672_e(), (WorldEntity)new GuardianFightManager(center));
    }

    public static void genCoreSlice(ISeedReader world, int xi, int yi, int zi, int ringRadius, int yc, int coreRadious, boolean fillIn, Random rand) {
        if (DEOldConfig.chaosIslandVoidMode) {
            return;
        }
        for (int x = xi - coreRadious; x <= xi + coreRadious; ++x) {
            for (int z = zi - coreRadious; z <= zi + coreRadious; ++z) {
                Block b;
                double oRad;
                double dist = Utils.getDistanceAtoB((double)x, (double)yi, (double)z, (double)xi, (double)yc, (double)zi);
                if (dist > (oRad = (double)(coreRadious - Math.abs(yc - yi) * Math.abs(yc - yi) / 10)) - 3.0 && rand.nextDouble() * 3.0 < dist - (oRad - 3.0)) continue;
                if (fillIn && (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) <= ringRadius) {
                    if ((int)dist < 9) {
                        world.func_180501_a(new BlockPos(x, yi, z), DEContent.infused_obsidian.func_176223_P(), 3);
                        continue;
                    }
                    world.func_180501_a(new BlockPos(x, yi, z), Blocks.field_150343_Z.func_176223_P(), 3);
                    continue;
                }
                if (!fillIn && (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) >= ringRadius) {
                    world.func_180501_a(new BlockPos(x, yi, z), Blocks.field_150343_Z.func_176223_P(), 3);
                    continue;
                }
                if (fillIn || (int)Utils.getDistanceAtoB((double)x, (double)z, (double)xi, (double)zi) > ringRadius || (b = world.func_180495_p(new BlockPos(x, yi, z)).func_177230_c()) != Blocks.field_150350_a && b != Blocks.field_150377_bs && b != Blocks.field_150343_Z) continue;
                world.func_180501_a(new BlockPos(x, yi, z), Blocks.field_201941_jj.func_176223_P(), 3);
            }
        }
    }

    public static PairXZ<Integer, Integer> getClosestChaosSpawn(ChunkPos pos) {
        return new PairXZ((Object)MathUtils.getNearestMultiple((int)(pos.field_77276_a * 16), (int)DEOldConfig.chaosIslandSeparation), (Object)MathUtils.getNearestMultiple((int)(pos.field_77275_b * 16), (int)DEOldConfig.chaosIslandSeparation));
    }

    public static void generateObelisk(ServerWorld world, BlockPos genPos, Random rand) {
        for (int i = 0; i < 20; i += 3) {
            LightningBoltEntity entity = new LightningBoltEntity(EntityType.field_200728_aG, (World)world);
            entity.func_70107_b((double)(genPos.func_177958_n() - 2 + rand.nextInt(5)), (double)(genPos.func_177956_o() - rand.nextInt(20)), (double)(genPos.func_177952_p() - 2 + rand.nextInt(5)));
            world.func_217376_c((Entity)entity);
        }
        if (DEOldConfig.chaosIslandVoidMode) {
            return;
        }
        int r = 3;
        BlockPos.func_218281_b((BlockPos)genPos.func_177982_a(-r, -25, -r), (BlockPos)genPos.func_177982_a(r, 4, r)).forEach(pos -> {
            if (pos.func_177956_o() < genPos.func_177956_o()) {
                double pct = (double)(genPos.func_177956_o() - pos.func_177956_o()) / 25.0;
                if (Utils.getDistanceAtoB((double)pos.func_177958_n(), (double)pos.func_177952_p(), (double)genPos.func_177958_n(), (double)genPos.func_177952_p()) <= (double)r + 0.5 && 1.0 - pct > rand.nextDouble()) {
                    float block = rand.nextFloat();
                    if ((double)block < 0.1) {
                        world.func_180501_a(pos, DEContent.infused_obsidian.func_176223_P(), 3);
                    } else if ((double)block < 0.4) {
                        world.func_180501_a(pos, Blocks.field_196653_dH.func_176223_P(), 3);
                    } else {
                        world.func_180501_a(pos, Blocks.field_150343_Z.func_176223_P(), 3);
                    }
                }
            }
            int relY = pos.func_177956_o() - genPos.func_177956_o();
            int absRelX = Math.abs(pos.func_177958_n() - genPos.func_177958_n());
            int absRelZ = Math.abs(pos.func_177952_p() - genPos.func_177952_p());
            if ((absRelX == 2 || absRelZ == 2) && absRelX <= 2 && absRelZ <= 2 && relY < 4 && relY > -1) {
                world.func_180501_a(pos, Blocks.field_150411_aY.func_176223_P(), 3);
            }
            if (relY == 4 && absRelX <= 2 && absRelZ <= 2) {
                world.func_180501_a(pos, Blocks.field_196575_bC.func_176223_P(), 3);
            }
        });
    }
}

