/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment.damage;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.api.modules.lib.IDamageModifier;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.client.render.effect.StaffBeamEffect;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DefaultStaffDmgMod
implements IDamageModifier {
    @Override
    public IDamageModifier.EffectType getType() {
        return IDamageModifier.EffectType.STAFF_BEAM;
    }

    @Override
    public void addInformation(Map<ITextComponent, ITextComponent> map, @Nullable ModuleContext context, boolean stack) {
    }

    @Override
    public SoundEvent chargeSound() {
        return DESounds.staffChargeFire;
    }

    @Override
    public SoundEvent fireSound() {
        return SoundEvents.field_187606_E;
    }

    @Override
    public int effectColour() {
        return 0;
    }

    @Override
    public void doDamageAndEffects(World world, Vector3d pos, @Nullable RayTraceResult traceResult, LivingEntity source, float baseDamage, float secondaryCharge, boolean isProjectile) {
        if (source == null) {
            return;
        }
        if (traceResult instanceof EntityRayTraceResult) {
            pos = pos.func_72441_c(0.0, (double)(((EntityRayTraceResult)traceResult).func_216348_a().func_213302_cg() / 2.0f), 0.0);
        } else if (traceResult != null) {
            pos = traceResult.func_216347_e();
        }
        Vector3d finalPos = pos;
        DraconicNetwork.sendStaffEffect(source, 0, e -> e.writeVector(new Vector3(finalPos)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleEffect(LivingEntity source, MCDataInput data) {
        Vector3 pos = data.readVector();
        ClientWorld world = (ClientWorld)source.field_70170_p;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147118_V().func_147682_a((ISound)new SimpleSound(DESounds.staffHitDefault, SoundCategory.PLAYERS, 10.0f, 1.0f, pos.pos()));
        mc.field_71452_i.func_78873_a((Particle)new StaffBeamEffect(world, source, pos));
    }
}

