/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.inventory.BlockToStackHelper;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public interface IModularMiningTool
extends IModularTieredItem {
    public static final Random rand = new Random();

    default public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (this.getEnergyStored(stack) < (long)EquipCfg.energyHarvest && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        int aoe = host.getModuleData(ModuleTypes.AOE, new AOEData(0)).getAOE();
        boolean aoeSafe = false;
        if (host instanceof PropertyProvider) {
            if (((PropertyProvider)((Object)host)).hasInt("mining_aoe")) {
                aoe = ((PropertyProvider)((Object)host)).getInt("mining_aoe").getValue();
            }
            if (((PropertyProvider)((Object)host)).hasBool("aoe_safe")) {
                aoeSafe = ((PropertyProvider)((Object)host)).getBool("aoe_safe").getValue();
            }
        }
        if (aoe > 0) {
            return this.breakAOEBlocks(stack, pos, aoe, 0, player, aoeSafe);
        }
        this.extractEnergy(player, stack, EquipCfg.energyHarvest);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    default public boolean breakAOEBlocks(ItemStack stack, BlockPos pos, int breakRadius, int breakDepth, PlayerEntity player, boolean aoeSafe) {
        BlockState blockState = player.field_70170_p.func_180495_p(pos);
        if (!this.isToolEffective(stack, blockState)) {
            return false;
        }
        InventoryDynamic inventoryDynamic = new InventoryDynamic();
        float refStrength = IModularMiningTool.blockStrength(blockState, player, player.field_70170_p, pos);
        Pair<BlockPos, BlockPos> aoe = this.getMiningArea(pos, player, breakRadius, breakDepth);
        List<BlockPos> aoeBlocks = BlockPos.func_218281_b((BlockPos)((BlockPos)aoe.key()), (BlockPos)((BlockPos)aoe.value())).map(BlockPos::new).collect(Collectors.toList());
        if (aoeSafe) {
            for (BlockPos blockPos : aoeBlocks) {
                if (player.field_70170_p.func_175623_d(blockPos) || player.field_70170_p.func_175625_s(blockPos) == null) continue;
                if (player.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("item_prop.draconicevolution.aoe_safe.blocked"), Util.field_240973_b_);
                } else {
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)((ServerPlayerEntity)player).field_70170_p, blockPos));
                }
                return true;
            }
        }
        aoeBlocks.forEach(block -> this.breakAOEBlock(stack, player.field_70170_p, (BlockPos)block, player, refStrength, inventoryDynamic, rand.nextInt(Math.max(5, breakRadius * breakDepth / 5)) == 0));
        List items = player.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB((BlockPos)aoe.key(), ((BlockPos)aoe.value()).func_177982_a(1, 1, 1)));
        for (ItemEntity item : items) {
            if (player.field_70170_p.field_72995_K || !item.func_70089_S()) continue;
            InventoryUtils.insertItem((IInventory)inventoryDynamic, (ItemStack)item.func_92059_d(), (boolean)false);
            item.func_70106_y();
        }
        if (!player.field_70170_p.field_72995_K) {
            void var13_16;
            boolean bl = false;
            while (var13_16 < inventoryDynamic.func_70302_i_()) {
                ItemStack sis = inventoryDynamic.func_70301_a((int)var13_16);
                if (sis != null) {
                    ItemEntity item = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sis);
                    item.func_174867_a(0);
                    player.field_70170_p.func_217376_c((Entity)item);
                }
                ++var13_16;
            }
            player.func_195068_e(inventoryDynamic.xp);
            inventoryDynamic.func_174888_l();
        }
        return true;
    }

    public static float blockStrength(BlockState state, PlayerEntity player, World world, BlockPos pos) {
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    default public Pair<BlockPos, BlockPos> getMiningArea(BlockPos pos, PlayerEntity player, int breakRadius, int breakDepth) {
        BlockRayTraceResult traceResult = RayTracer.retrace((PlayerEntity)player);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return new Pair((Object)pos, (Object)pos);
        }
        int sideHit = traceResult.func_216354_b().func_176745_a();
        int xMax = breakRadius;
        int xMin = breakRadius;
        int yMax = breakRadius;
        int yMin = breakRadius;
        int zMax = breakRadius;
        int zMin = breakRadius;
        int yOffset = 0;
        switch (sideHit) {
            case 0: {
                yMax = breakDepth;
                yMin = 0;
                zMax = breakRadius;
                break;
            }
            case 1: {
                yMin = breakDepth;
                yMax = 0;
                zMax = breakRadius;
                break;
            }
            case 2: {
                xMax = breakRadius;
                zMin = 0;
                zMax = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 3: {
                xMax = breakRadius;
                zMax = 0;
                zMin = breakDepth;
                yOffset = breakRadius - 1;
                break;
            }
            case 4: {
                xMax = breakDepth;
                xMin = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
                break;
            }
            case 5: {
                xMin = breakDepth;
                xMax = 0;
                zMax = breakRadius;
                yOffset = breakRadius - 1;
            }
        }
        if (breakRadius == 0) {
            yOffset = 0;
        }
        return new Pair((Object)pos.func_177982_a(-xMin, yOffset - yMin, -zMin), (Object)pos.func_177982_a(xMax, yOffset + yMax, zMax));
    }

    default public void breakAOEBlock(ItemStack stack, World world, BlockPos pos, PlayerEntity player, float refStrength, InventoryDynamic inventory, boolean breakFX) {
        if (world.func_175623_d(pos)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        FluidState fluidState = world.func_204610_c(pos);
        Block block = state.func_177230_c();
        if (!this.isToolEffective(stack, state)) {
            return;
        }
        float strength = IModularMiningTool.blockStrength(state, player, world, pos);
        if (!ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (block.removedByPlayer(state, world, pos, player, false, fluidState)) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            if (!world.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
            return;
        }
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos);
            if (xp == -1) {
                ServerPlayerEntity mpPlayer = (ServerPlayerEntity)player;
                mpPlayer.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
                return;
            }
            EquipCfg.energyHarvest = 256;
            stack.func_179548_a(world, state, pos, player);
            BlockToStackHelper.breakAndCollectWithPlayer((World)world, (BlockPos)pos, (InventoryDynamic)inventory, (PlayerEntity)player, (int)xp);
            this.extractEnergy(player, stack, EquipCfg.energyHarvest);
        } else {
            if (block.removedByPlayer(state, world, pos, player, true, fluidState)) {
                block.func_176206_d((IWorld)world, pos, state);
            }
            stack.func_179548_a(world, state, pos, player);
            if (Minecraft.func_71410_x().field_71476_x instanceof BlockRayTraceResult) {
                Minecraft.func_71410_x().func_147114_u().func_147297_a((IPacket)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.STOP_DESTROY_BLOCK, pos, ((BlockRayTraceResult)Minecraft.func_71410_x().field_71476_x).func_216354_b()));
            }
        }
    }
}

