/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularTieredItem;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.world.server.ServerWorld;

public interface IModularMelee
extends IModularTieredItem {
    default public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity target) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        float damage = (float)this.getAttackDamage(host, stack);
        long energyPerHit = (long)((float)EquipCfg.energyAttack * damage);
        this.extractEnergy(player, stack, energyPerHit);
        double aoe = (double)host.getModuleData(ModuleTypes.AOE, new AOEData(0)).getAOE() * 1.5;
        if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("attack_aoe")) {
            aoe = ((PropertyProvider)((Object)host)).getDecimal("attack_aoe").getValue();
        }
        float attackStrength = player.func_184825_o(0.5f);
        if (aoe > 0.0 && (double)attackStrength > 0.9) {
            this.dealAOEDamage(player, target, stack, energyPerHit, damage *= 0.2f + attackStrength * attackStrength * 0.8f, aoe);
        }
        return false;
    }

    default public void dealAOEDamage(PlayerEntity player, Entity target, ItemStack stack, long energyPerHit, float damage, double aoe) {
        List entities = player.field_70170_p.func_217357_a(LivingEntity.class, target.func_174813_aQ().func_72314_b(aoe, 0.25, aoe));
        double aoeAngle = 100.0;
        double yaw = player.field_70177_z - 180.0f;
        int fireAspect = EnchantmentHelper.func_90036_a((LivingEntity)player);
        for (LivingEntity entity : entities) {
            if (this.getEnergyStored(stack) < energyPerHit && !player.field_71075_bZ.field_75098_d) break;
            float distance = player.func_70032_d((Entity)entity);
            if (entity == player || entity == target || player.func_184191_r((Entity)entity) || distance < 1.0f || (double)entity.func_70032_d(target) > aoe) continue;
            double angle = Math.atan2(player.func_226277_ct_() - entity.func_226277_ct_(), player.func_226281_cx_() - entity.func_226281_cx_()) * 57.29577951308232;
            double relativeAngle = Math.abs((angle + yaw) % 360.0);
            if (relativeAngle <= aoeAngle / 2.0 || relativeAngle > 360.0 - aoeAngle / 2.0) {
                boolean lit = false;
                float health = entity.func_110143_aJ();
                if (fireAspect > 0 && !entity.func_70027_ad()) {
                    lit = true;
                    entity.func_70015_d(1);
                }
                if (entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), damage)) {
                    int k;
                    float damageDealt = health - entity.func_110143_aJ();
                    entity.func_233627_a_(0.4f, MathHelper.sin((double)((double)player.field_70177_z * 0.017453292519943)), -MathHelper.cos((double)((double)player.field_70177_z * 0.017453292519943)));
                    if (fireAspect > 0) {
                        entity.func_70015_d(fireAspect * 4);
                    }
                    if (player.field_70170_p instanceof ServerWorld && damageDealt > 2.0f) {
                        k = (int)((double)damage * 0.5);
                        ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, entity.func_226277_ct_(), entity.func_226283_e_(0.5), entity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                    }
                    player.func_195067_a(Stats.field_188111_y, Math.round(damageDealt * 10.0f));
                    if (player.field_70170_p instanceof ServerWorld && damageDealt > 2.0f) {
                        k = (int)((double)damageDealt * 0.5);
                        ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, entity.func_226277_ct_(), entity.func_226283_e_(0.5), entity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                    }
                } else if (lit) {
                    entity.func_70066_B();
                }
            }
            this.extractEnergy(player, stack, energyPerHit);
        }
    }
}

