/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.init.DEContent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;

public class ContainerReactor
extends ContainerBCTile<TileReactorCore> {
    public boolean fuelSlots = false;

    public ContainerReactor(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        this(DEContent.container_reactor, windowId, playerInv, (TileReactorCore)ContainerReactor.getClientTile((PacketBuffer)extraData));
    }

    public ContainerReactor(@Nullable ContainerType<?> type, int windowId, PlayerInventory player, TileReactorCore tile) {
        super(type, windowId, player, (TileBCore)tile);
    }

    public void setSlotState() {
        this.fuelSlots = ((TileReactorCore)this.tile).reactorState.get() == TileReactorCore.ReactorState.COLD;
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        if (this.fuelSlots) {
            int x;
            this.addPlayerSlots(13, 140);
            for (x = 0; x < 3; ++x) {
                this.func_75146_a(new SlotReactor((TileReactorCore)this.tile, x, 183 + x * 18, 149));
            }
            for (x = 0; x < 3; ++x) {
                this.func_75146_a(new SlotReactor((TileReactorCore)this.tile, 3 + x, 183 + x * 18, 180));
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (((TileReactorCore)this.tile).reactorState.get() == TileReactorCore.ReactorState.COLD != this.fuelSlots) {
            this.setSlotState();
        }
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        int maxFuel = 10383;
        int installedFuel = (int)(((TileReactorCore)this.tile).reactableFuel.get() + ((TileReactorCore)this.tile).convertedFuel.get());
        int free = maxFuel - installedFuel;
        Slot slot = this.func_75139_a(slotId);
        if (slot instanceof SlotReactor && clickTypeIn == ClickType.PICKUP) {
            PlayerInventory inventory = player.field_71071_by;
            ItemStack stackInSlot = slot.func_75211_c();
            ItemStack heldStack = inventory.func_70445_o();
            if (!heldStack.func_190926_b()) {
                ItemStack copy = heldStack.func_77946_l();
                copy.func_190920_e(1);
                int value = this.getFuelValue(copy);
                if (value > 0) {
                    int maxInsert = free / value;
                    int insert = Math.min(Math.min(heldStack.func_190916_E(), maxInsert), dragType == 1 ? 1 : 64);
                    ((TileReactorCore)this.tile).reactableFuel.add((double)(insert * value));
                    heldStack.func_190918_g(insert);
                } else {
                    value = this.getChaosValue(copy);
                    if (value > 0) {
                        int maxInsert = free / value;
                        int insert = Math.min(Math.min(heldStack.func_190916_E(), maxInsert), dragType == 1 ? 1 : 64);
                        ((TileReactorCore)this.tile).convertedFuel.add((double)(insert * value));
                        heldStack.func_190918_g(insert);
                    }
                }
                if (heldStack.func_190916_E() <= 0) {
                    inventory.func_70437_b(ItemStack.field_190927_a);
                }
            } else if (!stackInSlot.func_190926_b()) {
                ((TileReactorCore)this.tile).reactableFuel.subtract((double)this.getFuelValue(stackInSlot));
                ((TileReactorCore)this.tile).convertedFuel.subtract((double)this.getChaosValue(stackInSlot));
                inventory.func_70437_b(stackInSlot);
            }
            return ItemStack.field_190927_a;
        }
        if (slotId <= 35) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        return ItemStack.field_190927_a;
    }

    private int getFuelValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == DEContent.block_draconium_awakened.func_199767_j()) {
            return stack.func_190916_E() * 1296;
        }
        if (stack.func_77973_b() == DEContent.ingot_draconium_awakened) {
            return stack.func_190916_E() * 144;
        }
        if (stack.func_77973_b() == DEContent.nugget_draconium_awakened) {
            return stack.func_190916_E() * 16;
        }
        return 0;
    }

    private int getChaosValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == DEContent.chaos_frag_large) {
            return stack.func_190916_E() * 1296;
        }
        if (stack.func_77973_b() == DEContent.chaos_frag_medium) {
            return stack.func_190916_E() * 144;
        }
        if (stack.func_77973_b() == DEContent.chaos_frag_small) {
            return stack.func_190916_E() * 16;
        }
        return 0;
    }

    public static class SlotReactor
    extends Slot {
        private final TileReactorCore tile;

        public SlotReactor(TileReactorCore tile, int index, int xPosition, int yPosition) {
            super(null, index, xPosition, yPosition);
            this.tile = tile;
        }

        public void func_75220_a(ItemStack before, ItemStack after) {
            int i;
            if (!before.func_190926_b() && !after.func_190926_b() && before.func_77973_b() == after.func_77973_b() && (i = after.func_190916_E() - before.func_190916_E()) > 0) {
                this.func_75210_a(before, i);
            }
        }

        public boolean func_75214_a(@Nullable ItemStack stack) {
            return false;
        }

        @Nullable
        public ItemStack func_75211_c() {
            int index = this.getSlotIndex();
            if (index < 3) {
                int fuel = MathHelper.floor((double)this.tile.reactableFuel.get());
                int block = fuel / 1296;
                int ingot = fuel % 1296 / 144;
                int nugget = fuel % 1296 % 144 / 16;
                if (index == 0 && block > 0) {
                    return new ItemStack((IItemProvider)DEContent.block_draconium_awakened, block);
                }
                if (index == 1 && ingot > 0) {
                    return new ItemStack((IItemProvider)DEContent.ingot_draconium_awakened, ingot);
                }
                if (index == 2 && nugget > 0) {
                    return new ItemStack((IItemProvider)DEContent.nugget_draconium_awakened, nugget);
                }
            } else {
                int chaos = MathHelper.floor((double)this.tile.convertedFuel.get());
                int block = chaos / 1296;
                int ingot = chaos % 1296 / 144;
                int nugget = chaos % 1296 % 144 / 16;
                if (index == 3 && block > 0) {
                    return new ItemStack((IItemProvider)DEContent.chaos_frag_large, block);
                }
                if (index == 4 && ingot > 0) {
                    return new ItemStack((IItemProvider)DEContent.chaos_frag_medium, ingot);
                }
                if (index == 5 && nugget > 0) {
                    return new ItemStack((IItemProvider)DEContent.chaos_frag_small, nugget);
                }
            }
            return ItemStack.field_190927_a;
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            this.func_75218_e();
        }

        public void func_75218_e() {
            this.tile.func_70296_d();
        }

        public int func_75219_a() {
            return 64;
        }

        public ItemStack func_75209_a(int amount) {
            return ItemStack.field_190927_a;
        }
    }
}

