/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.equipment;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.capability.MultiCapabilityProvider;
import com.brandon3055.brandonscore.lib.IEquipmentManager;
import com.brandon3055.draconicevolution.integration.equipment.CuriosIntegration;
import com.brandon3055.draconicevolution.integration.equipment.IDEEquipment;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class EquipmentManager
implements IEquipmentManager {
    private static boolean curiosLoaded;
    private static EquipmentManager instance;

    public static void initialize() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        curiosLoaded = ModList.get().isLoaded("curios");
        if (curiosLoaded) {
            modBus.addListener(CuriosIntegration::sendIMC);
            instance = new CuriosIntegration();
        }
        BrandonsCore.equipmentManager = instance;
    }

    public static boolean equipModLoaded() {
        return instance != null;
    }

    public static String equipModID() {
        if (curiosLoaded) {
            return "curios";
        }
        return "";
    }

    public static void addCaps(ItemStack stack, MultiCapabilityProvider provider) {
        if (instance != null) {
            if (!(stack.func_77973_b() instanceof IDEEquipment)) {
                throw new IllegalStateException("\"Equipment items\" must implement IDEEquipment");
            }
            instance.addEquipCaps(stack, provider);
        }
    }

    public static LazyOptional<IItemHandlerModifiable> getEquipmentInventory(LivingEntity entity) {
        if (instance != null) {
            return instance.getInventory(entity);
        }
        return LazyOptional.empty();
    }

    public static ItemStack findItem(Item item, LivingEntity entity) {
        if (instance != null) {
            return instance.findMatchingItem(item, entity);
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> findItems(Item item, LivingEntity entity) {
        return EquipmentManager.findItems((ItemStack stack) -> stack.func_77973_b() == item, entity);
    }

    public static ItemStack findItem(Predicate<ItemStack> predicate, LivingEntity entity) {
        if (instance != null) {
            return instance.findMatchingItem(predicate, entity);
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> findItems(Predicate<ItemStack> predicate, LivingEntity entity) {
        LazyOptional optionalHandler;
        if (instance != null && (optionalHandler = instance.getInventory(entity)).isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)optionalHandler.orElseThrow(() -> new WTFException("This should not happen"));
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!predicate.test(stack)) continue;
                list.add(stack);
            }
            return ImmutableList.copyOf(list);
        }
        return Collections.emptyList();
    }

    public static List<ItemStack> getAllItems(LivingEntity entity) {
        return EquipmentManager.findItems((ItemStack stack) -> !stack.func_190926_b(), entity);
    }

    static {
        instance = null;
    }
}

