/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.crafttweaker.handler;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.helper.IngredientHelper;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

@IRecipeHandler.For(value=FusionRecipe.class)
public class FusionRecipeHandler
implements IRecipeHandler<FusionRecipe> {
    public String dumpToCommandString(IRecipeManager manager, FusionRecipe recipe) {
        String outputStr = "<recipetype:draconicevolution:fusion_crafting>.addRecipe(%s, %s, %s, %s, TechLevel.%s, [%s]);";
        StringJoiner ingredientJoiner = new StringJoiner(", ");
        for (IFusionRecipe.IFusionIngredient fusionIngredient : recipe.fusionIngredients()) {
            ingredientJoiner.add("FusionIngredient.of(" + IIngredient.fromIngredient((Ingredient)fusionIngredient.get()).getCommandString() + ", " + fusionIngredient.consume() + ")");
        }
        return String.format(outputStr, StringUtils.quoteAndEscape((ResourceLocation)recipe.func_199560_c()), new MCItemStack(recipe.func_77571_b()).getCommandString(), IIngredient.fromIngredient((Ingredient)recipe.getCatalyst()).getCommandString(), recipe.getEnergyCost(), recipe.getRecipeTier().name(), ingredientJoiner);
    }

    public Optional<Function<ResourceLocation, FusionRecipe>> replaceIngredients(IRecipeManager manager, FusionRecipe recipe, List<IReplacementRule> rules) {
        List iFusionIngredients = recipe.fusionIngredients().stream().map(iFusionIngredient -> (FusionRecipe.FusionIngredient)iFusionIngredient).collect(Collectors.toList());
        return ReplacementHandlerHelper.replaceIngredientList(iFusionIngredients, FusionRecipe.FusionIngredient.class, (IRecipe)recipe, rules, newIngredients -> id -> new FusionRecipe((ResourceLocation)id, recipe.func_77571_b(), recipe.getCatalyst(), recipe.getEnergyCost(), recipe.getRecipeTier(), (Collection<FusionRecipe.FusionIngredient>)newIngredients));
    }

    public <U extends IRecipe<?>> boolean doesConflict(IRecipeManager manager, FusionRecipe firstRecipe, U secondRecipe) {
        FusionRecipe second = (FusionRecipe)secondRecipe;
        if (firstRecipe.fusionIngredients().size() != second.fusionIngredients().size()) {
            return false;
        }
        if (!IngredientHelper.canConflict((Ingredient)firstRecipe.getCatalyst(), (Ingredient)second.getCatalyst())) {
            return false;
        }
        List<FusionRecipe.FusionIngredient> firstIngredients = firstRecipe.fusionIngredients().stream().map(iFusionIngredient -> (FusionRecipe.FusionIngredient)iFusionIngredient).collect(Collectors.toList());
        List<FusionRecipe.FusionIngredient> secondIngredients = second.fusionIngredients().stream().map(iFusionIngredient -> (FusionRecipe.FusionIngredient)iFusionIngredient).collect(Collectors.toList());
        return this.craftVirtually(firstIngredients, secondIngredients);
    }

    private boolean craftVirtually(List<FusionRecipe.FusionIngredient> first, List<FusionRecipe.FusionIngredient> second) {
        BitSet visitData = new BitSet(second.size());
        block0: for (FusionRecipe.FusionIngredient target : first) {
            for (int i = 0; i < second.size(); ++i) {
                if (visitData.get(i)) continue;
                FusionRecipe.FusionIngredient attempt = second.get(i);
                if (!IngredientHelper.canConflict((Ingredient)target.get(), (Ingredient)attempt.get())) continue;
                visitData.set(i);
                continue block0;
            }
        }
        return visitData.nextClearBit(0) == second.size();
    }
}

