/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.ModuleProvider;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public class ModCapabilities {
    public static void register() {
        CapabilityManager.INSTANCE.register(ModuleProvider.class, new NullStorage(), () -> null);
        CapabilityManager.INSTANCE.register(ModuleHost.class, new SerializableStorage(), () -> null);
        CapabilityManager.INSTANCE.register(PropertyProvider.class, new SerializableStorage(), () -> null);
    }

    private static class SerializableStorage<T extends INBTSerializable<CompoundNBT>>
    implements Capability.IStorage<T> {
        private SerializableStorage() {
        }

        @Nullable
        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            instance.deserializeNBT((INBT)((CompoundNBT)nbt));
        }
    }

    private static class NullStorage<T extends ModuleProvider<?>>
    implements Capability.IStorage<T> {
        private NullStorage() {
        }

        public INBT writeNBT(Capability<T> capability, T instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
        }
    }
}

