/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.api.DislocatorEndPoint;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TileTarget
extends DislocatorTarget {
    private BlockPos tilePos;

    public TileTarget(DislocatorEndPoint endPoint) {
        super((RegistryKey<World>)((TileEntity)endPoint).func_145831_w().func_234923_W_());
        this.tilePos = ((TileEntity)endPoint).func_174877_v();
    }

    public TileTarget(RegistryKey<World> world) {
        super(world);
    }

    private DislocatorEndPoint getEndPoint(ServerWorld world) {
        TileEntity tile = world.func_175625_s(this.tilePos);
        if (tile instanceof DislocatorEndPoint) {
            return (DislocatorEndPoint)tile;
        }
        return null;
    }

    @Override
    public TargetPos getTargetPos(MinecraftServer server, UUID linkID, UUID sourceDislocatorID) {
        Vector3d pos;
        ServerWorld targetWorld = this.getTargetWorld(server);
        DislocatorEndPoint target = this.getEndPoint(targetWorld);
        if (target != null && (pos = target.getArrivalPos(linkID)) != null) {
            Vector2f vec = target.getArrivalFacing(linkID);
            if (vec != null) {
                return new TargetPos(new Vector3(pos), this.worldKey, vec.field_189982_i, vec.field_189983_j);
            }
            return new TargetPos(new Vector3(pos), this.worldKey).setIncludeHeading(false);
        }
        return null;
    }

    @Override
    public void preTeleport(MinecraftServer server, Entity entity) {
        ServerWorld targetWorld = this.getTargetWorld(server);
        DislocatorEndPoint target = this.getEndPoint(targetWorld);
        if (target != null) {
            target.entityArriving(entity);
        }
    }

    public BlockPos getTilePos() {
        return this.tilePos;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_74768_a("x", this.tilePos.func_177958_n());
        nbt.func_74768_a("y", this.tilePos.func_177956_o());
        nbt.func_74768_a("z", this.tilePos.func_177952_p());
        return super.save(nbt);
    }

    @Override
    protected void loadInternal(CompoundNBT nbt) {
        super.loadInternal(nbt);
        this.tilePos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
    }

    @Override
    public DislocatorTarget.TargetType getType() {
        return DislocatorTarget.TargetType.TILE;
    }
}

